/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import tigase.stats.JMXProxyListener;
import tigase.stats.StatisticsProviderMBean;

public class JavaJMXProxy
implements StatisticsProviderMBean,
NotificationListener {
    private static final Logger log = Logger.getLogger(JavaJMXProxy.class.getName());
    private float clCompressionRatio = 0.0f;
    private int clIOQueueSize = 0;
    private long clNetworkBytes = 0L;
    private float clNetworkBytesPerSec = 0.0f;
    private float clPacketsPerSec = 0.0f;
    private int clQueueSize = 0;
    private float[] clpacks_history = null;
    private int clusterCacheSize = 0;
    private long clusterPacketsNumber = 0L;
    private int connectionsNumber = 0;
    private int[] conns_history = null;
    private int cpuNo = 0;
    private float cpuUsage = 0.0f;
    private float[] cpu_history = null;
    private long delay = -1L;
    private float heapUsage = 0.0f;
    private float[] heap_history = null;
    private String hostname = null;
    private String id = null;
    private long interval = -1L;
    private long iqAuthNumber = 0L;
    private long iqOtherNumber = 0L;
    private float iqOtherPerSec = 0.0f;
    private JMXServiceURL jmxUrl = null;
    private JMXConnector jmxc = null;
    private long lastCacheUpdate = 0L;
    private long messagesNumber = 0L;
    private float messagesPerSec = 0.0f;
    private float nonHeapUsage = 0.0f;
    private String password = null;
    private int port = -1;
    private long presencesNumber = 0L;
    private float presencesPerSec = 0.0f;
    private long processCPUTime = 0L;
    private long queueOverflow = 0L;
    private int queueSize = 0;
    private MBeanServerConnection server = null;
    private int serverConnections = 0;
    private int[] serverConnectionsHistory = null;
    private List<JMXProxyListener> listeners = new LinkedList<JMXProxyListener>();
    private long smPacketsNumber = 0L;
    private float smPacketsPerSec = 0.0f;
    private int smQueueSize = 0;
    private float[] smpacks_history = null;
    private String sysDetails = "No details loaded yet";
    private StatisticsProviderMBean tigBean = null;
    private StatisticsUpdater updater = null;
    private long uptime = 0L;
    private String urlPath = null;
    private String userName = null;
    private boolean loadHistory = false;
    private boolean initialized = false;

    public JavaJMXProxy(String id, String hostname, int port, String userName, String password, long delay, long interval, boolean loadHistory) {
        this.id = id;
        this.hostname = hostname;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.delay = delay;
        this.interval = interval;
        this.urlPath = "/jndi/rmi://" + this.hostname + ":" + this.port + "/jmxrmi";
        this.loadHistory = loadHistory;
        System.out.println("Created: " + hostname);
    }

    public void addJMXProxyListener(JMXProxyListener listener) {
        this.listeners.add(listener);
    }

    public void connect() throws Exception {
        this.jmxUrl = new JMXServiceURL("rmi", "", 0, this.urlPath);
        String[] userCred = new String[]{this.userName, this.password};
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", userCred);
        this.jmxc = JMXConnectorFactory.newJMXConnector(this.jmxUrl, env);
        this.jmxc.addConnectionNotificationListener(this, null, null);
        this.jmxc.connect();
    }

    @Override
    public Map<String, String> getAllStats(int level) {
        if (this.tigBean != null) {
            return this.tigBean.getAllStats(level);
        }
        return null;
    }

    @Override
    public int getCLIOQueueSize() {
        return this.clIOQueueSize;
    }

    @Override
    public float[] getCLPacketsPerSecHistory() {
        return this.clpacks_history;
    }

    @Override
    public int getCLQueueSize() {
        return this.clQueueSize;
    }

    @Override
    public float getCPUUsage() {
        return this.cpuUsage;
    }

    @Override
    public float[] getCPUUsageHistory() {
        return this.cpu_history;
    }

    @Override
    public int getCPUsNumber() {
        return this.cpuNo;
    }

    @Override
    public int getClusterCacheSize() {
        return this.clusterCacheSize;
    }

    @Override
    public float getClusterCompressionRatio() {
        return this.clCompressionRatio;
    }

    @Override
    public long getClusterNetworkBytes() {
        return this.clNetworkBytes;
    }

    @Override
    public float getClusterNetworkBytesPerSecond() {
        return this.clNetworkBytesPerSec;
    }

    @Override
    public long getClusterPackets() {
        return this.clusterPacketsNumber;
    }

    @Override
    public float getClusterPacketsPerSec() {
        return this.clPacketsPerSec;
    }

    @Override
    public Map<String, String> getComponentStats(String compName, int level) {
        if (this.tigBean != null) {
            return this.tigBean.getComponentStats(compName, level);
        }
        return null;
    }

    @Override
    public List getComponentsNames() {
        if (this.tigBean != null) {
            return this.tigBean.getComponentsNames();
        }
        return null;
    }

    @Override
    public int getConnectionsNumber() {
        return this.connectionsNumber;
    }

    @Override
    public int[] getConnectionsNumberHistory() {
        return this.conns_history;
    }

    @Override
    public float getHeapMemUsage() {
        return this.heapUsage;
    }

    @Override
    public float[] getHeapUsageHistory() {
        return this.heap_history;
    }

    @Override
    public long getIQAuthNumber() {
        return this.iqAuthNumber;
    }

    @Override
    public long getIQOtherNumber() {
        return this.iqOtherNumber;
    }

    @Override
    public float getIQOtherNumberPerSec() {
        return this.iqOtherPerSec;
    }

    public String getId() {
        return this.id;
    }

    public long getLastCacheUpdate() {
        return this.lastCacheUpdate;
    }

    @Override
    public long getMessagesNumber() {
        return this.messagesNumber;
    }

    @Override
    public float getMessagesNumberPerSec() {
        return this.messagesPerSec;
    }

    @Override
    public String getName() {
        if (this.tigBean != null) {
            return this.tigBean.getName();
        }
        return null;
    }

    @Override
    public float getNonHeapMemUsage() {
        return this.nonHeapUsage;
    }

    @Override
    public long getPresencesNumber() {
        return this.presencesNumber;
    }

    @Override
    public float getPresencesNumberPerSec() {
        return this.presencesPerSec;
    }

    @Override
    public long getProcesCPUTime() {
        return this.processCPUTime;
    }

    @Override
    public long getQueueOverflow() {
        return this.queueOverflow;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public long getSMPacketsNumber() {
        return this.smPacketsNumber;
    }

    @Override
    public float getSMPacketsNumberPerSec() {
        return this.smPacketsPerSec;
    }

    @Override
    public float[] getSMPacketsPerSecHistory() {
        return this.smpacks_history;
    }

    @Override
    public int getSMQueueSize() {
        return this.smQueueSize;
    }

    @Override
    public int getServerConnections() {
        return this.serverConnections;
    }

    @Override
    public int[] getServerConnectionsHistory() {
        return this.serverConnectionsHistory;
    }

    @Override
    public String getSystemDetails() {
        return this.sysDetails;
    }

    @Override
    public long getUptime() {
        return this.uptime;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("jmx.remote.connection.opened")) {
            System.out.println("Connected: " + this.hostname);
            try {
                this.server = this.jmxc.getMBeanServerConnection();
                ObjectName obn = new ObjectName("tigase.stats:type=StatisticsProvider");
                this.tigBean = MBeanServerInvocationHandler.newProxyInstance(this.server, obn, StatisticsProviderMBean.class, false);
                if (this.loadHistory) {
                    this.cpu_history = this.tigBean.getCPUUsageHistory();
                    System.out.println(this.hostname + " loaded cpu_history, size: " + this.cpu_history.length);
                    this.heap_history = this.tigBean.getHeapUsageHistory();
                    System.out.println(this.hostname + " loaded heap_history, size: " + this.heap_history.length);
                    this.smpacks_history = this.tigBean.getSMPacketsPerSecHistory();
                    System.out.println(this.hostname + " loaded smpacks_history, size: " + this.smpacks_history.length);
                    this.clpacks_history = this.tigBean.getCLPacketsPerSecHistory();
                    System.out.println(this.hostname + " loaded clpacks_history, size: " + this.clpacks_history.length);
                    this.conns_history = this.tigBean.getConnectionsNumberHistory();
                    System.out.println(this.hostname + " loaded conns_history, size: " + this.conns_history.length);
                    this.serverConnectionsHistory = this.tigBean.getServerConnectionsHistory();
                    System.out.println(this.hostname + " loaded server_conns_history, size: " + this.serverConnectionsHistory.length);
                } else {
                    System.out.println(this.hostname + " loading history switched off.");
                }
                for (JMXProxyListener jMXProxyListener : this.listeners) {
                    jMXProxyListener.connected(this.id, this);
                }
                this.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (notification.getType().equals("jmx.remote.connection.closed")) {
            this.server = null;
            this.tigBean = null;
            for (JMXProxyListener jMXProxyListener : this.listeners) {
                jMXProxyListener.disconnected(this.id);
            }
            return;
        }
        if (notification.getType().equals("jmx.remote.connection.failed")) {
            System.out.println("Reconnection to {hostName} failed...");
            return;
        }
        System.out.println("Unsupported JMX notification: {notification.getType()}");
    }

    public boolean isConnected() {
        return this.tigBean != null;
    }

    public boolean isInitialized() {
        return this.isConnected() && this.initialized;
    }

    public void start() {
        if (this.updater == null) {
            this.updater = new StatisticsUpdater();
            System.out.println("Started: " + this.hostname);
        }
    }

    public void update() {
        if (this.tigBean != null) {
            if (this.cpuNo == 0) {
                this.cpuNo = this.tigBean.getCPUsNumber();
            }
            this.uptime = this.tigBean.getUptime();
            this.processCPUTime = this.tigBean.getProcesCPUTime();
            this.connectionsNumber = this.tigBean.getConnectionsNumber();
            this.serverConnections = this.tigBean.getServerConnections();
            this.clusterCacheSize = this.tigBean.getClusterCacheSize();
            this.queueSize = this.tigBean.getQueueSize();
            this.smQueueSize = this.tigBean.getSMQueueSize();
            this.clQueueSize = this.tigBean.getCLQueueSize();
            this.clIOQueueSize = this.tigBean.getCLIOQueueSize();
            this.queueOverflow = this.tigBean.getQueueOverflow();
            this.smPacketsNumber = this.tigBean.getSMPacketsNumber();
            this.clusterPacketsNumber = this.tigBean.getClusterPackets();
            this.messagesNumber = this.tigBean.getMessagesNumber();
            this.presencesNumber = this.tigBean.getPresencesNumber();
            this.smPacketsPerSec = this.tigBean.getSMPacketsNumberPerSec();
            this.clPacketsPerSec = this.tigBean.getClusterPacketsPerSec();
            this.messagesPerSec = this.tigBean.getMessagesNumberPerSec();
            this.presencesPerSec = this.tigBean.getPresencesNumberPerSec();
            this.cpuUsage = this.tigBean.getCPUUsage();
            this.heapUsage = this.tigBean.getHeapMemUsage();
            this.nonHeapUsage = this.tigBean.getNonHeapMemUsage();
            this.sysDetails = this.tigBean.getSystemDetails();
            this.clCompressionRatio = this.tigBean.getClusterCompressionRatio();
            this.clNetworkBytes = this.tigBean.getClusterNetworkBytes();
            this.clNetworkBytesPerSec = this.tigBean.getClusterNetworkBytesPerSecond();
            this.lastCacheUpdate = System.currentTimeMillis();
            this.initialized = true;
        }
    }

    private class StatisticsUpdater {
        private Timer updateTimer = new Timer("stats-updater", true);

        private StatisticsUpdater() {
            this.updateTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (JavaJMXProxy.this.server == null) {
                            JavaJMXProxy.this.connect();
                        }
                        if (JavaJMXProxy.this.server != null) {
                            JavaJMXProxy.this.update();
                        }
                    }
                    catch (IOException e) {
                        Throwable cause = e;
                        while (cause.getCause() != null) {
                            cause = cause.getCause();
                        }
                        log.warning(cause.getMessage() + ", retrying in " + JavaJMXProxy.this.interval / 1000L + " seconds.");
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem retrieving statistics: ", e);
                    }
                }
            }, JavaJMXProxy.this.delay, JavaJMXProxy.this.interval);
        }
    }
}

