/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.XMPPServer;
import tigase.stats.StatisticsArchivizerIfc;
import tigase.stats.StatisticsProvider;
import tigase.sys.TigaseRuntime;
import tigase.util.JDBCAbstract;

public class CounterDataArchivizer
extends JDBCAbstract
implements StatisticsArchivizerIfc {
    private static final Logger log = Logger.getLogger(CounterDataArchivizer.class.getName());
    public static final String DB_URL_PROP_KEY = "db-url";
    public static final String TABLE_NAME_PROP_KEY = "table-name";
    public static final String KEY_FIELD_PROP_KEY = "key-field";
    public static final String VAL_FIELD_PROP_KEY = "val-field";
    private static final String DEF_TABLE_NAME = "counter_data";
    private static final String DEF_KEY_FIELD_NAME = "counter_name";
    private static final String DEF_VALUE_FIELD_NAME = "counter_value";
    private static final String USER_CONNECTIONS_TEXT = "Connections c2s: ";
    private static final String SERVER_CONNECTIONS_TEXT = "Connections s2s: ";
    private static final String CPU_USAGE_TEXT = "Usage CPU [%]: ";
    private static final String MEM_USAGE_TEXT = "Usage RAM [%]: ";
    private static final String UPTIME_TEXT = "Uptime: ";
    private static final String VERSION_TEXT = "Version: ";
    private PreparedStatement initEntry = null;
    private String tableName = "counter_data";
    private String keyField = "counter_name";
    private PreparedStatement updateEntry = null;
    private String valueField = "counter_value";

    @Override
    public void execute(StatisticsProvider sp) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        this.initData(CPU_USAGE_TEXT, format.format(sp.getCPUUsage()));
        this.initData(MEM_USAGE_TEXT, format.format(sp.getHeapMemUsage()));
        format = NumberFormat.getIntegerInstance();
        this.initData(USER_CONNECTIONS_TEXT, format.format(sp.getConnectionsNumber()));
        this.initData(SERVER_CONNECTIONS_TEXT, format.format(sp.getServerConnections()));
        this.initData(UPTIME_TEXT, TigaseRuntime.getTigaseRuntime().getUptimeString());
    }

    @Override
    public void init(Map<String, Object> conf) {
        String prop = (String)conf.get(TABLE_NAME_PROP_KEY);
        if (prop != null) {
            this.tableName = prop;
        }
        if ((prop = (String)conf.get(KEY_FIELD_PROP_KEY)) != null) {
            this.keyField = prop;
        }
        if ((prop = (String)conf.get(VAL_FIELD_PROP_KEY)) != null) {
            this.valueField = prop;
        }
        try {
            this.initRepository((String)conf.get(DB_URL_PROP_KEY), null);
            this.initData(VERSION_TEXT, XMPPServer.getImplementationVersion());
            this.initData(CPU_USAGE_TEXT, "0");
            this.initData(MEM_USAGE_TEXT, "0");
            this.initData(USER_CONNECTIONS_TEXT, "0");
            this.initData(SERVER_CONNECTIONS_TEXT, "0");
            this.initData(UPTIME_TEXT, TigaseRuntime.getTigaseRuntime().getUptimeString());
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Cannot initialize connection to database: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initData(String key, String value) {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.initEntry;
            synchronized (preparedStatement) {
                this.initEntry.setString(1, key);
                this.initEntry.setString(2, value);
                this.initEntry.setString(3, value);
                this.initEntry.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        this.setResourceUri(conn_str);
        this.checkConnection();
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(String key, String value) {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.updateEntry;
            synchronized (preparedStatement) {
                this.updateEntry.setString(1, value);
                this.updateEntry.setString(2, key);
                this.updateEntry.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding new entry to DB: ", e);
        }
    }

    protected void initPreparedStatements() throws SQLException {
        super.initPreparedStatements();
        String query = "insert into " + this.tableName + " (" + this.keyField + ", " + this.valueField + ") " + " values (?, ?) on duplicate key update " + this.valueField + " = ?";
        this.initEntry = this.prepareStatement(query);
        query = "update " + this.tableName + " set " + this.valueField + " = ? where " + this.keyField + " = ?";
        this.updateEntry = this.prepareStatement(query);
    }
}

