/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.gateways;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserExistsException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.gateways.GatewayConnection;
import tigase.server.gateways.GatewayException;
import tigase.server.gateways.GatewayListener;
import tigase.server.gateways.RosterItem;
import tigase.util.DBUtils;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class Gateway
extends AbstractMessageReceiver
implements Configurable,
XMPPService,
GatewayListener {
    private static final String AUTHORIZED_KEY = "authorized-key";
    public static final String GEN_GW_ADMINS = "--gen-gw-admins";
    public static final String GEN_GW_DB = "--gen-gw-db";
    public static final String GEN_GW_DB_URI = "--gen-gw-db-uri";
    public static final String GW_CLASS_NAME_PROP_KEY = "gw-class-name";
    public static final String GW_CLASS_NAME_PROP_VAL = "tigase.extras.gateway.MsnConnection";
    public static final String GW_DOMAIN_NAME_PROP_KEY = "gw-domain-name";
    public static final String GW_DOMAIN_NAME_PROP_VAL = "msn.localhost";
    public static final String GW_MODERATED_PROP_KEY = "is-moderated";
    public static final String GW_REPO_CLASS_PROP_KEY = "gw-repo-class";
    public static final String GW_REPO_URL_PROP_KEY = "gw-repo-url";
    private static final String NAME_KEY = "authorized-key";
    private static final String PRESENCE_ELNAME = "presence";
    private static final String PRESENCE_SHOW = "presence-show";
    private static final String PRESENCE_TYPE = "presence-type";
    private static Logger log = Logger.getLogger("tigase.server.gateways.Gateway");
    public static final boolean GW_MODERATED_PROP_VAL = false;
    private static final String moderated_false = "false";
    private static final String moderated_key = "moderated-key";
    private static final String moderated_true = "true";
    private static final String password_key = "password-key";
    private static final String username_key = "user-name-key";
    private String[] ADMINS_PROP_VAL = new String[]{"admin@localhost", "admin@hostname"};
    private String gw_desc = "empty";
    private String gw_name = "Undefined";
    private String gw_type = "unknown";
    private UserRepository repository = null;
    private ServiceEntity serviceEntity = null;
    private boolean is_moderated = false;
    private Map<String, GatewayConnection> gw_connections = new LinkedHashMap<String, GatewayConnection>();
    private String gw_class_name = "tigase.extras.gateway.MsnConnection";
    private String[] admins = this.ADMINS_PROP_VAL;

    @Override
    public String decodeLegacyName(String jid) {
        return jid.split("@")[0].replace("%", "@");
    }

    @Override
    public String formatJID(String legacyName) {
        return XMLUtils.escape((String)(legacyName.replace("@", "%") + "@" + this.getComponentId()));
    }

    @Override
    public void gatewayException(GatewayConnection gc, Throwable exc) {
        log.log(Level.WARNING, "Gateway exception", exc);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String repo_class = "tigase.db.xml.XMLRepository";
        String repo_uri = "user-repository.xml";
        String[] db_params = DBUtils.decodeDBParams(params, GEN_GW_DB, "--user-db");
        if (db_params[0] != null) {
            repo_class = db_params[0];
        }
        if (db_params[1] != null) {
            repo_uri = db_params[1];
        }
        if (params.get(GEN_GW_DB_URI) != null) {
            repo_uri = (String)params.get(GEN_GW_DB_URI);
        } else if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(GW_REPO_CLASS_PROP_KEY, repo_class);
        defs.put(GW_REPO_URL_PROP_KEY, repo_uri);
        if (params.get(GEN_GW_ADMINS) != null) {
            this.ADMINS_PROP_VAL = ((String)params.get(GEN_GW_ADMINS)).split(",");
        } else if (params.get("--admins") != null) {
            this.ADMINS_PROP_VAL = ((String)params.get("--admins")).split(",");
        } else {
            this.ADMINS_PROP_VAL = new String[1];
            this.ADMINS_PROP_VAL[0] = "admin@" + this.getDefHostName();
        }
        defs.put("admins", this.ADMINS_PROP_VAL);
        defs.put(GW_CLASS_NAME_PROP_KEY, GW_CLASS_NAME_PROP_VAL);
        defs.put(GW_MODERATED_PROP_KEY, false);
        defs.put(GW_DOMAIN_NAME_PROP_KEY, GW_DOMAIN_NAME_PROP_VAL);
        return defs;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && jid.toString().startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (jid.toString().startsWith(this.getName() + ".")) {
            return this.serviceEntity.getDiscoItems(node, null);
        }
        return Arrays.asList(this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid));
    }

    @Override
    public boolean isAdmin(JID jid) {
        for (String adm : this.admins) {
            if (!adm.equals(jid.getBareJID().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loginCompleted(GatewayConnection gc) {
        JID[] jids;
        for (JID username : jids = gc.getAllJids()) {
            try {
                this.addOutPacket(Packet.packetInstance(new Element(PRESENCE_ELNAME, new String[]{"from", "to"}, new String[]{this.getComponentId().toString(), username.toString()})));
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void logout(GatewayConnection gc) {
        JID[] jids;
        for (JID username : jids = gc.getAllJids()) {
            try {
                this.addOutPacket(Packet.packetInstance(new Element(PRESENCE_ELNAME, new String[]{"from", "to", "type"}, new String[]{this.getComponentId().toString(), username.toString(), "unavailable"})));
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
            }
            List<RosterItem> roster = gc.getRoster();
            for (RosterItem item : roster) {
                String from = this.formatJID(item.getBuddyId());
                Element pres_el = new Element(PRESENCE_ELNAME, new String[]{"to", "from", "type"}, new String[]{username.toString(), from, "unavailable"});
                try {
                    Packet presence = Packet.packetInstance(pres_el);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Sending out presence: " + presence);
                    }
                    this.addOutPacket(presence);
                }
                catch (TigaseStringprepException ex) {
                    Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.gw_connections.remove(jids[0]);
    }

    @Override
    public void packetReceived(Packet packet) {
        this.addOutPacket(packet);
    }

    @Override
    public void processPacket(Packet packet) {
        try {
            if (packet.getStanzaTo() == null) {
                log.warning("Bad packet, 'to' is null: " + packet.toString());
                return;
            }
            if (packet.getElemName() == PRESENCE_ELNAME) {
                this.processPresence(packet);
                return;
            }
            if (packet.getStanzaTo().equals((Object)this.getComponentId())) {
                log.fine("Local packet: " + packet.toString());
                this.processLocalPacket(packet);
                return;
            }
            GatewayConnection conn = this.findConnection(packet, false);
            if (conn != null) {
                try {
                    conn.sendMessage(packet);
                }
                catch (GatewayException e) {
                    log.log(Level.WARNING, "Error initializing gateway connection", e);
                }
            } else {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Gateway not connected, sending packet back: " + packet.toString());
                }
                this.addOutPacket(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Gateway is not connected.", true));
            }
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (PacketErrorTypeException e) {
            log.info("This must have been an error already, dropping: " + packet.toString() + ", exception: " + e);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.gw_class_name = (String)props.get(GW_CLASS_NAME_PROP_KEY);
        GatewayConnection gc = this.gwInstance();
        if (gc != null) {
            this.gw_type = gc.getType();
            this.gw_name = gc.getName();
            this.gw_desc = gc.getPromptMessage();
        }
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Transport");
        this.serviceEntity.addIdentities(new ServiceIdentity("gateway", this.gw_type, this.gw_name));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures("jabber:iq:register", "jabber:iq:gateway");
        this.admins = (String[])props.get("admins");
        Arrays.sort(this.admins);
        this.is_moderated = (Boolean)props.get(GW_MODERATED_PROP_KEY);
        try {
            String cls_name = (String)props.get(GW_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(GW_REPO_URL_PROP_KEY);
            this.repository = RepositoryFactory.getUserRepository(this.getName(), cls_name, res_uri, null);
            try {
                this.repository.addUser(this.getComponentId().toString());
            }
            catch (UserExistsException e) {}
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize repository", e);
        }
    }

    @Override
    public void updateStatus(GatewayConnection gc, RosterItem item) {
        JID[] jids = gc.getAllJids();
        JID id = jids[0];
        String from = this.formatJID(item.getBuddyId());
        String roster_node = id.toString() + "/roster/" + item.getBuddyId();
        try {
            if (item.getStatus().getType() != null) {
                this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_TYPE, item.getStatus().getType());
            } else {
                this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_TYPE, "null");
            }
            if (item.getStatus().getShow() != null) {
                this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_SHOW, item.getStatus().getShow());
            } else {
                this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_SHOW, "null");
            }
        }
        catch (TigaseDBException e) {
            log.log(Level.WARNING, "Problem updating repository data", e);
        }
        for (JID username : jids) {
            Element pres_el = new Element(PRESENCE_ELNAME, new String[]{"to", "from"}, new String[]{username.toString(), from});
            if (item.getStatus().getType() != null) {
                pres_el.setAttribute("type", item.getStatus().getType());
            }
            if (item.getStatus().getShow() != null) {
                Element show = new Element("show", item.getStatus().getShow());
                pres_el.addChild((XMLNodeIfc)show);
            }
            try {
                Packet presence = Packet.packetInstance(pres_el);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending out presence: " + presence);
                }
                this.addOutPacket(presence);
            }
            catch (TigaseStringprepException ex) {
                Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void userRoster(GatewayConnection gc) {
        JID[] jids = gc.getAllJids();
        JID id = jids[0];
        List<RosterItem> roster = gc.getRoster();
        for (RosterItem item : roster) {
            log.fine("Received roster entry: " + item.getBuddyId());
            String from = this.formatJID(item.getBuddyId());
            String roster_node = id.toString() + "/roster/" + item.getBuddyId();
            String authorized = moderated_false;
            try {
                authorized = this.repository.getData(this.getComponentId().toString(), roster_node, "authorized-key");
                if (authorized == null) {
                    authorized = moderated_false;
                    this.repository.setData(this.getComponentId().toString(), roster_node, "authorized-key", authorized);
                    this.repository.setData(this.getComponentId().toString(), roster_node, "authorized-key", item.getName());
                }
                if (item.getStatus().getType() != null) {
                    this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_TYPE, item.getStatus().getType());
                } else {
                    this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_TYPE, "null");
                }
                if (item.getStatus().getShow() != null) {
                    this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_SHOW, item.getStatus().getShow());
                } else {
                    this.repository.setData(this.getComponentId().toString(), roster_node, PRESENCE_SHOW, "null");
                }
            }
            catch (TigaseDBException e) {
                log.log(Level.WARNING, "Problem updating repository data", e);
            }
            for (JID username : jids) {
                try {
                    Packet presence = Packet.packetInstance(new Element(PRESENCE_ELNAME, new String[]{"to", "from", "type"}, new String[]{username.toString(), from, "subscribe"}));
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Sending out presence: " + presence);
                    }
                    this.addOutPacket(presence);
                }
                catch (TigaseStringprepException ex) {
                    Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        try {
            this.updateRosterPresence(roster, jids);
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(Gateway.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void closeConnection(GatewayConnection conn) {
        if (conn != null) {
            conn.logout();
        }
    }

    private GatewayConnection findConnection(Packet packet, boolean create) throws TigaseStringprepException {
        JID id = packet.getStanzaFrom().copyWithoutResource();
        GatewayConnection conn = this.gw_connections.get(id.toString());
        if (conn != null || !create) {
            if (conn != null) {
                conn.addJid(packet.getStanzaFrom());
                this.addOutPacket(Packet.packetInstance(new Element(PRESENCE_ELNAME, new String[]{"from", "to"}, new String[]{this.getComponentId().toString(), packet.getStanzaFrom().toString()}), this.getComponentId(), packet.getStanzaFrom()));
                this.updateRosterPresence(conn.getRoster(), packet.getStanzaFrom());
            }
            return conn;
        }
        try {
            String moderated;
            if (this.is_moderated && ((moderated = this.repository.getData(this.getComponentId().toString(), id.toString(), moderated_key)) == null || moderated.equals(moderated_true))) {
                this.addOutPacket(Authorization.NOT_ALLOWED.getResponseMessage(packet, "Administrator approval awaiting.", true));
                return null;
            }
            String username = this.repository.getData(this.getComponentId().toString(), id.toString(), username_key);
            String password = this.repository.getData(this.getComponentId().toString(), id.toString(), password_key);
            if (username != null && password != null) {
                conn = this.gwInstance();
                conn.setGatewayListener(this);
                conn.setLogin(username, password);
                conn.addJid(packet.getStanzaFrom());
                conn.init();
                conn.login();
                this.gw_connections.put(id.toString(), conn);
                return conn;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error initializing gateway connection", e);
        }
        return null;
    }

    private GatewayConnection gwInstance() {
        try {
            Class<?> cls = Class.forName(this.gw_class_name);
            GatewayConnection gc = (GatewayConnection)cls.newInstance();
            return gc;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "Problem instantating gateway connection object", e);
            return null;
        }
    }

    private void processGateway(Packet packet) throws PacketErrorTypeException {
        if (packet.getType() == null) {
            log.info("Bad gateway request: " + packet.toString());
            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(packet, "IQ request must have either 'set' or 'get' type.", true));
            return;
        }
        if (packet.getType() == StanzaType.get) {
            Element query = new Element("query");
            query.setXMLNS("jabber:iq:gateway");
            query.addChild((XMLNodeIfc)new Element("desc", this.gw_desc));
            query.addChild((XMLNodeIfc)new Element("prompt"));
            this.addOutPacket(packet.okResult(query, 0));
        }
        if (packet.getType() == StanzaType.set) {
            String legacyName = packet.getElemCData("/iq/query/prompt");
            String jid = this.formatJID(legacyName);
            this.addOutPacket(packet.okResult(new Element("prompt", jid), 1));
        }
    }

    private void processLocalPacket(Packet packet) throws PacketErrorTypeException, TigaseStringprepException {
        if (packet.isXMLNS("/iq/query", "jabber:iq:register")) {
            this.processRegister(packet);
        }
        if (packet.isXMLNS("/iq/query", "jabber:iq:gateway")) {
            this.processGateway(packet);
        }
    }

    private void processPresence(Packet packet) throws TigaseStringprepException {
        if (packet.getStanzaTo().toString().startsWith(this.getName() + ".") && !packet.getStanzaTo().toString().contains("@")) {
            if (packet.getType() == null || packet.getType() == StanzaType.available) {
                this.findConnection(packet, true);
                return;
            }
            if (packet.getType() == StanzaType.subscribe) {
                this.addOutPacket(packet.swapStanzaFromTo(StanzaType.subscribed));
            }
            if (packet.getType() == StanzaType.unavailable) {
                this.removeJid(packet);
            }
        } else {
            GatewayConnection conn;
            String roster_node;
            String buddy;
            if (packet.getType() == null || packet.getType() == StanzaType.available) {
                return;
            }
            JID id = packet.getStanzaFrom().copyWithoutResource();
            if (packet.getType() == StanzaType.subscribed) {
                this.addOutPacket(packet.swapStanzaFromTo(StanzaType.subscribed));
                buddy = this.decodeLegacyName(packet.getStanzaTo().toString());
                log.fine("Received subscribed presence for: " + buddy);
                roster_node = id + "/roster/" + buddy;
                String authorized = moderated_true;
                String pres_type = "null";
                String pres_show = "null";
                try {
                    this.repository.setData(this.getComponentId().toString(), roster_node, "authorized-key", authorized);
                    pres_type = this.repository.getData(this.getComponentId().toString(), roster_node, PRESENCE_TYPE);
                    pres_show = this.repository.getData(this.getComponentId().toString(), roster_node, PRESENCE_SHOW);
                    log.fine("Added buddy do repository for: " + buddy);
                }
                catch (TigaseDBException e) {
                    log.log(Level.WARNING, "Problem updating repository data", e);
                }
                Element pres_el = new Element(PRESENCE_ELNAME, new String[]{"to", "from"}, new String[]{packet.getStanzaFrom().toString(), packet.getStanzaTo().toString()});
                if (!pres_type.equals("null")) {
                    pres_el.setAttribute("type", pres_type);
                }
                if (!pres_show.equals("null")) {
                    Element show = new Element("show", pres_show);
                    pres_el.addChild((XMLNodeIfc)show);
                }
                Packet presence = Packet.packetInstance(pres_el, packet.getStanzaTo(), packet.getStanzaFrom());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending out presence: " + presence.toString());
                }
                this.addOutPacket(presence);
            }
            if (packet.getType() == StanzaType.subscribe) {
                this.addOutPacket(packet.swapStanzaFromTo(StanzaType.subscribe));
                buddy = this.decodeLegacyName(packet.getStanzaTo().toString());
                log.fine("Received subscribe presence for: " + buddy);
                String nick = BareJID.parseJID((String)buddy)[0];
                if (nick == null || nick.isEmpty()) {
                    nick = buddy;
                }
                if ((conn = this.findConnection(packet, true)) != null) {
                    try {
                        conn.addBuddy(buddy, nick);
                        log.fine("Added to roster buddy: " + buddy);
                    }
                    catch (GatewayException e) {
                        log.log(Level.WARNING, "Problem with gateway when adding buddy: " + buddy, e);
                    }
                }
            }
            if (packet.getType() == StanzaType.unsubscribe) {
                Packet presence = packet.swapStanzaFromTo(StanzaType.unsubscribe);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending out presence: " + presence.toString());
                }
                this.addOutPacket(presence);
            }
            if (packet.getType() == StanzaType.unsubscribed) {
                this.addOutPacket(packet.swapStanzaFromTo(StanzaType.unsubscribe));
                this.addOutPacket(packet.swapStanzaFromTo(StanzaType.unsubscribed));
                buddy = this.decodeLegacyName(packet.getStanzaTo().toString());
                roster_node = id + "/roster/" + buddy;
                log.fine("Received unsubscribed presence for buddy: " + buddy);
                try {
                    this.repository.removeSubnode(this.getComponentId().toString(), roster_node);
                    log.fine("Removed from repository buddy: " + buddy);
                }
                catch (TigaseDBException e) {
                    log.log(Level.WARNING, "Problem updating repository data", e);
                }
                conn = this.findConnection(packet, true);
                if (conn != null) {
                    try {
                        conn.removeBuddy(buddy);
                        log.fine("Removed from roster buddy: " + buddy);
                    }
                    catch (GatewayException e) {
                        log.log(Level.WARNING, "Problem with gateway when removing buddy: " + buddy, e);
                    }
                }
            }
        }
    }

    private void processRegister(Packet packet) throws PacketErrorTypeException, TigaseStringprepException {
        if (packet.getType() != null) {
            switch (packet.getType()) {
                case get: {
                    this.addOutPacket(packet.okResult("<instructions>Please enter your " + this.gw_type.toUpperCase() + " account details" + " into the fields below." + "</instructions>" + "<username/>" + "<password/>", 1));
                    break;
                }
                case set: {
                    JID jid = packet.getStanzaFrom().copyWithoutResource();
                    String new_username = packet.getElemCData("/iq/query/username");
                    String new_password = packet.getElemCData("/iq/query/password");
                    try {
                        this.repository.setData(this.getComponentId().toString(), jid.toString(), username_key, new_username);
                        this.repository.setData(this.getComponentId().toString(), jid.toString(), password_key, new_password);
                        this.addOutPacket(packet.okResult((String)null, 0));
                        this.addOutPacket(Packet.packetInstance(new Element(PRESENCE_ELNAME, new String[]{"to", "from", "type"}, new String[]{jid.toString(), packet.getStanzaTo().toString(), "subscribe"}), packet.getStanzaTo(), jid));
                        if (this.is_moderated && !this.isAdmin(jid)) {
                            this.repository.setData(this.getComponentId().toString(), jid.toString(), moderated_key, moderated_true);
                            this.addOutPacket(Packet.packetInstance(new Element("message", new Element[]{new Element("body", "Your subscription to the gateway needs administrator approval. You will be notified when your request has been processed and you will be able to use the gateway since then.")}, new String[]{"to", "from", "type", "id"}, new String[]{jid.toString(), packet.getStanzaTo().toString(), "chat", "gw-ap-1"}), packet.getStanzaTo(), jid));
                            this.sendToAdmins(new Element("message", new Element[]{new Element("body", "Gateway subscription request is awaiting for: " + jid)}, new String[]{"from", "type", "id"}, new String[]{packet.getStanzaTo().toString(), "chat", "gw-ap-1"}));
                            break;
                        }
                        this.repository.setData(this.getComponentId().toString(), jid.toString(), moderated_key, moderated_false);
                    }
                    catch (UserNotFoundException e) {
                        log.warning("This is most likely configuration error, please make sure you have set '&autoCreateUser=true' property in your database connection string.");
                        this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Please notify administrator with the message below:\nThis is most likely configuration error, please make sure you have set '&autoCreateUser=true' property in your database connection string.", true));
                    }
                    catch (TigaseDBException e) {
                        log.log(Level.WARNING, "Database access error: ", e);
                        this.addOutPacket(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Please notify administrator with the message below:\nDatabase access error: " + e, true));
                    }
                    break;
                }
            }
        }
    }

    private void removeJid(Packet packet) {
        JID id = packet.getStanzaFrom().copyWithoutResource();
        GatewayConnection conn = this.gw_connections.get(id.toString());
        if (conn != null) {
            log.info("Stopping connection for: " + packet.getStanzaFrom());
            this.gw_connections.remove(id.toString());
            if (conn.getAllJids() == null || conn.getAllJids().length == 0) {
                this.closeConnection(conn);
            }
        } else {
            log.info("No connection for: " + packet.getStanzaFrom());
        }
    }

    private void sendToAdmins(Element elem) throws TigaseStringprepException {
        for (String adm : this.admins) {
            Element msg = elem.clone();
            msg.setAttribute("to", adm);
            this.addOutPacket(Packet.packetInstance(msg));
        }
    }

    private void updateRosterPresence(List<RosterItem> roster, JID ... to) throws TigaseStringprepException {
        if (roster == null) {
            return;
        }
        for (RosterItem item : roster) {
            log.fine("Received roster entry: " + item.getBuddyId());
            String from = this.formatJID(item.getBuddyId());
            for (JID username : to) {
                Element pres_el = new Element(PRESENCE_ELNAME, new String[]{"to", "from"}, new String[]{username.toString(), from});
                if (item.getStatus().getType() != null) {
                    pres_el.setAttribute("type", item.getStatus().getType());
                }
                if (item.getStatus().getShow() != null) {
                    Element show = new Element("show", item.getStatus().getShow());
                    pres_el.addChild((XMLNodeIfc)show);
                }
                Packet presence = Packet.packetInstance(pres_el);
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending out presence: " + presence);
                }
                this.addOutPacket(presence);
            }
        }
    }
}

