/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentConnection;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.StreamOpenHandler;
import tigase.xml.Element;
import tigase.xmpp.XMPPIOService;

public class JabberClientStreamOpenHandler
implements StreamOpenHandler {
    private static final Logger log = Logger.getLogger(JabberClientStreamOpenHandler.class.getName());
    private static final String XMLNS = "jabber:client";
    private String[] xmlnss = new String[]{"jabber:client"};

    @Override
    public String streamOpened(XMPPIOService<List<ComponentConnection>> serv, Map<String, String> attribs, ComponentProtocolHandler handler) {
        switch (serv.connectionType()) {
            case connect: {
                String id = attribs.get("id");
                if (id != null) {
                    serv.getSessionData().put("sessionID", id);
                }
                return null;
            }
            case accept: {
                String from_hostname = attribs.get("from");
                String to_hostname = attribs.get("to");
                CompRepoItem repoItem = handler.getCompRepoItem(from_hostname);
                serv.getSessionData().put("repo-item", repoItem);
                serv.getSessionData().put("hostname-key", from_hostname);
                String id = UUID.randomUUID().toString();
                serv.getSessionData().put("sessionID", id);
                StringBuilder sb = new StringBuilder();
                sb.append("<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' version ='1.0' xml:lang='en' from='" + to_hostname + "'" + " to='" + from_hostname + "'" + " id='" + id + "'" + "><stream:features>");
                List<Element> features = handler.getStreamFeatures(serv);
                for (Element element : features) {
                    sb.append(element.toString());
                }
                sb.append("</stream:features>");
                return sb.toString();
            }
        }
        return null;
    }

    @Override
    public String[] getXMLNSs() {
        return this.xmlnss;
    }

    @Override
    public String serviceStarted(XMPPIOService<List<ComponentConnection>> serv) {
        switch (serv.connectionType()) {
            case connect: {
                CompRepoItem repoItem = (CompRepoItem)serv.getSessionData().get("repo-item");
                serv.getSessionData().put("hostname-key", repoItem.getRemoteHost());
                String data = "<stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' version ='1.0' xml:lang='en' from='" + repoItem.getDomain() + "'" + " to ='" + repoItem.getRemoteHost() + "'" + ">";
                return data;
            }
        }
        return null;
    }
}

