/*
 * Decompiled with CFR 0.152.
 */
package tigase.net;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.BufferUnderflowException;
import tigase.io.IOInterface;
import tigase.io.SocketIO;
import tigase.io.TLSIO;
import tigase.io.TLSUtil;
import tigase.io.TLSWrapper;
import tigase.io.ZLibIO;
import tigase.net.ConnectionType;
import tigase.net.IOServiceListener;
import tigase.stats.StatisticsList;
import tigase.util.TimeUtils;
import tigase.xmpp.JID;

public abstract class IOService<RefObject>
implements Callable<IOService> {
    private static final Logger log = Logger.getLogger("tigase.net.IOService");
    public static final String SESSION_ID_KEY = "sessionID";
    public static final String PORT_TYPE_PROP_KEY = "type";
    public static final String HOSTNAME_KEY = "hostname-key";
    private static final long MAX_ALLOWED_EMPTY_CALLS = 1000L;
    private ConnectionType connectionType = null;
    private JID dataReceiver = null;
    public long empty_read_call_count = 0L;
    private String id = null;
    private int lastMinuteRd = 0;
    private int lastMinuteWr = 0;
    private long lastTransferTime = 0L;
    private String local_address = null;
    private long[] rdData = new long[60];
    private RefObject refObject = null;
    private String remote_address = null;
    private IOServiceListener<IOService<RefObject>> serviceListener = null;
    private IOInterface socketIO = null;
    private ByteBuffer socketInput = null;
    private String sslId = null;
    private boolean stopping = false;
    private long[] wrData = new long[60];
    private ConcurrentMap<String, Object> sessionData = new ConcurrentHashMap<String, Object>(4, 0.75f, 4);
    private CharsetEncoder encoder = Charset.forName("UTF-8").newEncoder();
    private CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private final AtomicInteger writeInProgress = new AtomicInteger(0);
    private final AtomicBoolean readInProgress = new AtomicBoolean(false);

    public abstract void processWaitingPackets() throws IOException;

    protected abstract void processSocketData() throws IOException;

    protected abstract int receivedPackets();

    public void accept(SocketChannel socketChannel) throws IOException {
        try {
            if (socketChannel.isConnectionPending()) {
                socketChannel.finishConnect();
            }
            this.socketIO = new SocketIO(socketChannel);
        }
        catch (IOException e) {
            String host = (String)this.sessionData.get("remote-hostname");
            if (host == null) {
                host = (String)this.sessionData.get("remote-host");
            }
            log.info("Problem connecting to remote host: " + host + ", address: " + this.remote_address + " - exception: " + e);
            throw e;
        }
        this.socketInput = ByteBuffer.allocate(this.socketIO.getInputPacketSize());
        Socket sock = this.socketIO.getSocketChannel().socket();
        this.local_address = sock.getLocalAddress().getHostAddress();
        this.remote_address = sock.getInetAddress().getHostAddress();
        this.id = this.local_address + "_" + sock.getLocalPort() + "_" + this.remote_address + "_" + sock.getPort();
        this.setLastTransferTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOService call() throws IOException {
        if (this.writeInProgress.compareAndSet(0, 1)) {
            try {
                this.writeData(null);
            }
            finally {
                this.writeInProgress.decrementAndGet();
            }
        }
        if (this.stopping) {
            this.stop();
        } else if (this.readInProgress.compareAndSet(false, true)) {
            try {
                this.processSocketData();
                if (this.receivedPackets() > 0 && this.serviceListener != null) {
                    this.serviceListener.packetsReady(this);
                }
            }
            finally {
                this.readInProgress.set(false);
            }
        }
        return this;
    }

    public ConnectionType connectionType() {
        return this.connectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        block11: {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Socket: " + this.socketIO + ", Force stop called...");
            }
            try {
                if (this.socketIO == null) break block11;
                IOInterface iOInterface = this.socketIO;
                synchronized (iOInterface) {
                    this.socketIO.stop();
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Socket: " + this.socketIO + ", Exception while stopping service: " + this.getUniqueId(), e);
                }
            }
            finally {
                if (this.serviceListener != null) {
                    IOServiceListener<IOService<RefObject>> tmp = this.serviceListener;
                    this.serviceListener = null;
                    tmp.serviceStopped(this);
                }
            }
        }
    }

    public JID getDataReceiver() {
        return this.dataReceiver;
    }

    public long getLastTransferTime() {
        return this.lastTransferTime;
    }

    public String getLocalAddress() {
        return this.local_address;
    }

    public long[] getReadCounters() {
        return this.rdData;
    }

    public RefObject getRefObject() {
        return this.refObject;
    }

    public String getRemoteAddress() {
        return this.remote_address;
    }

    public ConcurrentMap<String, Object> getSessionData() {
        return this.sessionData;
    }

    public SocketChannel getSocketChannel() {
        return this.socketIO.getSocketChannel();
    }

    public void getStatistics(StatisticsList list) {
        if (this.socketIO != null) {
            this.socketIO.getStatistics(list);
        }
    }

    public String getUniqueId() {
        return this.id;
    }

    public long[] getWriteCounters() {
        return this.wrData;
    }

    public boolean isConnected() {
        boolean result;
        boolean bl = result = this.socketIO == null ? false : this.socketIO.isConnected();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Socket: " + this.socketIO + ", Connected: " + result);
        }
        return result;
    }

    public void setDataReceiver(JID address) {
        this.dataReceiver = address;
    }

    public void setIOServiceListener(IOServiceListener<IOService<RefObject>> sl) {
        this.serviceListener = sl;
    }

    public void setRefObject(RefObject refObject) {
        this.refObject = refObject;
    }

    public void setSSLId(String id) {
        this.sslId = id;
    }

    public void setSessionData(Map<String, Object> props) {
        this.sessionData = new ConcurrentHashMap<String, Object>(props);
        this.connectionType = ConnectionType.valueOf(this.sessionData.get(PORT_TYPE_PROP_KEY).toString());
    }

    public void startSSL(boolean clientMode) throws IOException {
        if (this.socketIO instanceof TLSIO) {
            throw new IllegalStateException("SSL mode is already activated.");
        }
        TLSWrapper wrapper = new TLSWrapper(TLSUtil.getSSLContext(this.sslId, "SSL", (String)this.sessionData.get(HOSTNAME_KEY)), null, clientMode);
        this.socketIO = new TLSIO(this.socketIO, wrapper);
        this.setLastTransferTime();
        this.encoder.reset();
        this.decoder.reset();
    }

    public void startTLS(boolean clientMode) throws IOException {
        if (this.socketIO instanceof TLSIO) {
            throw new IllegalStateException("TLS mode is already activated.");
        }
        TLSWrapper wrapper = new TLSWrapper(TLSUtil.getSSLContext(this.sslId, "TLS", (String)this.sessionData.get(HOSTNAME_KEY)), null, clientMode);
        this.socketIO = new TLSIO(this.socketIO, wrapper);
        this.setLastTransferTime();
        this.encoder.reset();
        this.decoder.reset();
    }

    public void startZLib(int level) {
        this.socketIO = new ZLibIO(this.socketIO, level);
    }

    public void stop() {
        if (this.socketIO != null && this.socketIO.waitingToSend()) {
            this.stopping = true;
        } else {
            this.forceStop();
        }
    }

    public String toString() {
        return this.getUniqueId() + ", type: " + (Object)((Object)this.connectionType) + ", Socket: " + this.socketIO;
    }

    public boolean waitingToSend() {
        return this.socketIO.waitingToSend();
    }

    public int waitingToSendSize() {
        return this.socketIO.waitingToSendSize();
    }

    protected boolean debug(char[] msg) {
        if (msg != null) {
            System.out.print(new String(msg));
        }
        return true;
    }

    protected boolean debug(String msg, String prefix) {
        if (log.isLoggable(Level.FINEST) && msg != null && msg.trim().length() > 0) {
            String log_msg = "\n" + (this.connectionType() != null ? this.connectionType().toString() : "null-type") + " " + prefix + "\n" + msg + "\n";
            log.finest(log_msg);
        }
        return true;
    }

    protected void readCompleted() {
        this.decoder.reset();
    }

    protected char[] readData() throws IOException {
        this.setLastTransferTime();
        CharBuffer cb = null;
        try {
            ByteBuffer tmpBuffer = this.socketIO.read(this.socketInput);
            if (this.socketIO.bytesRead() > 0) {
                this.empty_read_call_count = 0L;
                if (tmpBuffer != null) {
                    cb = this.decoder.decode(tmpBuffer);
                    tmpBuffer.clear();
                }
            } else if (++this.empty_read_call_count > 1000L && this.writeInProgress.get() == 0) {
                log.warning("Socket: " + this.socketIO + ", Max allowed empty calls excceeded, closing connection.");
                this.forceStop();
            }
        }
        catch (BufferUnderflowException ex) {
            this.resizeInputBuffer();
            return null;
        }
        catch (Exception eof) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Socket: " + this.socketIO + ", Exception reading data", eof);
            }
            this.forceStop();
        }
        return cb != null ? cb.array() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeData(String data) {
        this.writeInProgress.incrementAndGet();
        AtomicInteger atomicInteger = this.writeInProgress;
        synchronized (atomicInteger) {
            try {
                if (data != null && data.length() > 0) {
                    if (log.isLoggable(Level.FINEST)) {
                        if (data.length() < 256) {
                            log.finest("Socket: " + this.socketIO + ", Writing data (" + data.length() + "): " + data);
                        } else {
                            log.finest("Socket: " + this.socketIO + ", Writing data: " + data.length());
                        }
                    }
                    ByteBuffer dataBuffer = null;
                    int out_buff_size = 2048;
                    int idx_start = 0;
                    int idx_offset = Math.min(idx_start + out_buff_size, data.length());
                    while (idx_start < data.length()) {
                        this.encoder.reset();
                        dataBuffer = this.encoder.encode(CharBuffer.wrap(data, idx_start, idx_offset));
                        this.encoder.flush(dataBuffer);
                        this.socketIO.write(dataBuffer);
                        idx_start = idx_offset;
                        idx_offset = Math.min(idx_start + out_buff_size, data.length());
                    }
                    this.setLastTransferTime();
                    this.empty_read_call_count = 0L;
                } else if (this.socketIO.waitingToSend()) {
                    this.socketIO.write(null);
                    this.setLastTransferTime();
                    this.empty_read_call_count = 0L;
                }
            }
            catch (Exception e) {
                this.forceStop();
            }
        }
        this.writeInProgress.decrementAndGet();
    }

    private void addRead(long read) {
        int minute = TimeUtils.getMinuteNow();
        if (this.lastMinuteRd != minute) {
            this.lastMinuteRd = minute;
            this.rdData[minute] = 0L;
        }
        int n = minute;
        this.rdData[n] = this.rdData[n] + read;
    }

    private void addWritten(long wrote) {
        int minute = TimeUtils.getMinuteNow();
        if (this.lastMinuteWr != minute) {
            this.lastMinuteWr = minute;
            this.wrData[minute] = 0L;
        }
        int n = minute;
        this.wrData[n] = this.wrData[n] + wrote;
    }

    private void resizeInputBuffer() throws IOException {
        int netSize = this.socketIO.getInputPacketSize();
        if (netSize > this.socketInput.capacity() - this.socketInput.remaining()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Socket: " + this.socketIO + ", Resizing buffer to " + (netSize + this.socketInput.capacity()) + " bytes.");
            }
            ByteBuffer b = ByteBuffer.allocate(netSize + this.socketInput.capacity());
            b.put(this.socketInput);
            this.socketInput = b;
        } else {
            this.socketInput.compact();
        }
    }

    private void setLastTransferTime() {
        this.lastTransferTime = System.currentTimeMillis();
    }
}

