/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.XMPPDomBuilderHandler;
import tigase.xmpp.XMPPIOServiceListener;

public class XMPPIOService<RefObject>
extends IOService<RefObject> {
    private static final Logger log = Logger.getLogger("tigase.xmpp.XMPPIOService");
    private XMPPDomBuilderHandler<RefObject> domHandler = null;
    protected SimpleParser parser = SingletonFactory.getParserInstance();
    private XMPPIOServiceListener serviceListener = null;
    private boolean authenticated = false;
    private ConcurrentLinkedQueue<Packet> waitingPackets = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<Packet> receivedPackets = new ConcurrentLinkedQueue();
    private String xmlns = null;

    public XMPPIOService() {
        this.domHandler = new XMPPDomBuilderHandler(this);
    }

    public void addPacketToSend(Packet packet) {
        this.waitingPackets.offer(packet);
    }

    public Queue<Packet> getReceivedPackets() {
        return this.receivedPackets;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void processWaitingPackets() throws IOException {
        Packet packet = null;
        while ((packet = this.waitingPackets.poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.toString() + ", Sending packet: " + packet);
            }
            this.writeRawData(packet.getElement().toString());
            if (!log.isLoggable(Level.FINEST)) continue;
            log.finest(this.toString() + ", SENT: " + packet.getElement().toString());
        }
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setIOServiceListener(XMPPIOServiceListener sl) {
        this.serviceListener = sl;
        super.setIOServiceListener(sl);
    }

    public void setXMLNS(String xmlns) {
        this.xmlns = xmlns;
    }

    @Override
    public void stop() {
        super.stop();
    }

    public void writeRawData(String data) throws IOException {
        this.writeData(data);
    }

    public void xmppStreamOpen(String data) {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.toString() + ", Sending data: " + data);
            }
            this.writeRawData(data);
            assert (this.debug(data, "--SENT:"));
        }
        catch (IOException e) {
            log.warning(this.toString() + ", Error sending stream open data: " + e);
            this.forceStop();
        }
    }

    protected void addReceivedPacket(Packet packet) {
        this.receivedPackets.offer(packet);
    }

    @Override
    protected void processSocketData() throws IOException {
        if (this.isConnected()) {
            char[] data = this.readData();
            while (data != null && data.length > 0) {
                if (this.isConnected()) {
                    if (data != null) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest(this.toString() + ", READ:\n" + new String(data));
                        }
                        assert (this.debug(new String(data), "--RECEIVED:"));
                        Element elem = null;
                        try {
                            Queue<Element> elems;
                            this.parser.parse(this.domHandler, data, 0, data.length);
                            if (this.domHandler.parseError()) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine(this.toString() + ", Data parsing error: " + new String(data));
                                } else {
                                    log.warning(this.toString() + ", data parsing error, stopping connection");
                                }
                                this.forceStop();
                            }
                            if ((elems = this.domHandler.getParsedElements()).size() > 0) {
                                this.readCompleted();
                            }
                            while ((elem = elems.poll()) != null) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest(this.toString() + ", Read packet: " + elem.toString());
                                }
                                this.addReceivedPacket(Packet.packetInstance(elem));
                            }
                        }
                        catch (TigaseStringprepException ex) {
                            log.log(Level.INFO, this.toString() + ", Incorrect to/from JID format for stanza: " + elem.toString(), ex);
                        }
                        catch (Exception ex) {
                            log.log(Level.INFO, this.toString() + ", Incorrect XML data: " + new String(data) + ", stopping connection: " + this.getUniqueId() + ", exception: ", ex);
                            this.forceStop();
                        }
                    } else if (log.isLoggable(Level.FINEST)) {
                        log.finest(this.toString() + ", Nothing read!!");
                    }
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest(this.toString() + ", Service disconnected during read");
                    }
                    this.forceStop();
                }
                data = this.readData();
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.toString() + ", function called when the service is not connected! forceStop()");
            }
            this.forceStop();
        }
    }

    @Override
    protected int receivedPackets() {
        return this.receivedPackets.size();
    }

    protected void xmppStreamClosed() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this.toString() + ", Received STREAM-CLOSE from the client");
        }
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.toString() + ", Sending data: </stream:stream>");
            }
            this.writeRawData("</stream:stream>");
        }
        catch (IOException e) {
            log.info(this.toString() + ", Error sending stream closed data: " + e);
        }
        if (this.serviceListener != null) {
            this.serviceListener.xmppStreamClosed(this);
        }
    }

    protected void xmppStreamOpened(Map<String, String> attribs) {
        if (this.serviceListener != null) {
            String response = this.serviceListener.xmppStreamOpened(this, attribs);
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest(this.toString() + ", Sending data: " + response);
                }
                this.writeRawData(response);
                if (response != null && response.endsWith("</stream:stream>")) {
                    this.stop();
                }
            }
            catch (IOException e) {
                log.warning(this.toString() + ", Error sending stream open data: " + e);
                this.forceStop();
            }
        }
    }
}

