/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.io.SSLContextContainerIfc;
import tigase.io.TLSUtil;
import tigase.net.ConnectionOpenListener;
import tigase.net.ConnectionOpenThread;
import tigase.net.ConnectionType;
import tigase.net.IOService;
import tigase.net.SocketReadThread;
import tigase.net.SocketType;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.ServiceChecker;
import tigase.stats.StatisticsList;
import tigase.util.DataTypes;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPIOServiceListener;

public abstract class ConnectionManager<IO extends XMPPIOService>
extends AbstractMessageReceiver
implements XMPPIOServiceListener<IO> {
    private static final Logger log = Logger.getLogger(ConnectionManager.class.getName());
    public static final String NET_BUFFER_ST_PROP_KEY = "--net-buff-standard";
    public static final String NET_BUFFER_HT_PROP_KEY = "--net-buff-high-throughput";
    protected static final String PORT_KEY = "port-no";
    protected static final String PROP_KEY = "connections/";
    protected static final String PORTS_PROP_KEY = "connections/ports";
    protected static final String PORT_TYPE_PROP_KEY = "type";
    protected static final String PORT_SOCKET_PROP_KEY = "socket";
    protected static final String PORT_IFC_PROP_KEY = "ifc";
    protected static final String PORT_CLASS_PROP_KEY = "class";
    protected static final String PORT_REMOTE_HOST_PROP_KEY = "remote-host";
    protected static final String PORT_REMOTE_HOST_PROP_VAL = "localhost";
    protected static final String TLS_PROP_KEY = "connections/tls/";
    protected static final String TLS_USE_PROP_KEY = "connections/tls/use";
    protected static final boolean TLS_USE_PROP_VAL = true;
    protected static final String TLS_REQUIRED_PROP_KEY = "connections/tls/required";
    protected static final boolean TLS_REQUIRED_PROP_VAL = false;
    protected static final String TLS_KEYS_STORE_PROP_KEY = "connections/tls/keys-store";
    protected static final String TLS_KEYS_STORE_PROP_VAL = SSLContextContainerIfc.JKS_KEYSTORE_FILE_VAL;
    protected static final String TLS_DEF_CERT_PROP_KEY = "connections/tls/def-cert-alias";
    protected static final String TLS_DEF_CERT_PROP_VAL = "default";
    protected static final String TLS_KEYS_STORE_PASSWD_PROP_KEY = "connections/tls/keys-store-password";
    protected static final String TLS_KEYS_STORE_PASSWD_PROP_VAL = "keystore";
    protected static final String TLS_TRUSTS_STORE_PASSWD_PROP_KEY = "connections/tls/trusts-store-password";
    protected static final String TLS_TRUSTS_STORE_PASSWD_PROP_VAL = "truststore";
    protected static final String TLS_TRUSTS_STORE_PROP_KEY = "connections/tls/trusts-store";
    protected static final String TLS_TRUSTS_STORE_PROP_VAL = SSLContextContainerIfc.TRUSTSTORE_FILE_VAL;
    protected static final String TLS_CONTAINER_CLASS_PROP_KEY = "connections/tls/ssl-container-class";
    protected static final String TLS_CONTAINER_CLASS_PROP_VAL = "tigase.io.SSLContextContainer";
    protected static final String TLS_SERVER_CERTS_DIR_PROP_KEY = "connections/tls/server-certs-dir";
    protected static final String TLS_SERVER_CERTS_DIR_PROP_VAL = "certs/";
    protected static final String TLS_TRUSTED_CERTS_DIR_PROP_KEY = "connections/tls/trusted-certs-dir";
    protected static final String TLS_TRUSTED_CERTS_DIR_PROP_VAL = "/etc/ssl/certs";
    protected static final String TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY = "connections/tls/allow-self-signed-certs";
    protected static final String TLS_ALLOW_SELF_SIGNED_CERTS_PROP_VAL = "true";
    protected static final String TLS_ALLOW_INVALID_CERTS_PROP_KEY = "connections/tls/allow-invalid-certs";
    protected static final String TLS_ALLOW_INVALID_CERTS_PROP_VAL = "false";
    protected static final String MAX_RECONNECTS_PROP_KEY = "max-reconnects";
    protected static final String NET_BUFFER_PROP_KEY = "net-buffer";
    protected static final int NET_BUFFER_ST_PROP_VAL = 2048;
    protected static final int NET_BUFFER_HT_PROP_VAL = 65536;
    public static final String PORT_LOCAL_HOST_PROP_KEY = "local-host";
    private static ConnectionOpenThread connectThread = ConnectionOpenThread.getInstance();
    private static SocketReadThread readThread = SocketReadThread.getInstance();
    public String[] PORT_IFC_PROP_VAL = new String[]{"*"};
    private int services_size = 0;
    private Thread watchdog = null;
    private long watchdogRuns = 0L;
    private long watchdogStopped = 0L;
    private long watchdogTests = 0L;
    private LinkedList<Map<String, Object>> waitingTasks = new LinkedList();
    private ConcurrentHashMap<String, IO> services = new ConcurrentHashMap();
    private Set<ConnectionListenerImpl> pending_open = Collections.synchronizedSet(new HashSet());
    protected int net_buffer = 2048;
    private boolean initializationCompleted = false;
    protected long connectionDelay = 2000L;

    public abstract Queue<Packet> processSocketData(IO var1);

    protected abstract long getMaxInactiveTime();

    protected abstract IO getXMPPIOServiceInstance();

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        log.config(this.getName() + " defaults: " + params.toString());
        Map<String, Object> props = super.getDefaults(params);
        props.put(TLS_USE_PROP_KEY, true);
        props.put(TLS_DEF_CERT_PROP_KEY, TLS_DEF_CERT_PROP_VAL);
        props.put(TLS_KEYS_STORE_PROP_KEY, TLS_KEYS_STORE_PROP_VAL);
        props.put(TLS_KEYS_STORE_PASSWD_PROP_KEY, TLS_KEYS_STORE_PASSWD_PROP_VAL);
        props.put(TLS_TRUSTS_STORE_PROP_KEY, TLS_TRUSTS_STORE_PROP_VAL);
        props.put(TLS_TRUSTS_STORE_PASSWD_PROP_KEY, TLS_TRUSTS_STORE_PASSWD_PROP_VAL);
        props.put(TLS_SERVER_CERTS_DIR_PROP_KEY, TLS_SERVER_CERTS_DIR_PROP_VAL);
        props.put(TLS_TRUSTED_CERTS_DIR_PROP_KEY, TLS_TRUSTED_CERTS_DIR_PROP_VAL);
        props.put(TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY, TLS_ALLOW_SELF_SIGNED_CERTS_PROP_VAL);
        props.put(TLS_ALLOW_INVALID_CERTS_PROP_KEY, TLS_ALLOW_INVALID_CERTS_PROP_VAL);
        if (params.get("--ssl-container-class") != null) {
            props.put(TLS_CONTAINER_CLASS_PROP_KEY, (String)params.get("--ssl-container-class"));
        } else {
            props.put(TLS_CONTAINER_CLASS_PROP_KEY, TLS_CONTAINER_CLASS_PROP_VAL);
        }
        int buffSize = 2048;
        buffSize = this.isHighThroughput() ? DataTypes.parseSizeInt((String)params.get(NET_BUFFER_HT_PROP_KEY), 65536) : DataTypes.parseSizeInt((String)params.get(NET_BUFFER_ST_PROP_KEY), 2048);
        props.put(NET_BUFFER_PROP_KEY, buffSize);
        int[] ports = null;
        String ports_str = (String)params.get("--" + this.getName() + "-ports");
        if (ports_str != null) {
            String[] ports_stra = ports_str.split(",");
            ports = new int[ports_stra.length];
            int k = 0;
            for (String p : ports_stra) {
                try {
                    ports[k++] = Integer.parseInt(p);
                }
                catch (Exception e) {
                    log.warning("Incorrect ports default settings: " + p);
                }
            }
        }
        int ports_size = 0;
        if (ports != null) {
            log.config("Port settings preset: " + Arrays.toString(ports));
            for (int port : ports) {
                this.putDefPortParams(props, port, SocketType.plain);
            }
            props.put(PORTS_PROP_KEY, ports);
        } else {
            int[] ssls;
            int[] plains = this.getDefPlainPorts();
            if (plains != null) {
                ports_size += plains.length;
            }
            if ((ssls = this.getDefSSLPorts()) != null) {
                ports_size += ssls.length;
            }
            if (ports_size > 0) {
                ports = new int[ports_size];
            }
            if (ports != null) {
                int i;
                int idx = 0;
                if (plains != null) {
                    idx = plains.length;
                    for (i = 0; i < idx; ++i) {
                        ports[i] = plains[i];
                        this.putDefPortParams(props, ports[i], SocketType.plain);
                    }
                }
                if (ssls != null) {
                    for (i = idx; i < idx + ssls.length; ++i) {
                        ports[i] = ssls[i - idx];
                        this.putDefPortParams(props, ports[i], SocketType.ssl);
                    }
                }
                props.put(PORTS_PROP_KEY, ports);
            }
        }
        return props;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Open connections", this.services_size, Level.INFO);
        if (list.checkLevel(Level.FINEST)) {
            int waitingToSendSize = 0;
            for (XMPPIOService serv : this.services.values()) {
                waitingToSendSize += serv.waitingToSendSize();
            }
            list.add(this.getName(), "Waiting to send", waitingToSendSize, Level.FINEST);
        }
        list.add(this.getName(), "Watchdog runs", this.watchdogRuns, Level.FINER);
        list.add(this.getName(), "Watchdog tests", this.watchdogTests, Level.FINE);
        list.add(this.getName(), "Watchdog stopped", this.watchdogStopped, Level.FINE);
    }

    @Override
    public void initializationCompleted() {
        this.initializationCompleted = true;
        for (Map map : this.waitingTasks) {
            this.reconnectService(map, this.connectionDelay);
        }
        this.waitingTasks.clear();
    }

    @Override
    public void packetsReady(IO serv) throws IOException {
        this.writePacketsToSocket(serv, this.processSocketData(serv));
    }

    @Override
    public void processPacket(Packet packet) {
        this.writePacketToSocket(packet);
    }

    @Override
    public void release() {
        this.releaseListeners();
        super.release();
    }

    public void serviceStarted(IO service) {
        XMPPIOService serv;
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.finer("[[" + this.getName() + "]] Connection started: " + service);
        }
        if ((serv = (XMPPIOService)this.services.get(id)) != null) {
            if (serv == service) {
                log.warning(this.getName() + ": That would explain a lot, adding the same service twice, ID: " + serv);
            } else {
                log.warning(this.getName() + ": Attempt to add different service with the same ID: " + service);
                serv.stop();
            }
        }
        this.services.put(id, service);
        ++this.services_size;
    }

    @Override
    public boolean serviceStopped(IO service) {
        String id = this.getUniqueId(service);
        if (log.isLoggable(Level.FINER)) {
            log.finer("[[" + this.getName() + "]] Connection stopped: " + service);
        }
        if (id != null) {
            boolean result = this.services.remove(id, service);
            if (!result) {
                log.warning("[[" + this.getName() + "]] Attempt to stop incorrect service: " + service);
                Thread.dumpStack();
            } else {
                --this.services_size;
            }
            return result;
        }
        return false;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.watchdog = new Thread((Runnable)new Watchdog(), "Watchdog - " + name);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.net_buffer = (Integer)props.get(NET_BUFFER_PROP_KEY);
        this.releaseListeners();
        int[] ports = (int[])props.get(PORTS_PROP_KEY);
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>();
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (!entry.getKey().startsWith(PROP_KEY + ports[i])) continue;
                    int idx = entry.getKey().lastIndexOf(47);
                    String key = entry.getKey().substring(idx + 1);
                    log.config("Adding port property key: " + key + "=" + entry.getValue());
                    port_props.put(key, entry.getValue());
                }
                port_props.put(PORT_KEY, ports[i]);
                this.addWaitingTask(port_props);
            }
        }
        if (((Boolean)props.get(TLS_USE_PROP_KEY)).booleanValue()) {
            LinkedHashMap<String, String> tls_params = new LinkedHashMap<String, String>();
            tls_params.put("ssl-container-class", (String)props.get(TLS_CONTAINER_CLASS_PROP_KEY));
            tls_params.put("def-cert-alias", (String)props.get(TLS_DEF_CERT_PROP_KEY));
            tls_params.put("keys-store", (String)props.get(TLS_KEYS_STORE_PROP_KEY));
            tls_params.put("keys-store-password", (String)props.get(TLS_KEYS_STORE_PASSWD_PROP_KEY));
            tls_params.put("trusts-store", (String)props.get(TLS_TRUSTS_STORE_PROP_KEY));
            tls_params.put("trusts-store-password", (String)props.get(TLS_TRUSTS_STORE_PASSWD_PROP_KEY));
            tls_params.put("server-certs-dir", (String)props.get(TLS_SERVER_CERTS_DIR_PROP_KEY));
            tls_params.put("trusted-certs-dir", (String)props.get(TLS_TRUSTED_CERTS_DIR_PROP_KEY));
            tls_params.put("allow-self-signed-certs", (String)props.get(TLS_ALLOW_SELF_SIGNED_CERTS_PROP_KEY));
            tls_params.put("allow-invalid-certs", (String)props.get(TLS_ALLOW_INVALID_CERTS_PROP_KEY));
            TLSUtil.configureSSLContext(this.getName(), tls_params);
        }
    }

    @Override
    public void start() {
        super.start();
    }

    public boolean writePacketToSocket(IO ios, Packet p) {
        if (ios != null) {
            ((XMPPIOService)ios).addPacketToSend(p);
            try {
                ((XMPPIOService)ios).processWaitingPackets();
                readThread.addSocketService((IOService)ios);
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, ios + "Exception during writing packets: ", e);
                try {
                    ((XMPPIOService)ios).stop();
                }
                catch (Exception e1) {
                    log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Can't find service for packet: <" + p.getElemName() + "> " + p.getTo() + ", service id: " + this.getServiceId(p));
        }
        return false;
    }

    public void writePacketsToSocket(IO serv, Queue<Packet> packets) {
        if (serv != null) {
            if (packets != null && packets.size() > 0) {
                Packet p = null;
                while ((p = packets.poll()) != null) {
                    ((XMPPIOService)serv).addPacketToSend(p);
                }
                try {
                    ((XMPPIOService)serv).processWaitingPackets();
                    readThread.addSocketService((IOService)serv);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, serv + "Exception during writing packets: ", e);
                    try {
                        ((XMPPIOService)serv).stop();
                    }
                    catch (Exception e1) {
                        log.log(Level.WARNING, serv + "Exception stopping XMPPIOService: ", e1);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("Can't find service for packets: [" + packets + "] ");
        }
    }

    protected void addWaitingTask(Map<String, Object> conn) {
        if (this.initializationCompleted) {
            this.reconnectService(conn, this.connectionDelay);
        } else {
            this.waitingTasks.add(conn);
        }
    }

    protected int countIOServices() {
        return this.services.size();
    }

    protected void doForAllServices(ServiceChecker checker) {
        for (XMPPIOService service : this.services.values()) {
            checker.check(service);
        }
    }

    protected int[] getDefPlainPorts() {
        return null;
    }

    protected int[] getDefSSLPorts() {
        return null;
    }

    protected Map<String, Object> getParamsForPort(int port) {
        return null;
    }

    protected String getServiceId(Packet packet) {
        return this.getServiceId(packet.getTo());
    }

    protected String getServiceId(JID jid) {
        return jid.getResource();
    }

    protected String getUniqueId(IO serv) {
        return ((IOService)serv).getUniqueId();
    }

    protected IO getXMPPIOService(String serviceId) {
        return (IO)((XMPPIOService)this.services.get(serviceId));
    }

    protected IO getXMPPIOService(Packet p) {
        return (IO)((XMPPIOService)this.services.get(this.getServiceId(p)));
    }

    protected boolean isHighThroughput() {
        return false;
    }

    protected boolean writePacketToSocket(Packet p) {
        IO ios = this.getXMPPIOService(p);
        if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
            log.finer(ios + ", Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(ios + ", Writing packet to: " + p.getTo());
        }
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected boolean writePacketToSocket(Packet p, String serviceId) {
        IO ios = this.getXMPPIOService(serviceId);
        if (log.isLoggable(Level.FINER) && !log.isLoggable(Level.FINEST)) {
            log.finer(ios + ", Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(ios + ", Writing packet to: " + p.getTo());
        }
        if (ios != null) {
            return this.writePacketToSocket(ios, p);
        }
        return false;
    }

    protected void writeRawData(IO ios, String data) {
        try {
            ((XMPPIOService)ios).writeRawData(data);
            readThread.addSocketService((IOService)ios);
        }
        catch (Exception e) {
            log.log(Level.WARNING, ios + "Exception during writing data: " + data, e);
            try {
                ((XMPPIOService)ios).stop();
            }
            catch (Exception e1) {
                log.log(Level.WARNING, ios + "Exception stopping XMPPIOService: ", e1);
            }
        }
    }

    private void putDefPortParams(Map<String, Object> props, int port, SocketType sock) {
        log.config("Generating defaults for port: " + port);
        props.put(PROP_KEY + port + "/" + PORT_TYPE_PROP_KEY, (Object)ConnectionType.accept);
        props.put(PROP_KEY + port + "/" + PORT_SOCKET_PROP_KEY, (Object)sock);
        props.put(PROP_KEY + port + "/" + PORT_IFC_PROP_KEY, this.PORT_IFC_PROP_VAL);
        props.put(PROP_KEY + port + "/" + PORT_REMOTE_HOST_PROP_KEY, PORT_REMOTE_HOST_PROP_VAL);
        props.put(PROP_KEY + port + "/" + TLS_REQUIRED_PROP_KEY, false);
        Map<String, Object> extra = this.getParamsForPort(port);
        if (extra != null) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                props.put(PROP_KEY + port + "/" + entry.getKey(), entry.getValue());
            }
        }
    }

    private void reconnectService(final Map<String, Object> port_props, long delay) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Reconnecting service for: " + this.getName() + ", scheduling next try in " + delay / 1000L + "secs");
        }
        this.addTimerTask(new TimerTask(){

            @Override
            public void run() {
                String host = (String)port_props.get(ConnectionManager.PORT_REMOTE_HOST_PROP_KEY);
                if (host == null) {
                    host = (String)port_props.get("remote-hostname");
                }
                int port = (Integer)port_props.get(ConnectionManager.PORT_KEY);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reconnecting service for component: " + ConnectionManager.this.getName() + ", to remote host: " + host + " on port: " + port);
                }
                ConnectionManager.this.startService(port_props);
            }
        }, delay);
    }

    private void releaseListeners() {
        for (ConnectionListenerImpl cli : this.pending_open) {
            connectThread.removeConnectionOpenListener(cli);
        }
        this.pending_open.clear();
    }

    private void startService(Map<String, Object> port_props) {
        ConnectionListenerImpl cli = new ConnectionListenerImpl(port_props);
        if (cli.getConnectionType() == ConnectionType.accept) {
            this.pending_open.add(cli);
        }
        connectThread.addConnectionOpenListener(cli);
    }

    private class Watchdog
    implements Runnable {
        private Watchdog() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(600000L);
                        ++ConnectionManager.this.watchdogRuns;
                        ConnectionManager.this.doForAllServices(new ServiceChecker(){

                            @Override
                            public void check(XMPPIOService service) {
                                try {
                                    if (null != service) {
                                        long lastTransfer;
                                        long curr_time = System.currentTimeMillis();
                                        if (curr_time - (lastTransfer = service.getLastTransferTime()) >= ConnectionManager.this.getMaxInactiveTime()) {
                                            if (log.isLoggable(Level.INFO)) {
                                                log.info(ConnectionManager.this.getName() + ": Max inactive time exceeded, stopping: " + service);
                                            }
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.stop();
                                        } else if (curr_time - lastTransfer >= 1740000L) {
                                            service.writeRawData(" ");
                                            ++ConnectionManager.this.watchdogTests;
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    try {
                                        if (service != null) {
                                            log.info(ConnectionManager.this.getName() + "Found dead connection, stopping: " + service);
                                            ++ConnectionManager.this.watchdogStopped;
                                            service.forceStop();
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private class ConnectionListenerImpl
    implements ConnectionOpenListener {
        private Map<String, Object> port_props = null;

        private ConnectionListenerImpl(Map<String, Object> port_props) {
            this.port_props = port_props;
        }

        @Override
        public void accept(SocketChannel sc) {
            Object serv = ConnectionManager.this.getXMPPIOServiceInstance();
            ((IOService)serv).setSSLId(ConnectionManager.this.getName());
            ((XMPPIOService)serv).setIOServiceListener(ConnectionManager.this);
            ((IOService)serv).setSessionData(this.port_props);
            try {
                ((IOService)serv).accept(sc);
                if (this.getSocketType() == SocketType.ssl) {
                    ((IOService)serv).startSSL(false);
                }
                ConnectionManager.this.serviceStarted(serv);
                readThread.addSocketService((IOService)serv);
            }
            catch (SocketException e) {
                int recon;
                log.log(Level.FINEST, "Problem reconnecting the service: " + serv);
                Integer reconnects = (Integer)this.port_props.get(ConnectionManager.MAX_RECONNECTS_PROP_KEY);
                if (reconnects != null && (recon = reconnects.intValue()) != 0) {
                    this.port_props.put(ConnectionManager.MAX_RECONNECTS_PROP_KEY, --recon);
                    ConnectionManager.this.reconnectService(this.port_props, ConnectionManager.this.connectionDelay);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not accept connection.", e);
                ((XMPPIOService)serv).stop();
            }
        }

        @Override
        public ConnectionType getConnectionType() {
            String type = null;
            if (this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY) == null) {
                log.warning(ConnectionManager.this.getName() + ": connection type is null: " + this.port_props.get(ConnectionManager.PORT_KEY).toString());
            } else {
                type = this.port_props.get(ConnectionManager.PORT_TYPE_PROP_KEY).toString();
            }
            return ConnectionType.valueOf(type);
        }

        @Override
        public String[] getIfcs() {
            return (String[])this.port_props.get(ConnectionManager.PORT_IFC_PROP_KEY);
        }

        @Override
        public int getPort() {
            return (Integer)this.port_props.get(ConnectionManager.PORT_KEY);
        }

        @Override
        public int getReceiveBufferSize() {
            return ConnectionManager.this.net_buffer;
        }

        public SocketType getSocketType() {
            return SocketType.valueOf(this.port_props.get(ConnectionManager.PORT_SOCKET_PROP_KEY).toString());
        }

        @Override
        public int getTrafficClass() {
            if (ConnectionManager.this.isHighThroughput()) {
                return 8;
            }
            return 2;
        }

        public String toString() {
            return this.port_props.toString();
        }
    }
}

