/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.db.ComponentRepository;
import tigase.db.RepositoryItem;

public abstract class ConfigRepository<Item extends RepositoryItem>
implements ComponentRepository<Item> {
    private static final Logger log = Logger.getLogger(ConfigRepository.class.getName());
    protected LinkedHashMap<String, Item> items = new LinkedHashMap();

    public abstract String[] getDefaultPropetyItems();

    public abstract String getPropertyKey();

    public abstract String getConfigKey();

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        String[] items_arr = this.getDefaultPropetyItems();
        if (params.get(this.getPropertyKey()) != null) {
            items_arr = ((String)params.get(this.getPropertyKey())).split(",");
        }
        defs.put(this.getConfigKey(), items_arr);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        String[] items_arr = (String[])properties.get(this.getConfigKey());
        if (items_arr != null && items_arr.length > 0) {
            this.items.clear();
            for (String it : items_arr) {
                log.config("Loading config item: " + it);
                Object item = this.getItemInstance();
                item.initFromPropertyString(it);
                this.items.put(item.getKey(), item);
            }
        } else {
            log.warning("Items list is not set in the configuration file!!");
        }
    }

    @Override
    public Item getItem(String key) {
        return (Item)((RepositoryItem)this.items.get(key));
    }

    @Override
    public boolean contains(String key) {
        return this.items.keySet().contains(key);
    }

    @Override
    public void reload() {
    }

    @Override
    public void store() {
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public void addItem(Item item) {
        this.items.put(item.getKey(), item);
        this.store();
    }

    @Override
    public void removeItem(String key) {
        this.items.remove(key);
        this.store();
    }

    @Override
    public Collection<Item> allItems() {
        return this.items.values();
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.values().iterator();
    }
}

