/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigRepositoryIfc;
import tigase.conf.Configurable;
import tigase.conf.ConfigurationCache;
import tigase.conf.ConfigurationException;
import tigase.conf.MonitoringSetupIfc;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserRepository;
import tigase.db.UserRepositoryPool;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.xmpp.BareJID;

public abstract class ConfiguratorAbstract
extends AbstractComponentRegistrator<Configurable> {
    public static final String CONFIG_REPO_CLASS_INIT_KEY = "--tigase-config-repo-class";
    public static final String CONFIG_REPO_CLASS_PROP_KEY = "tigase-config-repo-class";
    private static final String LOGGING_KEY = "logging/";
    public static final String PROPERTY_FILENAME_PROP_KEY = "--property-file";
    private static final Logger log = Logger.getLogger(ConfiguratorAbstract.class.getName());
    public static String logManagerConfiguration = null;
    private static MonitoringSetupIfc monitoring = null;
    private Map<String, String> auth_repo_params = null;
    private UserAuthRepository auth_repository = null;
    private ConfigRepositoryIfc configRepo = new ConfigurationCache();
    private UserRepositoryPool repo_pool = null;
    private Map<String, String> user_repo_params = null;
    private UserRepository user_repository = null;
    private List<String> initSettings = new LinkedList<String>();
    private Map<String, Object> initProperties = new LinkedHashMap<String, Object>();

    public static Object getMXBean(String objName) {
        if (monitoring != null) {
            return monitoring.getMXBean(objName);
        }
        return null;
    }

    public static void loadLogManagerConfig(String config) {
        logManagerConfiguration = config;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(config.getBytes());
            LogManager.getLogManager().readConfiguration(bis);
            bis.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not configure logManager", e);
        }
    }

    public static void putMXBean(String objName, Object bean) {
        if (monitoring != null) {
            monitoring.putMXBean(objName, bean);
        }
    }

    @Override
    public void componentAdded(Configurable component) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(" component: " + component.getName());
        }
        this.setup(component);
    }

    @Override
    public void componentRemoved(Configurable component) {
    }

    public Map<String, Object> getDefConfigParams() {
        return this.initProperties;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        String[] packs;
        Map<String, Object> defaults = super.getDefaults(params);
        if (((Boolean)params.get("--test")).booleanValue()) {
            defaults.put("logging/.level", "WARNING");
        } else {
            defaults.put("logging/.level", "CONFIG");
        }
        defaults.put("logging/handlers", "java.util.logging.ConsoleHandler java.util.logging.FileHandler");
        defaults.put("logging/java.util.logging.ConsoleHandler.formatter", "tigase.util.LogFormatter");
        defaults.put("logging/java.util.logging.ConsoleHandler.level", "WARNING");
        defaults.put("logging/java.util.logging.FileHandler.append", "true");
        defaults.put("logging/java.util.logging.FileHandler.count", "5");
        defaults.put("logging/java.util.logging.FileHandler.formatter", "tigase.util.LogFormatter");
        defaults.put("logging/java.util.logging.FileHandler.limit", "10000000");
        defaults.put("logging/java.util.logging.FileHandler.pattern", "logs/tigase.log");
        defaults.put("logging/tigase.useParentHandlers", "true");
        defaults.put("logging/java.util.logging.FileHandler.level", "ALL");
        if (params.get("--debug") != null) {
            for (String pack : packs = ((String)params.get("--debug")).split(",")) {
                defaults.put("logging/tigase." + pack + ".level", "ALL");
            }
        }
        if (params.get("--debug-packages") != null) {
            for (String pack : packs = ((String)params.get("--debug-packages")).split(",")) {
                defaults.put(LOGGING_KEY + pack + ".level", "ALL");
            }
        }
        String user_repo_class = "tigase.db.jdbc.JDBCRepository";
        String user_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        String auth_repo_class = "tigase.db.jdbc.JDBCRepository";
        String auth_repo_url = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db") != null) {
            user_repo_class = (String)params.get("--user-db");
            auth_repo_class = (String)params.get("--user-db");
        }
        if (params.get("--user-db-uri") != null) {
            auth_repo_url = user_repo_url = (String)params.get("--user-db-uri");
        }
        if (params.get("--auth-db") != null) {
            auth_repo_class = (String)params.get("--auth-db");
        }
        if (params.get("--auth-db-uri") != null) {
            auth_repo_url = (String)params.get("--auth-db-uri");
        }
        if (params.get("--user-repo-pool-size") != null) {
            defaults.put("user-repo-pool-size", params.get("--user-repo-pool-size"));
        } else {
            defaults.put("user-repo-pool-size", "1");
        }
        defaults.put("user-repo-class", user_repo_class);
        defaults.put("user-repo-url", user_repo_url);
        defaults.put("user-repo-params/param-1", "value-1");
        defaults.put("auth-repo-class", auth_repo_class);
        defaults.put("auth-repo-url", auth_repo_url);
        defaults.put("auth-repo-params/param-1", "value-1");
        return defaults;
    }

    public String getMessageRouterClassName() {
        return "tigase.server.MessageRouter";
    }

    public Map<String, Object> getProperties(String nodeId) throws ConfigurationException {
        return this.configRepo.getProperties(nodeId);
    }

    public void init(String[] args) throws ConfigurationException, TigaseDBException {
        String property_filename;
        String cnf_class_name;
        this.parseArgs(args);
        String stringprep = (String)this.initProperties.get("--stringprep-processor");
        if (stringprep != null) {
            BareJID.useStringprepProcessor((String)stringprep);
        }
        if ((cnf_class_name = System.getProperty(CONFIG_REPO_CLASS_PROP_KEY)) != null) {
            this.initProperties.put(CONFIG_REPO_CLASS_INIT_KEY, cnf_class_name);
        }
        if ((cnf_class_name = (String)this.initProperties.get(CONFIG_REPO_CLASS_INIT_KEY)) != null) {
            try {
                this.configRepo = (ConfigRepositoryIfc)Class.forName(cnf_class_name).newInstance();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem initializing configuration system: ", e);
                log.log(Level.SEVERE, "Please check settings, and rerun the server.");
                log.log(Level.SEVERE, "Server is stopping now.");
                System.err.println("Problem initializing configuration system: " + e);
                System.err.println("Please check settings, and rerun the server.");
                System.err.println("Server is stopping now.");
                System.exit(1);
            }
        }
        this.configRepo.setDefHostname(this.getDefHostName());
        this.configRepo.init(this.initProperties);
        for (String prop : this.initSettings) {
            ConfigItem item = (ConfigItem)this.configRepo.getItemInstance();
            item.initFromPropertyString(prop);
            this.configRepo.addItem(item);
        }
        Map<String, Object> repoInitProps = this.configRepo.getInitProperties();
        if (repoInitProps != null) {
            this.initProperties.putAll(repoInitProps);
        }
        if ((property_filename = (String)this.initProperties.get(PROPERTY_FILENAME_PROP_KEY)) != null) {
            this.initMonitoring((String)this.initProperties.get("--monitoring"), new File(property_filename).getParent());
        }
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.configRepo);
    }

    @Override
    public void initializationCompleted() {
        super.initializationCompleted();
        if (monitoring != null) {
            monitoring.initializationCompleted();
        }
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof Configurable;
    }

    public void parseArgs(String[] args) {
        String property_filename;
        this.initProperties.put("--test", Boolean.FALSE);
        this.initProperties.put("config-type", "--gen-config-default");
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String key = null;
                Object val = null;
                if (args[i].startsWith("--gen-config")) {
                    key = "config-type";
                    val = args[i];
                }
                if (args[i].startsWith("--test")) {
                    key = args[i];
                    val = Boolean.TRUE;
                }
                if (key == null && args[i].startsWith("-") && !args[i].startsWith("--gen-config")) {
                    key = args[i];
                    val = args[++i];
                }
                if (key == null) continue;
                this.initProperties.put(key, val);
                log.config("Setting defaults: " + key + "=" + val.toString());
            }
        }
        if ((property_filename = (String)this.initProperties.get(PROPERTY_FILENAME_PROP_KEY)) != null) {
            log.config("Loading initial properties from property file: " + property_filename);
            try {
                Properties defProps = new Properties();
                defProps.load(new FileReader(property_filename));
                Set<String> prop_keys = defProps.stringPropertyNames();
                for (String key : prop_keys) {
                    String value = defProps.getProperty(key).trim();
                    if (key.startsWith("-") || key.equals("config-type")) {
                        this.initProperties.put(key.trim(), value);
                        log.config("Added default config parameter: (" + key + "=" + value + ")");
                        continue;
                    }
                    this.initSettings.add(key + "=" + value);
                }
            }
            catch (FileNotFoundException e) {
                log.warning("Given property file was not found: " + property_filename);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Can not read property file: " + property_filename, e);
            }
        }
        for (Map.Entry<String, Object> entry : this.initProperties.entrySet()) {
            if (!entry.getKey().startsWith("--")) continue;
            System.setProperty(entry.getKey().substring(2), entry.getValue() == null ? null : entry.getValue().toString());
        }
    }

    public void putProperties(String compId, Map<String, Object> props) throws ConfigurationException {
        this.configRepo.putProperties(compId, props);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String res_uri;
        String cls_name;
        super.setProperties(props);
        this.setupLogManager(props);
        int repo_pool_size = 1;
        try {
            repo_pool_size = Integer.parseInt((String)props.get("user-repo-pool-size"));
        }
        catch (Exception e) {
            repo_pool_size = 1;
        }
        this.repo_pool = new UserRepositoryPool();
        this.user_repo_params = new LinkedHashMap<String, String>();
        this.auth_repo_params = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String[] nodes;
            if (entry.getKey().startsWith("user-repo-params") && (nodes = entry.getKey().split("/")).length > 1) {
                this.user_repo_params.put(nodes[1], entry.getValue().toString());
            }
            if (!entry.getKey().startsWith("auth-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
            this.auth_repo_params.put(nodes[1], entry.getValue().toString());
        }
        try {
            cls_name = (String)props.get("user-repo-class");
            res_uri = (String)props.get("user-repo-url");
            this.repo_pool.initRepository(res_uri, this.user_repo_params);
            for (int i = 0; i < repo_pool_size; ++i) {
                this.user_repository = RepositoryFactory.getUserRepository(this.getName() + "-" + (i + 1), cls_name, res_uri, this.user_repo_params);
                this.repo_pool.addRepo(this.user_repository);
            }
            log.config("Initialized " + cls_name + " as user repository: " + res_uri);
            log.config("Initialized user repository pool: " + repo_pool_size);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize user repository: ", e);
        }
        try {
            cls_name = (String)props.get("auth-repo-class");
            res_uri = (String)props.get("auth-repo-url");
            this.auth_repository = RepositoryFactory.getAuthRepository(this.getName(), cls_name, res_uri, this.auth_repo_params);
            log.config("Initialized " + cls_name + " as auth repository: " + res_uri);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can't initialize auth repository: ", e);
        }
    }

    public void setup(Configurable component) {
        String compId = component.getName();
        Map<String, Object> prop = null;
        try {
            prop = this.configRepo.getProperties(compId);
        }
        catch (ConfigurationException ex) {
            log.log(Level.WARNING, "Propblem retrieving configuration properties for component: " + compId, ex);
            return;
        }
        Map<String, Object> defs = component.getDefaults(this.getDefConfigParams());
        Set<Map.Entry<String, Object>> defs_entries = defs.entrySet();
        boolean modified = false;
        for (Map.Entry<String, Object> entry : defs_entries) {
            if (prop.containsKey(entry.getKey())) continue;
            prop.put(entry.getKey(), entry.getValue());
            modified = true;
        }
        if (modified) {
            try {
                this.configRepo.putProperties(compId, prop);
            }
            catch (ConfigurationException ex) {
                log.log(Level.WARNING, "Propblem with saving configuration properties for component: " + compId, ex);
            }
        }
        prop.put("shared-user-repo", this.user_repository);
        prop.put("shared-user-repo-params", this.user_repo_params);
        prop.put("shared-auth-repo", this.auth_repository);
        prop.put("shared-auth-repo-params", this.auth_repo_params);
        prop.put("shared-user-repo-pool", this.repo_pool);
        component.setProperties(prop);
    }

    private void initMonitoring(String settings, String configDir) {
        if (monitoring == null && settings != null) {
            try {
                monitoring = (MonitoringSetupIfc)Class.forName("tigase.management.MonitoringSetup").newInstance();
                monitoring.initMonitoring(settings, configDir);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can not initialize monitoring: ", e);
            }
        }
    }

    private void setupLogManager(Map<String, Object> properties) {
        Set<Map.Entry<String, Object>> entries = properties.entrySet();
        StringBuilder buff = new StringBuilder();
        for (Map.Entry<String, Object> entry : entries) {
            File log_path;
            if (!entry.getKey().startsWith(LOGGING_KEY)) continue;
            String key = entry.getKey().substring(LOGGING_KEY.length());
            buff.append(key + "=" + entry.getValue() + "\n");
            if (!key.equals("java.util.logging.FileHandler.pattern") || (log_path = new File(entry.getValue().toString()).getParentFile()).exists()) continue;
            log_path.mkdirs();
        }
        ConfiguratorAbstract.loadLogManagerConfig(buff.toString());
        log.config("DONE");
    }
}

