/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.conf.Configurable;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class VirtualComponent
implements ServerComponent,
XMPPService,
Configurable,
DisableDisco {
    private static final Logger log = Logger.getLogger("tigase.cluster.VirtualComponent");
    public static final String REDIRECT_TO_PROP_KEY = "redirect-to";
    public static final String DISCO_NAME_PROP_KEY = "disco-name";
    public static final String DISCO_NAME_PROP_VAL = "Multi User Chat";
    public static final String DISCO_NODE_PROP_KEY = "disco-node";
    public static final String DISCO_NODE_PROP_VAL = "";
    public static final String DISCO_TYPE_PROP_KEY = "disco-type";
    public static final String DISCO_TYPE_PROP_VAL = "text";
    public static final String DISCO_CATEGORY_PROP_KEY = "disco-category";
    public static final String DISCO_CATEGORY_PROP_VAL = "conference";
    public static final String DISCO_FEATURES_PROP_KEY = "disco-features";
    public static final String DISCO_FEATURES_PROP_VAL = "http://jabber.org/protocol/muc";
    private JID componentId = null;
    private String discoCategory = null;
    private String[] discoFeatures = null;
    private String discoName = null;
    private String discoNode = null;
    private String discoType = null;
    private String name = null;
    private JID redirectTo = null;
    private ServiceEntity serviceEntity = null;

    @Override
    public JID getComponentId() {
        return this.componentId;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        LinkedHashMap<String, Object> defs = new LinkedHashMap<String, Object>();
        defs.put(REDIRECT_TO_PROP_KEY, DISCO_NODE_PROP_VAL);
        if (params.get("--cluster-nodes") != null) {
            String[] cl_nodes;
            for (String node : cl_nodes = ((String)params.get("--cluster-nodes")).split(",")) {
                if (node.equals(DNSResolver.getDefaultHostname())) continue;
                defs.put(REDIRECT_TO_PROP_KEY, BareJID.toString((String)this.getName(), (String)node));
                break;
            }
        }
        defs.put(DISCO_NAME_PROP_KEY, DISCO_NAME_PROP_VAL);
        defs.put(DISCO_NODE_PROP_KEY, DISCO_NODE_PROP_VAL);
        defs.put(DISCO_TYPE_PROP_KEY, DISCO_TYPE_PROP_VAL);
        defs.put(DISCO_CATEGORY_PROP_KEY, DISCO_CATEGORY_PROP_VAL);
        defs.put(DISCO_FEATURES_PROP_KEY, DISCO_FEATURES_PROP_VAL);
        return defs;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid);
        return Arrays.asList(result);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void initializationCompleted() {
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (this.redirectTo != null) {
            packet.setPacketTo(this.redirectTo);
            results.add(packet);
        } else {
            log.info("No redirectTo address, dropping packet: " + packet.toString());
        }
    }

    @Override
    public void release() {
    }

    @Override
    public void setName(String name) {
        this.componentId = JID.jidInstanceNS((String)name, (String)DNSResolver.getDefaultHostname(), null);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        String redirect = (String)properties.get(REDIRECT_TO_PROP_KEY);
        if (redirect == null || redirect.isEmpty()) {
            this.redirectTo = null;
        } else {
            try {
                this.redirectTo = JID.jidInstance((String)redirect);
            }
            catch (TigaseStringprepException ex) {
                this.redirectTo = null;
                log.warning("stringprep processing failed for given redirect address: " + redirect);
            }
        }
        this.discoName = (String)properties.get(DISCO_NAME_PROP_KEY);
        this.discoNode = (String)properties.get(DISCO_NODE_PROP_KEY);
        if (this.discoNode.isEmpty()) {
            this.discoNode = null;
        }
        this.discoCategory = (String)properties.get(DISCO_CATEGORY_PROP_KEY);
        this.discoType = (String)properties.get(DISCO_TYPE_PROP_KEY);
        this.discoFeatures = ((String)properties.get(DISCO_TYPE_PROP_KEY)).split(",");
        this.serviceEntity = new ServiceEntity(this.getName(), null, this.discoName);
        this.serviceEntity.addIdentities(new ServiceIdentity(this.discoCategory, this.discoType, this.discoName));
        for (String feature : this.discoFeatures) {
            this.serviceEntity.addFeatures(feature);
        }
    }
}

