/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterController;
import tigase.cluster.ClusterElement;
import tigase.cluster.ClusterMethods;
import tigase.cluster.ClusteredComponent;
import tigase.cluster.ClusteringStrategyIfc;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.xmppsession.SessionManager;
import tigase.stats.StatisticsList;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class SessionManagerClustered
extends SessionManager
implements ClusteredComponent {
    private static final String AUTH_TIME = "auth-time";
    private static final String CL_BR_INITIAL_PRESENCE = "cl-br-init-pres";
    private static final String CL_BR_USER_CONNECTED = "cl-br-user_conn";
    private static final String CONNECTION_ID = "connectionId";
    private static final String CREATION_TIME = "creationTime";
    private static final String ERROR_CODE = "errorCode";
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    private static final String PRIORITY = "priority";
    private static final String RESOURCE = "resource";
    private static final String SM_ID = "smId";
    public static final String STRATEGY_CLASS_PROPERTY = "--sm-cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_KEY = "cluster-strategy-class";
    public static final String STRATEGY_CLASS_PROP_VAL = "tigase.cluster.strategy.SMNonCachingAllNodes";
    public static final int SYNC_MAX_BATCH_SIZE = 1000;
    private static final String SYNC_ONLINE_JIDS = "sync-jids";
    private static final String TOKEN = "token";
    private static final String TRANSFER = "transfer";
    private static final String USER_ID = "userId";
    private static final String XMPP_SESSION_ID = "xmppSessionId";
    private static final Logger log = Logger.getLogger(SessionManagerClustered.class.getName());
    private JID my_address = null;
    private JID my_hostname = null;
    private int nodesNo = 0;
    private ClusteringStrategyIfc strategy = null;

    @Override
    public boolean containsJid(JID jid) {
        return super.containsJid(jid) || this.strategy.containsJid(jid);
    }

    @Override
    public JID[] getConnectionIdsForJid(JID jid) {
        JID[] ids = super.getConnectionIdsForJid(jid);
        if (ids == null) {
            ids = this.strategy.getConnectionIdsForJid(jid);
        }
        return ids;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String strategy_class = (String)params.get(STRATEGY_CLASS_PROPERTY);
        if (strategy_class == null) {
            strategy_class = STRATEGY_CLASS_PROP_VAL;
        }
        props.put(STRATEGY_CLASS_PROP_KEY, strategy_class);
        try {
            ClusteringStrategyIfc strat_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            Map<String, Object> strat_defs = strat_tmp.getDefaults(params);
            if (strat_defs != null) {
                props.putAll(strat_defs);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate clustering strategy for class: " + strategy_class, e);
        }
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        props.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        if (params.get("--cluster-nodes") != null) {
            String[] cl_nodes = ((String)params.get("--cluster-nodes")).split(",");
            this.nodesNo = cl_nodes.length;
        }
        return props;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.strategy.getStatistics(list);
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
        super.handlePresenceSet(conn);
        if (conn.getConnectionStatus() == ConnectionStatus.REMOTE) {
            return;
        }
        if (conn.getSessionData(CL_BR_INITIAL_PRESENCE) == null) {
            conn.putSessionData(CL_BR_INITIAL_PRESENCE, CL_BR_INITIAL_PRESENCE);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Handle presence set for Connection: " + conn);
            }
            List<JID> cl_nodes = this.strategy.getAllNodes();
            this.broadcastUserPresence(conn, cl_nodes);
        }
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
        super.handleResourceBind(conn);
        if (conn.getConnectionStatus() == ConnectionStatus.REMOTE) {
            return;
        }
        if (conn.getSessionData(CL_BR_USER_CONNECTED) == null) {
            conn.putSessionData(CL_BR_USER_CONNECTED, CL_BR_USER_CONNECTED);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Handle resource bind for Connection:: " + conn);
            }
            List<JID> cl_nodes = this.strategy.getAllNodes();
            try {
                Map<String, String> params = this.prepareBroadcastParams(conn, false);
                this.sendBroadcastPackets(null, params, ClusterMethods.USER_CONNECTED, cl_nodes.toArray(new JID[cl_nodes.size()]));
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with broadcast user connected for: " + conn, e);
            }
        } else if (log.isLoggable(Level.WARNING)) {
            log.warning("User resourc-rebind - not implemented yet in the cluster. Connection: " + conn);
        }
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return this.strategy.hasCompleteJidsInfo();
    }

    @Override
    public void nodeConnected(String node) {
        log.fine("Nodes connected: " + node);
        JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.addTrusted(jid);
        this.strategy.nodeConnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' connected (" + new Date() + ")", "New cluster node connected: " + node, node);
        if (this.strategy.needsSync()) {
            this.requestSync(jid);
        }
    }

    @Override
    public void nodeDisconnected(String node) {
        log.fine("Nodes disconnected: " + node);
        JID jid = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.strategy.nodeDisconnected(jid);
        this.sendAdminNotification("Cluster node '" + node + "' disconnected (" + new Date() + ")", "Cluster node disconnected: " + node, node);
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toString());
        }
        if (packet.getElemName() == "cluster" && packet.getElement().getXMLNS() == "tigase:cluster") {
            if (this.isTrusted(packet.getStanzaFrom())) {
                try {
                    this.processClusterPacket(packet);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Packet processing stringprep problem: " + packet);
                }
            } else if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Cluster packet from untrusted source: " + packet);
            }
            return;
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Ressource connection found: " + conn);
        }
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet) || this.sendToNextNode(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    @Override
    public int processingThreads() {
        return Math.max(this.nodesNo, super.processingThreads());
    }

    @Override
    public void setClusterController(ClusterController cl_controller) {
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String strategy_class = (String)props.get(STRATEGY_CLASS_PROP_KEY);
        try {
            ClusteringStrategyIfc strategy_tmp = (ClusteringStrategyIfc)Class.forName(strategy_class).newInstance();
            strategy_tmp.setProperties(props);
            this.strategy = strategy_tmp;
            this.strategy.nodeConnected(this.getComponentId());
            this.addTrusted(this.getComponentId());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not clustering strategy instance for class: " + strategy_class, e);
        }
        try {
            this.my_hostname = JID.jidInstance((String)((String)props.get(MY_DOMAIN_NAME_PROP_KEY)));
            this.my_address = JID.jidInstance((String)this.getName(), (String)((String)props.get(MY_DOMAIN_NAME_PROP_KEY)), null);
        }
        catch (TigaseStringprepException ex) {
            log.warning("Creating component source address failed stringprep processing: " + this.getName() + "@" + this.my_hostname);
        }
    }

    @Override
    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && conn.isAuthorized()) {
            try {
                JID connectionId = conn.getConnectionId();
                BareJID userId = conn.getBareJID();
                String resource = conn.getResource();
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put(CONNECTION_ID, connectionId.toString());
                params.put(USER_ID, userId.toString());
                params.put(RESOURCE, resource);
                List<JID> cl_nodes = this.strategy.getAllNodes();
                for (JID node : cl_nodes) {
                    if (node.equals((Object)this.getComponentId())) continue;
                    Element check_session_el = ClusterElement.createClusterMethodCall(this.getComponentId().toString(), node.toString(), StanzaType.set, ClusterMethods.USER_DISCONNECTED.toString(), params).getClusterElement();
                    this.fastAddOutPacket(Packet.packetInstance(check_session_el, this.getComponentId(), node));
                }
            }
            catch (Exception ex) {
                log.log(Level.WARNING, "Problem sending user disconnect broadcast for: " + conn, ex);
            }
        }
        XMPPSession parentSession = conn.getParentSession();
        super.closeSession(conn, closeOnly);
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE && parentSession != null && parentSession.getActiveResourcesSize() == parentSession.getResSizeForConnStatus(ConnectionStatus.REMOTE)) {
            List<XMPPResourceConnection> conns = parentSession.getActiveResources();
            for (XMPPResourceConnection xrc : conns) {
                try {
                    super.closeConnection(xrc.getConnectionId(), true);
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("Closed remote connection: " + xrc);
                }
                catch (NoConnectionIdException ex) {
                    log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                }
            }
        }
    }

    protected JID getFirstClusterNode(JID userJid) {
        JID cluster_node = null;
        List<JID> nodes = this.strategy.getNodesForJid(userJid);
        if (nodes != null) {
            for (JID node : nodes) {
                if (node.equals((Object)this.getComponentId())) continue;
                cluster_node = node;
                break;
            }
        }
        return cluster_node;
    }

    protected void processClusterPacket(Packet packet) throws TigaseStringprepException {
        ArrayDeque<Packet> results;
        block35: {
            results = new ArrayDeque<Packet>();
            ClusterElement clel = new ClusterElement(packet.getElement());
            ClusterMethods method = ClusterMethods.parseMethod(clel.getMethodName());
            block2 : switch (packet.getType()) {
                case set: {
                    if (clel.getMethodName() == null) {
                        this.processPacket(clel);
                    }
                    switch (method) {
                        case USER_INITIAL_PRESENCE: {
                            BareJID userId = BareJID.bareJIDInstanceNS((String)clel.getMethodParam(USER_ID));
                            String resource = clel.getMethodParam(RESOURCE);
                            XMPPSession session = this.getSession(userId);
                            if (session != null && session.getResourceForResource(resource) == null) {
                                JID connectionId = JID.jidInstanceNS((String)clel.getMethodParam(CONNECTION_ID));
                                String xmpp_sessionId = clel.getMethodParam(XMPP_SESSION_ID);
                                String domain = userId.getDomain();
                                XMPPResourceConnection res_con = this.loginUserSession(connectionId, domain, userId, resource, ConnectionStatus.REMOTE, xmpp_sessionId);
                                if (res_con != null) {
                                    List<Element> packs = clel.getDataPackets();
                                    for (Element elem : packs) {
                                        if (elem.getName() != "presence") continue;
                                        res_con.setPresence(elem);
                                    }
                                    res_con.putSessionData(SM_ID, packet.getStanzaFrom());
                                    this.updateUserResources(res_con, results);
                                    for (XMPPResourceConnection xrc : session.getActiveResources()) {
                                        if (xrc.getConnectionStatus() == ConnectionStatus.REMOTE || xrc.getPresence() == null) continue;
                                        this.broadcastUserPresence(xrc, packet.getStanzaFrom());
                                    }
                                    if (!log.isLoggable(Level.FINEST)) break block2;
                                    log.finest("Added remote session for: " + userId + ", from: " + packet.getStanzaFrom());
                                    break;
                                }
                                if (!log.isLoggable(Level.INFO)) break block2;
                                log.info("Couldn't create user session for: " + userId + ", resource: " + resource + ", connectionId: " + connectionId);
                                break;
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                if (session == null) {
                                    log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getStanzaFrom() + ", there is no other session for the user on this node.");
                                    break;
                                }
                                if (session.getResourceForResource(resource) != null) {
                                    log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getStanzaFrom() + ", there is already a session on this node for this resource.");
                                    break;
                                }
                                log.finest("Ignoring USER_INITIAL_PRESENCE for: " + userId + ", from: " + packet.getStanzaFrom() + ", reason unknown, please contact devs.");
                                break;
                            }
                            break block35;
                        }
                        case USER_CONNECTED: {
                            BareJID userId = BareJID.bareJIDInstanceNS((String)clel.getMethodParam(USER_ID));
                            String resource = clel.getMethodParam(RESOURCE);
                            JID connectionId = JID.jidInstanceNS((String)clel.getMethodParam(CONNECTION_ID));
                            this.strategy.usersConnected(packet.getStanzaFrom(), results, JID.jidInstanceNS((BareJID)userId, (String)(resource + "#" + connectionId)));
                            break;
                        }
                        case USER_DISCONNECTED: {
                            BareJID userId = BareJID.bareJIDInstanceNS((String)clel.getMethodParam(USER_ID));
                            String resource = clel.getMethodParam(RESOURCE);
                            this.strategy.userDisconnected(packet.getStanzaFrom(), results, JID.jidInstanceNS((BareJID)userId, (String)resource));
                            XMPPSession session = this.getSession(userId);
                            if (session != null) {
                                JID connectionId = JID.jidInstanceNS((String)clel.getMethodParam(CONNECTION_ID));
                                this.closeConnection(connectionId, true);
                                if (!log.isLoggable(Level.FINEST)) break block2;
                                log.finest("Removed remote session for: " + userId + ", from: " + packet.getStanzaFrom());
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case get: {
                    switch (method) {
                        case SYNC_ONLINE: {
                            Collection conns = this.connectionsByFrom.values();
                            int counter = 0;
                            StringBuilder sb = new StringBuilder(40000);
                            for (XMPPResourceConnection conn : conns) {
                                String jid = null;
                                try {
                                    jid = conn.getJID() + "#" + conn.getConnectionId();
                                }
                                catch (Exception e) {
                                    jid = null;
                                }
                                if (jid == null) continue;
                                if (sb.length() == 0) {
                                    sb.append(jid);
                                } else {
                                    sb.append(',').append(jid);
                                }
                                if (++counter <= 1000) continue;
                                ClusterElement resp = clel.createMethodResponse(this.getComponentId().toString(), StanzaType.result, null);
                                resp.addMethodResult(SYNC_ONLINE_JIDS, sb.toString());
                                this.fastAddOutPacket(Packet.packetInstance(resp.getClusterElement()));
                                counter = 0;
                                sb.delete(0, sb.length());
                            }
                            if (sb.length() <= 0) break;
                            ClusterElement resp = clel.createMethodResponse(this.getComponentId().toString(), StanzaType.result, null);
                            resp.addMethodResult(SYNC_ONLINE_JIDS, sb.toString());
                            this.fastAddOutPacket(Packet.packetInstance(resp.getClusterElement()));
                            break;
                        }
                    }
                    break;
                }
                case result: {
                    switch (method) {
                        case SYNC_ONLINE: {
                            String jids = clel.getMethodResultVal(SYNC_ONLINE_JIDS);
                            if (jids != null) {
                                String[] jidsa = jids.split(",");
                                JID[] jid_j = new JID[jidsa.length];
                                int idx = 0;
                                for (String jid : jidsa) {
                                    jid_j[idx++] = JID.jidInstanceNS((String)jid);
                                }
                                try {
                                    this.strategy.usersConnected(packet.getStanzaFrom(), results, jid_j);
                                }
                                catch (Exception e) {
                                    log.log(Level.WARNING, "Problem synchronizing cluster nodes for packet: " + packet, e);
                                }
                                break block2;
                            }
                            log.warning("Sync online packet with empty jids list! Please check this out: " + packet.toString());
                            break block2;
                        }
                    }
                    break;
                }
                case error: {
                    JID from = packet.getStanzaFrom();
                    clel.addVisitedNode(from.toString());
                    this.processPacket(clel);
                    break;
                }
            }
        }
        this.addOutPackets(results);
    }

    protected void processPacket(ClusterElement packet) {
        List<Element> elems = packet.getDataPackets();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                try {
                    Packet el_packet = Packet.packetInstance(elem);
                    XMPPResourceConnection conn = this.getXMPPResourceConnection(el_packet);
                    if (conn == null && this.sendToNextNode(packet, el_packet.getStanzaTo())) continue;
                    this.processPacket(el_packet, conn);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Addressing problem, stringprep failed for packet: " + elem);
                }
            }
        } else {
            log.finest("Empty packets list in the cluster packet: " + packet.toString());
        }
    }

    protected boolean sendToNextNode(ClusterElement clel, JID userId) throws TigaseStringprepException {
        ClusterElement next_clel = ClusterElement.createForNextNode(clel, this.strategy.getNodesForJid(userId), this.getComponentId());
        if (next_clel != null) {
            this.fastAddOutPacket(Packet.packetInstance(next_clel.getClusterElement()));
            return true;
        }
        String first = clel.getFirstNode();
        if (first != null && !first.equals(this.getComponentId().toString())) {
            Packet packet;
            List<Element> packets = clel.getDataPackets();
            Element elem = packets != null && packets.size() == 1 ? packets.get(0) : null;
            Packet packet2 = packet = elem != null ? Packet.packetInstance(elem) : null;
            if (packet == null || packet.getType() != StanzaType.result && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable && packet.getType() != StanzaType.error && (packet.getElemName() != "presence" || packet.getType() != null)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending back to the first node: " + first);
                }
                ClusterElement result = clel.nextClusterNode(first);
                result.addVisitedNode(this.getComponentId().toString());
                this.fastAddOutPacket(Packet.packetInstance(result.getClusterElement()));
            }
            return true;
        }
        return false;
    }

    protected boolean sendToNextNode(Packet packet) {
        JID cluster_node = this.getFirstClusterNode(packet.getStanzaTo());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Cluster node found: " + cluster_node);
        }
        if (cluster_node != null) {
            JID sess_man_id = this.getComponentId();
            ClusterElement clel = new ClusterElement(sess_man_id.toString(), cluster_node.toString(), StanzaType.set, packet);
            clel.addVisitedNode(sess_man_id.toString());
            this.fastAddOutPacket(Packet.packetInstance(clel.getClusterElement(), sess_man_id, cluster_node));
            return true;
        }
        return false;
    }

    protected void updateUserResources(XMPPResourceConnection res_con, Queue<Packet> results) {
        try {
            Element pres_update = res_con.getPresence();
            for (XMPPResourceConnection conn : res_con.getActiveSessions()) {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Update presence change to: " + conn.getjid());
                    }
                    if (conn != res_con && conn.isResourceSet() && conn.getConnectionStatus() != ConnectionStatus.REMOTE) {
                        pres_update = pres_update != null ? pres_update.clone() : new Element("presence");
                        Packet pack_update = Packet.packetInstance(pres_update, res_con.getJID(), conn.getJID().copyWithoutResource());
                        pack_update.setPacketTo(conn.getConnectionId());
                        results.offer(pack_update);
                        continue;
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.finer("Skipping presence update to: " + conn.getjid());
                }
                catch (NoConnectionIdException ex) {
                    log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                }
                catch (NotAuthorizedException ex) {
                    log.warning("This should not happen, unless the connection has been stopped in a concurrent thread or has not been authenticated yet: " + conn);
                }
            }
        }
        catch (NotAuthorizedException ex) {
            log.warning("User session from another cluster node authentication problem: " + res_con);
        }
    }

    private void broadcastUserPresence(XMPPResourceConnection conn, JID ... cl_nodes) {
        try {
            Map<String, String> params = this.prepareBroadcastParams(conn, true);
            Element presence = conn.getPresence();
            this.sendBroadcastPackets(presence, params, ClusterMethods.USER_INITIAL_PRESENCE, cl_nodes);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user initial presence message for: " + conn);
        }
    }

    private void broadcastUserPresence(XMPPResourceConnection conn, List<JID> cl_nodes) {
        try {
            Map<String, String> params = this.prepareBroadcastParams(conn, true);
            Element presence = conn.getPresence();
            if (presence == null) {
                log.log(Level.WARNING, "Something wrong. Initial presence NULL!!", Thread.currentThread().getStackTrace());
            }
            this.sendBroadcastPackets(presence, params, ClusterMethods.USER_INITIAL_PRESENCE, cl_nodes.toArray(new JID[cl_nodes.size()]));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem with broadcast user initial presence for: " + conn, e);
        }
    }

    private Map<String, String> prepareBroadcastParams(XMPPResourceConnection conn, boolean full_details) throws NotAuthorizedException, NoConnectionIdException {
        BareJID userId = conn.getBareJID();
        String resource = conn.getResource();
        JID connectionId = conn.getConnectionId();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(USER_ID, userId.toString());
        params.put(RESOURCE, resource);
        params.put(CONNECTION_ID, connectionId.toString());
        if (full_details) {
            String xmpp_sessionId = conn.getSessionId();
            long authTime = conn.getAuthTime();
            params.put(XMPP_SESSION_ID, xmpp_sessionId);
            params.put(AUTH_TIME, "" + authTime);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending user: " + userId + " session, resource: " + resource + ", xmpp_sessionId: " + xmpp_sessionId + ", connectionId: " + connectionId);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending user: " + userId + " session, resource: " + resource);
        }
        return params;
    }

    private void requestSync(JID node) {
        ClusterElement clel = ClusterElement.createClusterMethodCall(this.getComponentId().toString(), node.toString(), StanzaType.get, ClusterMethods.SYNC_ONLINE.name(), null);
        this.fastAddOutPacket(Packet.packetInstance(clel.getClusterElement(), this.getComponentId(), node));
    }

    private void sendAdminNotification(String msg, String subject, String node) {
        String message = msg;
        if (node != null) {
            message = msg + "\n";
        }
        boolean cnt = false;
        message = message + node + " connected to " + this.getDefHostName();
        Packet p_msg = Message.getMessage(this.my_address, this.my_hostname, StanzaType.normal, message, subject, "xyz", this.newPacketId(null));
        this.sendToAdmins(p_msg);
    }

    private void sendBroadcastPackets(Element data, Map<String, String> params, ClusterMethods methodCall, JID ... nodes) {
        ClusterElement clel = ClusterElement.createClusterMethodCall(this.getComponentId().toString(), nodes[0].toString(), StanzaType.set, methodCall.toString(), params);
        if (data != null) {
            clel.addDataPacket(data);
        }
        Element check_session_el = clel.getClusterElement();
        if (!nodes[0].equals((Object)this.getComponentId())) {
            this.fastAddOutPacket(Packet.packetInstance(check_session_el, this.getComponentId(), nodes[0]));
        }
        for (int i = 1; i < nodes.length; ++i) {
            if (nodes[i].equals((Object)this.getComponentId())) continue;
            Element elem = check_session_el.clone();
            elem.setAttribute("to", nodes[i].toString());
            this.fastAddOutPacket(Packet.packetInstance(elem, this.getComponentId(), nodes[i]));
        }
    }
}

