/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusterController;
import tigase.cluster.ClusteredComponent;
import tigase.server.ServiceChecker;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPIOService;

public class ClientConnectionClustered
extends ClientConnectionManager
implements ClusteredComponent {
    private static final Logger log = Logger.getLogger("tigase.cluster.ClientConnectionClustered");

    @Override
    public void nodeConnected(String node) {
    }

    @Override
    public void nodeDisconnected(String node) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Disconnected nodes: " + node);
        }
        final String hostname = node;
        this.doForAllServices(new ServiceChecker(){

            @Override
            public void check(XMPPIOService service) {
                JID dataReceiver = service.getDataReceiver();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Checking service for dataReceiver: " + dataReceiver);
                }
                if (dataReceiver != null && dataReceiver.getDomain().equals(hostname)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Stopping service because corresponding cluster node stopped.");
                    }
                    service.stop();
                }
            }
        });
    }

    @Override
    public void setClusterController(ClusterController cl_controller) {
    }
}

