/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2008 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 * 
 * $Rev: 1965 $
 * Last modified by $Author: kobit $
 * $Date: 2009-11-27 16:45:20 -0500 (Fri, 27 Nov 2009) $
 */

package tigase.server.script;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created: Jan 2, 2009 2:32:17 PM
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1965 $
 */
public abstract class AbstractScriptCommand implements CommandIfc {

	public static final Map<String, String> lineCommentStart = 
			new LinkedHashMap<String, String>();
	
	static {
		lineCommentStart.put("groovy", "//");	
		lineCommentStart.put("scala", "//");	
		lineCommentStart.put("python", "#");	
		lineCommentStart.put("py", "#");
		lineCommentStart.put("js", "//");
		lineCommentStart.put("ruby", "#");	
		lineCommentStart.put("rb", "#");
		lineCommentStart.put("perl", "#");	
		lineCommentStart.put("pl", "#");
		lineCommentStart.put("awk", "//");	
		lineCommentStart.put("lisp", ";");	
		lineCommentStart.put("el", ";");
		lineCommentStart.put("cl", ";");
		lineCommentStart.put("gc1", ";");
		lineCommentStart.put("gc3", ";");
		lineCommentStart.put("java", "//");	
	}

	private String commandId = null;
	private String description = null;

	@Override
	public void init(String id, String description) {
		this.commandId = id;
		this.description = description;
	}

	@Override
	public String getCommandId() {
		return this.commandId;
	}

	@Override
	public String getDescription() {
		return this.description;
	}

	protected boolean isEmpty(String val) {
		return val == null || val.isEmpty();
	}

}
