/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 1811 $
 * Last modified by $Author: kobit $
 * $Date: 2009-08-07 08:26:51 -0400 (Fri, 07 Aug 2009) $
 */
package tigase.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import tigase.stats.StatisticsList;

/**
 * Describe interface IOInterface here.
 *
 *
 * Created: Sat May 14 08:07:38 2005
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 1811 $
 */
public interface IOInterface {

  SocketChannel getSocketChannel();

  void stop() throws IOException;

  boolean isConnected();

  int write(final ByteBuffer buff) throws IOException;

  ByteBuffer read(final ByteBuffer buff) throws IOException;

  int bytesRead();

	int getInputPacketSize() throws IOException;

	boolean waitingToSend();

	int waitingToSendSize();

	boolean isRemoteAddress(String addr);

	void getStatistics(StatisticsList list);

} // IOInterface
