/*
 * Tigase Jabber/XMPP Server
 * Copyright (C) 2004-2007 "Artur Hefczyc" <artur.hefczyc@tigase.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 *
 * $Rev: 630 $
 * Last modified by $Author: kobit $
 * $Date: 2007-07-18 13:38:28 -0400 (Wed, 18 Jul 2007) $
 */
package tigase.disco;

import tigase.xml.Element;

/**
 * Describe class ServiceIdentity here.
 *
 *
 * Created: Sat Feb 10 13:34:54 2007
 *
 * @author <a href="mailto:artur.hefczyc@tigase.org">Artur Hefczyc</a>
 * @version $Rev: 630 $
 */
public class ServiceIdentity {

	private String category = null;
	private String type = null;
	private String name = null;

	/**
	 * Creates a new <code>ServiceIdentity</code> instance.
	 *
	 */
	public ServiceIdentity(String category, String type, String name) {
		this.category = category;
		this.type = type;
		this.name = name;
	}

	public String getCategory() {
		return category;
	}

	public String getType() {
		return type;
	}

	public String getName() {
		return name;
	}

	public Element getElement() {
		return new Element("identity",
			new String[] {"category", "type", "name"},
			new String[] {category, type, name});
	}

}