/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;

public class UpdatesChecker
extends Thread {
    private static final Logger log = Logger.getLogger("tigase.util.UpdatesChecker");
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final String VERSION_URL = "http://www.tigase.org/files/downloads/tigase-server/descript.ion";
    private static final String FILE_START = "tigase-server-";
    private AbstractMessageReceiver receiver = null;
    private long interval = 604800000L;
    private boolean stopped = false;
    private String intro_msg = null;
    private int major_ver = 0;
    private int minor_ver = 0;
    private int bugfix_ver = 0;

    public UpdatesChecker(long interval, AbstractMessageReceiver receiver, String intro_msg) {
        this.interval = interval * 86400000L;
        this.receiver = receiver;
        this.intro_msg = intro_msg;
        this.setName("UpdatesChecker");
    }

    @Override
    public void run() {
        String version = XMPPServer.getImplementationVersion();
        int idx = version.indexOf(45);
        if (idx > 0) {
            version = version.substring(0, idx);
        }
        log.info("Server version: " + version);
        String[] nums = version.split("\\.");
        try {
            this.major_ver = Integer.parseInt(nums[0]);
            this.minor_ver = Integer.parseInt(nums[1]);
            this.bugfix_ver = Integer.parseInt(nums[2]);
        }
        catch (NumberFormatException e) {
            log.warning("Can not detect the server version.... " + version);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem parsing server version.... " + version, e);
        }
        while (!this.stopped) {
            Element message = null;
            try {
                UpdatesChecker.sleep(this.interval);
                URLConnection connection = new URL(VERSION_URL).openConnection();
                connection.setConnectTimeout(60000);
                connection.setReadTimeout(60000);
                BufferedReader buffr = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = null;
                int major = 0;
                int minor = 0;
                int bugfix = 0;
                String build = "";
                while ((line = buffr.readLine()) != null) {
                    if (!line.startsWith(FILE_START)) continue;
                    String file = line.substring(FILE_START.length());
                    idx = file.indexOf(45);
                    version = file.substring(0, idx);
                    log.info("Found version: " + version);
                    nums = version.split("\\.");
                    try {
                        int major_t = Integer.parseInt(nums[0]);
                        int minor_t = Integer.parseInt(nums[1]);
                        int bugfix_t = Integer.parseInt(nums[2]);
                        if (major_t <= major && (major_t != major || minor_t <= minor) && (major_t != major || minor_t != minor || bugfix_t <= bugfix)) continue;
                        major = major_t;
                        minor = minor_t;
                        bugfix = bugfix_t;
                        int b_idx = file.indexOf(46, idx);
                        build = file.substring(idx, b_idx);
                    }
                    catch (NumberFormatException e) {
                        log.warning("Problem detecting new server version.... " + version);
                    }
                }
                if (major <= this.major_ver && (major != this.major_ver || minor <= this.minor_ver) && (major != this.major_ver || minor != this.minor_ver || bugfix <= this.bugfix_ver)) continue;
                String os_name = System.getProperty("os.name");
                String link = null;
                link = os_name.toLowerCase().contains("windows") ? "http://www.tigase.org/files/downloads/tigase-server/tigase-server-" + major + "." + minor + "." + bugfix + build + ".exe" : "http://www.tigase.org/files/downloads/tigase-server/tigase-server-" + major + "." + minor + "." + bugfix + build + ".tar.gz";
                message = new Element("message", new String[]{"to", "from"}, new String[]{this.receiver.getDefHostName(), "updates.checker@" + this.receiver.getDefHostName()});
                Element subject = new Element("subject", "Updates checker - new version of the Tigase server");
                message.addChild((XMLNodeIfc)subject);
                Element body = new Element("body", "You are currently using: '" + this.major_ver + "." + this.minor_ver + "." + this.bugfix_ver + "' version of Tigase" + " server. A new version of the server has been released: '" + major + "." + minor + "." + bugfix + "' and it is available for" + " download at address: " + link + "\n\n" + this.intro_msg);
                message.addChild((XMLNodeIfc)body);
                this.receiver.addPacket(Packet.packetInstance(message));
            }
            catch (TigaseStringprepException e) {
                log.log(Level.WARNING, "Incorrect stanza address settings: " + message.toString(), e);
            }
            catch (IOException e) {
                log.log(Level.WARNING, "Can not check updates for URL: http://www.tigase.org/files/downloads/tigase-server/descript.ion", e);
            }
            catch (InterruptedException e) {
                this.stopped = true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Unknown exception for: http://www.tigase.org/files/downloads/tigase-server/descript.ion", e);
            }
        }
    }
}

