/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataTypes {
    public static final Map<String, Character> typesMap = new LinkedHashMap<String, Character>();

    public static int parseSizeInt(String size, int def) {
        if (size == null) {
            return def;
        }
        int result = def;
        String toParse = size;
        int multiplier = 1;
        try {
            switch (size.charAt(size.length() - 1)) {
                case 'K': 
                case 'k': {
                    multiplier = 1024;
                    toParse = size.substring(0, size.length() - 1);
                    break;
                }
                case 'M': 
                case 'm': {
                    multiplier = 0x100000;
                    toParse = size.substring(0, size.length() - 1);
                    break;
                }
                case 'G': 
                case 'g': {
                    multiplier = 0x40000000;
                    toParse = size.substring(0, size.length() - 1);
                }
            }
            result = Integer.parseInt(toParse) * multiplier;
        }
        catch (Exception e) {
            return def;
        }
        return result;
    }

    public static boolean parseBool(String val) {
        return val != null && (val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on") || val.equals("1"));
    }

    public static Object decodeValueType(char typeId, String value) throws IllegalArgumentException {
        Object[] result = value.trim();
        try {
            switch (typeId) {
                case 'L': {
                    result = Long.decode(value.trim());
                    break;
                }
                case 'I': {
                    result = Integer.decode(value.trim());
                    break;
                }
                case 'B': {
                    result = DataTypes.parseBool(value.trim());
                    break;
                }
                case 's': {
                    String[] s_str = value.split(",");
                    String[] trimed_str = new String[s_str.length];
                    int si = 0;
                    for (String s : s_str) {
                        trimed_str[si++] = s.trim();
                    }
                    result = trimed_str;
                    break;
                }
                case 'l': {
                    String[] longs_str = value.split(",");
                    long[] longs = new long[longs_str.length];
                    int l = 0;
                    for (String s : longs_str) {
                        longs[l++] = Long.parseLong(s.trim());
                    }
                    result = longs;
                    break;
                }
                case 'i': {
                    String[] ints_str = value.split(",");
                    int[] ints = new int[ints_str.length];
                    int i = 0;
                    for (String s : ints_str) {
                        ints[i++] = Integer.parseInt(s.trim());
                    }
                    result = ints;
                    break;
                }
                case 'b': {
                    String[] bools_str = value.split(",");
                    boolean[] bools = new boolean[bools_str.length];
                    int b = 0;
                    for (String s : bools_str) {
                        bools[b++] = DataTypes.parseBool(s.trim());
                    }
                    result = bools;
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }

    public static String valueToString(Object value) {
        char t = DataTypes.getTypeId(value);
        String varr = value.toString();
        switch (t) {
            case 'l': {
                varr = Arrays.toString((long[])value);
                break;
            }
            case 'i': {
                varr = Arrays.toString((int[])value);
                break;
            }
            case 'b': {
                varr = Arrays.toString((boolean[])value);
                break;
            }
            default: {
                if (!value.getClass().isArray()) break;
                varr = Arrays.toString((Object[])value);
            }
        }
        if (value.getClass().isArray()) {
            varr = varr.substring(1, varr.length() - 1);
        }
        return varr;
    }

    public static char getTypeId(Object instance) {
        Character result = typesMap.get(instance.getClass().getName());
        if (result == null) {
            result = Character.valueOf('S');
        }
        return result.charValue();
    }

    static {
        typesMap.put(String.class.getName(), Character.valueOf('S'));
        typesMap.put(Long.class.getName(), Character.valueOf('L'));
        typesMap.put(Integer.class.getName(), Character.valueOf('I'));
        typesMap.put(Boolean.class.getName(), Character.valueOf('B'));
        typesMap.put(String[].class.getName(), Character.valueOf('s'));
        typesMap.put(Long[].class.getName(), Character.valueOf('l'));
        typesMap.put(Integer[].class.getName(), Character.valueOf('i'));
        typesMap.put(Boolean[].class.getName(), Character.valueOf('b'));
        typesMap.put(long[].class.getName(), Character.valueOf('l'));
        typesMap.put(int[].class.getName(), Character.valueOf('i'));
        typesMap.put(boolean[].class.getName(), Character.valueOf('b'));
    }
}

