/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.security.Security;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.auth.TigaseSaslProvider;
import tigase.conf.Configurable;
import tigase.db.DataOverwriteException;
import tigase.db.NonAuthUserRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserAuthRepository;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.XMPPServer;
import tigase.server.xmppsession.PacketFilter;
import tigase.server.xmppsession.SMResourceConnection;
import tigase.server.xmppsession.SessionManagerConfig;
import tigase.server.xmppsession.SessionManagerHandler;
import tigase.stats.StatisticsList;
import tigase.sys.OnlineJidsReporter;
import tigase.sys.TigaseRuntime;
import tigase.util.PriorityQueueAbstract;
import tigase.util.ProcessingThreads;
import tigase.util.QueueItem;
import tigase.util.TigaseStringprepException;
import tigase.util.WorkerThread;
import tigase.vhosts.VHostItem;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.ConnectionStatus;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.ProcessorFactory;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPPreprocessorIfc;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.XMPPStopListenerIfc;

public class SessionManager
extends AbstractMessageReceiver
implements Configurable,
SessionManagerHandler,
OnlineJidsReporter {
    protected static final String ADMIN_COMMAND_NODE = "http://jabber.org/protocol/admin";
    private static final Logger log = Logger.getLogger(SessionManager.class.getName());
    private long authTimeouts = 0L;
    private UserAuthRepository auth_repository = null;
    private long closedConnections = 0L;
    private PacketFilter filter = null;
    private long maxIdleTime = 86400000L;
    private int maxPluginsNo = 0;
    private int maxUserConnections = 0;
    private int maxUserSessions = 0;
    private NonAuthUserRepository naUserRepository = null;
    private long reaperInterval = 60000L;
    private SMResourceConnection smResourceConnection = null;
    private long totalUserConnections = 0L;
    private long totalUserSessions = 0L;
    private UserRepository user_repository = null;
    private Set<String> trusted = new ConcurrentSkipListSet<String>();
    private Map<String, XMPPStopListenerIfc> stopListeners = new ConcurrentHashMap<String, XMPPStopListenerIfc>();
    private boolean skipPrivacy = false;
    private ConcurrentHashMap<BareJID, XMPPSession> sessionsByNodeId = new ConcurrentHashMap();
    private ProcessingThreads<SessionOpenWorkerThread> sessionOpenThread = new ProcessingThreads<SessionOpenWorkerThread>(new SessionOpenWorkerThread(this), 1, 1, this.maxQueueSize, "session-open");
    private ProcessingThreads<SessionCloseWorkerThread> sessionCloseThread = new ProcessingThreads<SessionCloseWorkerThread>(new SessionCloseWorkerThread(), 4, 1, this.maxQueueSize, "session-close");
    private Map<String, ProcessingThreads<ProcessorWorkerThread>> processors = new ConcurrentHashMap<String, ProcessingThreads<ProcessorWorkerThread>>();
    private Map<String, XMPPPreprocessorIfc> preProcessors = new ConcurrentHashMap<String, XMPPPreprocessorIfc>();
    private Map<String, XMPPPostprocessorIfc> postProcessors = new ConcurrentHashMap<String, XMPPPostprocessorIfc>();
    private Map<String, Map<String, Object>> plugin_config = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, XMPPPacketFilterIfc> outFilters = new ConcurrentHashMap<String, XMPPPacketFilterIfc>();
    protected ConcurrentHashMap<JID, XMPPResourceConnection> connectionsByFrom = new ConcurrentHashMap();
    private ConnectionCheckCommandHandler connectionCheckCommandHandler = new ConnectionCheckCommandHandler();

    @Override
    public boolean containsJid(JID jid) {
        return this.sessionsByNodeId.containsKey(jid.getBareJID());
    }

    @Override
    public JID[] getConnectionIdsForJid(JID jid) {
        XMPPSession session;
        if (this.skipPrivacy() && (session = this.sessionsByNodeId.get(jid.getBareJID())) != null) {
            return session.getConnectionIds();
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        SessionManagerConfig.getDefaults(props, params);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "sm";
    }

    @Override
    public String getDiscoDescription() {
        return "Session manager";
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        LinkedList<Element> features = new LinkedList<Element>();
        List<Element> tmp = super.getDiscoFeatures(from);
        if (tmp != null) {
            features.addAll(tmp);
        }
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            Element[] discoFeatures = proc_t.getWorkerThread().processor.supDiscoFeatures(null);
            if (discoFeatures == null) continue;
            features.addAll(Arrays.asList(discoFeatures));
        }
        return features;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && (this.getName().equals(jid.getLocalpart()) || this.isLocalDomain(jid.toString()))) {
            Element query = super.getDiscoInfo(node, jid, from);
            if (query == null) {
                query = new Element("query");
                query.setXMLNS("http://jabber.org/protocol/disco#info");
            }
            if (node == null) {
                for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
                    Element[] discoFeatures = proc_t.getWorkerThread().processor.supDiscoFeatures(null);
                    if (discoFeatures == null) continue;
                    query.addChildren(Arrays.asList(discoFeatures));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Found disco info: " + (query != null ? query.toString() : null));
            }
            return query;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Not found disco info for node: " + node + ", jid: " + jid);
        }
        return null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        if (list.checkLevel(Level.FINEST)) {
            list.add(this.getName(), "Registered accounts", this.user_repository.getUsersCount(), Level.FINEST);
        }
        list.add(this.getName(), "Open user connections", this.connectionsByFrom.size(), Level.INFO);
        list.add(this.getName(), "Maximum user connections", this.maxUserConnections, Level.INFO);
        list.add(this.getName(), "Total user connections", this.totalUserConnections, Level.FINER);
        list.add(this.getName(), "Closed user connections", this.closedConnections, Level.FINER);
        list.add(this.getName(), "Open user sessions", this.sessionsByNodeId.size(), Level.FINE);
        list.add(this.getName(), "Maximum user sessions", this.maxUserSessions, Level.FINE);
        list.add(this.getName(), "Total user sessions", this.totalUserSessions, Level.FINER);
        list.add(this.getName(), "Authentication timouts", this.authTimeouts, Level.INFO);
        for (Map.Entry<String, ProcessingThreads<ProcessorWorkerThread>> procent : this.processors.entrySet()) {
            ProcessingThreads<ProcessorWorkerThread> proc = procent.getValue();
            if (!list.checkLevel(Level.INFO, (long)proc.getTotalQueueSize() + proc.getDroppedPackets())) continue;
            list.add(this.getName(), "Processor: " + procent.getKey(), "Queue: " + proc.getTotalQueueSize() + ", AvTime: " + proc.getAverageProcessingTime() + ", Runs: " + proc.getTotalRuns() + ", Lost: " + proc.getDroppedPackets(), Level.INFO);
        }
        if (list.checkLevel(Level.INFO, (long)this.sessionCloseThread.getTotalQueueSize() + this.sessionCloseThread.getDroppedPackets())) {
            list.add(this.getName(), "Processor: " + this.sessionCloseThread.getName(), "Queue: " + this.sessionCloseThread.getTotalQueueSize() + ", AvTime: " + this.sessionCloseThread.getAverageProcessingTime() + ", Runs: " + this.sessionCloseThread.getTotalRuns() + ", Lost: " + this.sessionCloseThread.getDroppedPackets(), Level.INFO);
        }
        if (list.checkLevel(Level.INFO, (long)this.sessionOpenThread.getTotalQueueSize() + this.sessionOpenThread.getDroppedPackets())) {
            list.add(this.getName(), "Processor: " + this.sessionOpenThread.getName(), "Queue: " + this.sessionOpenThread.getTotalQueueSize() + ", AvTime: " + this.sessionOpenThread.getAverageProcessingTime() + ", Runs: " + this.sessionOpenThread.getTotalRuns() + ", Lost: " + this.sessionOpenThread.getDroppedPackets(), Level.INFO);
        }
    }

    @Override
    public void handleLogin(String userName, XMPPResourceConnection conn) {
        BareJID userId;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("handleLogin called for: " + userName + ", conn_id: " + conn);
        }
        try {
            userId = BareJID.bareJIDInstance((String)userName, (String)conn.getDomain());
        }
        catch (TigaseStringprepException ex) {
            log.info("Stringprep problem for resource connection: " + conn + " and user name: " + userName);
            this.handleLogout(userName, conn);
            return;
        }
        this.registerNewSession(userId, conn);
        if (conn.getConnectionStatus() != ConnectionStatus.REMOTE) {
            conn.setConnectionStatus(ConnectionStatus.NORMAL);
        }
    }

    @Override
    public void handleLogout(String userName, XMPPResourceConnection conn) {
        String domain = conn.getDomain();
        BareJID userId = BareJID.bareJIDInstanceNS((String)userName, (String)domain);
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session != null && session.getActiveResourcesSize() <= 1) {
            this.sessionsByNodeId.remove(userId);
        }
        try {
            this.connectionsByFrom.remove(conn.getConnectionId());
            this.fastAddOutPacket(Command.CLOSE.getPacket(this.getComponentId(), conn.getConnectionId(), StanzaType.set, conn.nextStanzaId()));
        }
        catch (NoConnectionIdException ex) {
            log.warning("Connection ID not set for session: " + conn);
        }
    }

    @Override
    public void handlePresenceSet(XMPPResourceConnection conn) {
    }

    @Override
    public void handleResourceBind(XMPPResourceConnection conn) {
    }

    @Override
    public boolean handlesLocalDomains() {
        return true;
    }

    @Override
    public boolean hasCompleteJidsInfo() {
        return true;
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("authRepository", (Object)this.auth_repository);
        binds.put("userConnections", (Object)this.connectionsByFrom);
        binds.put("userRepository", (Object)this.user_repository);
        binds.put("userSessions", (Object)this.sessionsByNodeId);
    }

    @Override
    public boolean isLocalDomain(String domain, boolean includeComponents) {
        if (includeComponents) {
            return this.isLocalDomainOrComponent(domain);
        }
        return this.isLocalDomain(domain);
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Received packet: " + packet.toStringSecure());
        }
        if (packet.isCommand() && this.processCommand(packet)) {
            packet.processedBy("SessionManager");
            return;
        }
        XMPPResourceConnection conn = this.getXMPPResourceConnection(packet);
        if (conn == null && (this.isBrokenPacket(packet) || this.processAdminsOrDomains(packet))) {
            return;
        }
        this.processPacket(packet, conn);
    }

    @Override
    public int processingThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        TigaseRuntime.getTigaseRuntime().addOnlineJidsReporter(this);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String res_uri;
        String cls_name;
        String[] nodes;
        super.setProperties(props);
        Security.insertProviderAt(new TigaseSaslProvider(), 6);
        this.skipPrivacy = (Boolean)props.get("skip-privacy");
        this.filter = new PacketFilter();
        this.user_repository = (UserRepository)props.get("shared-user-repo-pool");
        if (this.user_repository == null) {
            this.user_repository = (UserRepository)props.get("shared-user-repo");
        } else {
            log.config("Using shared repository pool.");
        }
        if (this.user_repository != null) {
            log.config("Using shared repository instance: " + this.user_repository.getClass().getName());
        } else {
            LinkedHashMap<String, String> user_repo_params = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (!entry.getKey().startsWith("user-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                user_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                cls_name = (String)props.get("user-repo-class");
                res_uri = (String)props.get("user-repo-url");
                this.user_repository = RepositoryFactory.getUserRepository(this.getName(), cls_name, res_uri, user_repo_params);
                log.config("Initialized " + cls_name + " as user repository: " + res_uri);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize user repository: ", e);
            }
        }
        this.auth_repository = (UserAuthRepository)props.get("shared-auth-repo");
        if (this.auth_repository != null) {
            log.config("Using shared auth repository instance: " + this.auth_repository.getClass().getName());
        } else {
            LinkedHashMap<String, String> auth_repo_params = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                if (!entry.getKey().startsWith("auth-repo-params") || (nodes = entry.getKey().split("/")).length <= 1) continue;
                auth_repo_params.put(nodes[1], entry.getValue().toString());
            }
            try {
                cls_name = (String)props.get("auth-repo-class");
                res_uri = (String)props.get("auth-repo-url");
                this.auth_repository = RepositoryFactory.getAuthRepository(this.getName(), cls_name, res_uri, auth_repo_params);
                log.config("Initialized " + cls_name + " as auth repository: " + res_uri);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize auth repository: ", e);
            }
        }
        this.naUserRepository = new NARepository(this.user_repository);
        LinkedHashMap<String, Integer> plugins_concurrency = new LinkedHashMap<String, Integer>();
        Object[] plugins_conc = ((String)props.get("plugins-concurrency")).split(",");
        log.config("Loading concurrency plugins list: " + Arrays.toString(plugins_conc));
        if (plugins_conc != null && plugins_conc.length > 0) {
            for (Object plugc : plugins_conc) {
                log.config("Loading: " + (String)plugc);
                if (((String)plugc).trim().isEmpty()) continue;
                String[] pc = ((String)plugc).split("=");
                try {
                    int conc = Integer.parseInt(pc[1]);
                    plugins_concurrency.put(pc[0], conc);
                    log.config("Concurrency for plugin: " + pc[0] + " set to: " + conc);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Plugin concurrency parsing error for: " + (String)plugc + ", ", e);
                }
            }
        }
        Object[] plugins = (String[])props.get("plugins");
        log.config("Loaded plugins list: " + Arrays.toString(plugins));
        this.maxPluginsNo = plugins.length;
        this.processors.clear();
        for (Object plug_id : plugins) {
            if (((String)plug_id).equals("presence")) {
                log.warning("Your configuration is outdated! Note 'presence' and 'jaber:iq:roster' plugins are no longer exist. Use 'roster-presence' plugin instead, loading automaticly...");
                plug_id = "roster-presence";
            }
            log.config("Loading and configuring plugin: " + (String)plug_id);
            this.addPlugin((String)plug_id, (Integer)plugins_concurrency.get(plug_id));
            ConcurrentHashMap<String, Object> plugin_settings = new ConcurrentHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : props.entrySet()) {
                String[] nodes2;
                if (!entry.getKey().startsWith("plugins-conf") || (nodes2 = entry.getKey().split("/")).length <= 2) continue;
                Object[] ids = nodes2[1].split(",");
                Arrays.sort(ids);
                if (Arrays.binarySearch(ids, plug_id) < 0) continue;
                plugin_settings.put(nodes2[2], entry.getValue());
            }
            if (plugin_settings.size() <= 0) continue;
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Plugin configuration: " + ((Object)plugin_settings).toString());
            }
            this.plugin_config.put((String)plug_id, plugin_settings);
        }
        this.smResourceConnection = new SMResourceConnection(null, this.user_repository, this.auth_repository, this);
        this.registerNewSession(this.getComponentId().getBareJID(), this.smResourceConnection);
        String[] trusted_tmp = (String[])props.get("trusted");
        if (trusted_tmp != null) {
            for (String trust : trusted_tmp) {
                this.trusted.add(trust);
            }
        }
    }

    public boolean skipPrivacy() {
        return this.skipPrivacy;
    }

    @Override
    protected boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    protected void addOutPackets(Packet packet, XMPPResourceConnection conn, Queue<Packet> results) {
        for (XMPPPacketFilterIfc outfilter : this.outFilters.values()) {
            outfilter.filter(packet, conn, this.naUserRepository, results);
        }
        this.addOutPackets(results);
    }

    protected boolean addTrusted(JID jid) {
        return this.trusted.add(jid.getBareJID().toString());
    }

    protected void closeConnection(JID connectionId, boolean closeOnly) {
        XMPPResourceConnection connection;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed from: " + connectionId);
        }
        if ((connection = this.connectionsByFrom.remove(connectionId)) != null) {
            this.closeSession(connection, closeOnly);
        } else {
            log.fine("Can not find resource connection for packet: " + connectionId);
        }
    }

    protected void closeSession(XMPPResourceConnection conn, boolean closeOnly) {
        if (!closeOnly) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            for (XMPPStopListenerIfc stopProc : this.stopListeners.values()) {
                stopProc.stopped(conn, results, this.plugin_config.get(stopProc.id()));
            }
            this.addOutPackets(null, conn, results);
        }
        try {
            if (conn.isAuthorized() || conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                XMPPSession session;
                JID userJid = conn.getJID();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Closing connection for: " + userJid);
                }
                if ((session = conn.getParentSession()) != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Found parent session for: " + userJid);
                    }
                    if (session.getActiveResourcesSize() <= 1) {
                        session = this.sessionsByNodeId.remove(userJid.getBareJID());
                        if (session == null) {
                            log.info("UPS can't remove, session not found in map: " + userJid);
                        } else if (log.isLoggable(Level.FINER)) {
                            log.finer("Number of user sessions: " + this.sessionsByNodeId.size());
                        }
                        if (conn.getConnectionStatus() == ConnectionStatus.NORMAL) {
                            this.auth_repository.logout(userJid.getBareJID().toString());
                        }
                    } else if (log.isLoggable(Level.FINER)) {
                        StringBuilder sb = new StringBuilder();
                        for (XMPPResourceConnection res_con : session.getActiveResources()) {
                            sb.append(", res=" + res_con.getResource() + " (" + (Object)((Object)res_con.getConnectionStatus()) + ")");
                        }
                        log.finer("Number of connections is " + session.getActiveResourcesSize() + " for the user: " + userJid + sb.toString());
                    }
                }
            }
        }
        catch (NotAuthorizedException e) {
            log.info("Closed not authorized session: " + e);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception closing session... ", e);
        }
        ++this.closedConnections;
        conn.streamClosed();
    }

    protected XMPPResourceConnection createUserSession(JID conn_id, String domain) throws TigaseStringprepException {
        XMPPResourceConnection connection = new XMPPResourceConnection(conn_id, this.user_repository, this.auth_repository, this);
        VHostItem vitem = null;
        if (domain != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting hostname " + domain + " for connection: " + conn_id);
            }
            vitem = this.getVHostItem(domain);
        }
        if (vitem == null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Can't get VHostItem for domain: " + domain + ", using default one instead: " + this.getDefHostName());
            }
            vitem = new VHostItem(this.getDefHostName());
        }
        connection.setDomain(vitem.getUnmodifiableVHostItem());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Domain set for connectionId " + conn_id);
        }
        this.connectionsByFrom.put(conn_id, connection);
        int currSize = this.connectionsByFrom.size();
        if (currSize > this.maxUserConnections) {
            this.maxUserConnections = currSize;
        }
        ++this.totalUserConnections;
        return connection;
    }

    protected boolean delTrusted(JID jid) {
        return this.trusted.remove(jid.getBareJID().toString());
    }

    protected boolean fastAddOutPacket(Packet packet) {
        if (packet.getPacketFrom() == null) {
            packet.setPacketFrom(this.getComponentId());
        }
        return super.addOutPacket(packet);
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    protected XMPPResourceConnection getResourceConnection(JID jid) {
        XMPPSession session = this.getSession(jid.getBareJID());
        if (session != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Session not null, getting resource for jid: " + jid);
            }
            return session.getResourceConnection(jid);
        }
        if (this.isLocalDomain(jid.toString(), false)) {
            return this.smResourceConnection;
        }
        return null;
    }

    protected XMPPSession getSession(BareJID jid) {
        return this.sessionsByNodeId.get(jid);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(JID connId) {
        return this.connectionsByFrom.get(connId);
    }

    protected XMPPResourceConnection getXMPPResourceConnection(Packet p) {
        XMPPResourceConnection conn = null;
        JID from = p.getPacketFrom();
        if (from != null && (conn = this.connectionsByFrom.get(from)) != null) {
            return conn.getConnectionStatus() == ConnectionStatus.TEMP ? null : conn;
        }
        JID to = p.getStanzaTo();
        if (to != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Searching for resource connection for: " + to);
            }
            if ((conn = this.getResourceConnection(to)) != null && conn.getConnectionStatus() == ConnectionStatus.TEMP) {
                conn = null;
            }
        } else {
            log.info("Message without TO attribute set, don't know what to do wih this: " + p);
        }
        return conn;
    }

    protected boolean isBrokenPacket(Packet p) {
        if (p.getFrom() == null) {
            log.fine("Broken packet: " + p.toStringSecure());
            return true;
        }
        if (!p.getFrom().equals((Object)p.getStanzaFrom()) && (!p.isCommand() || p.isCommand() && p.getCommand() == Command.OTHER)) {
            if (p.getStanzaFrom() != null && !this.isLocalDomain(p.getStanzaFrom().getDomain())) {
                p.setPacketFrom(null);
                p.setPacketTo(null);
                this.fastAddOutPacket(p);
                return true;
            }
            log.fine("Broken packet: " + p.toStringSecure());
            try {
                Packet error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(p, "Service not available.", true);
                error.setPacketTo(p.getFrom());
                this.fastAddOutPacket(error);
            }
            catch (PacketErrorTypeException e) {
                log.fine("Packet is error type already: " + p.toStringSecure());
            }
            return true;
        }
        return false;
    }

    protected boolean isTrusted(JID jid) {
        if (this.trusted.contains(jid.getBareJID().toString())) {
            return true;
        }
        return this.isAdmin(jid);
    }

    protected boolean isTrusted(String jid) {
        return this.trusted.contains(jid);
    }

    protected XMPPResourceConnection loginUserSession(JID conn_id, String domain, BareJID user_id, String resource, ConnectionStatus conn_st, String xmpp_sessionId) {
        try {
            XMPPResourceConnection conn = this.createUserSession(conn_id, domain);
            conn.setConnectionStatus(conn_st);
            conn.setSessionId(xmpp_sessionId);
            this.user_repository.setData(user_id.toString(), "tokens", xmpp_sessionId, conn_id.toString());
            Authorization auth = conn.loginToken(user_id, xmpp_sessionId, conn_id.toString());
            if (auth == Authorization.AUTHORIZED) {
                this.handleLogin(user_id.getLocalpart(), conn);
                if (resource != null) {
                    conn.setResource(resource);
                }
            } else {
                this.connectionsByFrom.remove(conn_id);
                return null;
            }
            return conn;
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Problem logging user: " + user_id + "/" + resource, ex);
            return null;
        }
    }

    protected boolean processAdminsOrDomains(Packet packet) {
        JID to = packet.getStanzaTo();
        if (this.isLocalDomain(to.toString())) {
            if (packet.getElemName() == "message") {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Packet for admin: " + packet);
                }
                this.sendToAdmins(packet);
            } else if (log.isLoggable(Level.WARNING)) {
                log.warning("Packet for hostname, should be handled elsewhere: " + packet);
            }
            return true;
        }
        return false;
    }

    protected boolean processCommand(Packet pc) {
        if (pc.getStanzaTo() != null && !this.getComponentId().equals((Object)pc.getStanzaTo()) && !this.isLocalDomain(pc.getStanzaTo().toString())) {
            return false;
        }
        Iq iqc = (Iq)pc;
        boolean processing_result = false;
        if (log.isLoggable(Level.FINER)) {
            log.finer(iqc.getCommand().toString() + " command from: " + iqc.getFrom());
        }
        XMPPResourceConnection connection = this.connectionsByFrom.get(iqc.getFrom());
        switch (iqc.getCommand()) {
            case STREAM_OPENED: {
                this.sessionOpenThread.addItem(iqc, connection);
                processing_result = true;
                break;
            }
            case GETFEATURES: {
                if (iqc.getType() == StanzaType.get) {
                    List<Element> features = this.getFeatures(this.connectionsByFrom.get(iqc.getFrom()));
                    Packet result = iqc.commandResult(null);
                    Command.setData(result, features);
                    this.addOutPacket(result);
                }
                processing_result = true;
                break;
            }
            case STREAM_CLOSED: {
                this.fastAddOutPacket(iqc.okResult((String)null, 0));
                this.sessionCloseThread.addItem(iqc, connection);
                processing_result = true;
                break;
            }
            case STREAM_CLOSED_UPDATE: {
                if (this.connectionsByFrom.get(iqc.getFrom()) != null) {
                    this.sessionCloseThread.addItem(iqc, null);
                }
                processing_result = true;
                break;
            }
            case BROADCAST_TO_ONLINE: {
                JID from = iqc.getFrom();
                boolean trusted = false;
                try {
                    trusted = from != null && this.isTrusted(from) || connection != null && this.isTrusted(connection.getJID());
                }
                catch (NotAuthorizedException e) {
                    trusted = false;
                }
                try {
                    if (trusted) {
                        List<Element> packets = Command.getData(iqc);
                        if (packets != null) {
                            for (XMPPResourceConnection conn : this.connectionsByFrom.values()) {
                                if (!conn.isAuthorized()) continue;
                                Element el_copy = null;
                                try {
                                    for (Element el_pack : packets) {
                                        el_copy = el_pack.clone();
                                        el_copy.setAttribute("to", conn.getJID().toString());
                                        Packet out_packet = Packet.packetInstance(el_copy);
                                        out_packet.setPacketTo(conn.getConnectionId());
                                        this.addOutPacket(out_packet);
                                    }
                                }
                                catch (NoConnectionIdException e) {
                                }
                                catch (TigaseStringprepException e) {
                                    log.log(Level.WARNING, "Incorrect addressing for packet: " + el_copy, e);
                                }
                                catch (NotAuthorizedException e) {
                                    log.warning("Something wrong, connection is authenticated but NoAuthorizedException is thrown.");
                                }
                            }
                        } else {
                            this.addOutPacket(Authorization.BAD_REQUEST.getResponseMessage(iqc, "Missing packets for broadcast.", true));
                        }
                    } else {
                        this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(iqc, "You don't have enough permission to brodcast packet.", true));
                    }
                }
                catch (PacketErrorTypeException e) {
                    log.fine("Packet is error type already: " + iqc.toStringSecure());
                }
                processing_result = true;
                break;
            }
            case USER_STATUS: {
                try {
                    if (this.isTrusted(iqc.getStanzaFrom()) || this.isTrusted(iqc.getStanzaFrom().getDomain())) {
                        boolean available;
                        String av = Command.getFieldValue(pc, "available");
                        boolean bl = available = av == null || !av.equalsIgnoreCase("false");
                        if (available) {
                            Packet presence = null;
                            Element p = iqc.getElement().getChild("command").getChild("presence");
                            if (p != null) {
                                Element elem = p.clone();
                                elem.setXMLNS("jabber:client");
                                presence = Packet.packetInstance(elem);
                            }
                            if ((connection = this.connectionsByFrom.get(iqc.getStanzaFrom())) == null) {
                                JID user_jid = JID.jidInstance((String)Command.getFieldValue(iqc, "jid"));
                                connection = this.loginUserSession(iqc.getStanzaFrom(), user_jid.getDomain(), user_jid.getBareJID(), user_jid.getResource(), ConnectionStatus.NORMAL, "USER_STATUS");
                                connection.putSessionData("jingle", "active");
                                this.fastAddOutPacket(iqc.okResult((String)null, 0));
                                if (presence == null) {
                                    presence = Packet.packetInstance(new Element("presence", new Element[]{new Element("priority", "-1"), new Element("c", new String[]{"node", "ver", "ext", "xmlns"}, new String[]{"http://www.google.com/xmpp/client/caps", XMPPServer.getImplementationVersion(), "voice-v1", "http://jabber.org/protocol/caps"})}, null, null));
                                }
                            } else if (log.isLoggable(Level.FINEST)) {
                                log.finest("USER_STATUS set to true for user who is already available: " + iqc.toStringSecure());
                            }
                            if (presence != null) {
                                presence.setPacketFrom(iqc.getStanzaFrom());
                                presence.setPacketTo(this.getComponentId());
                                this.addOutPacket(presence);
                            }
                        } else {
                            connection = this.connectionsByFrom.remove(iqc.getStanzaFrom());
                            if (connection != null) {
                                this.closeSession(connection, false);
                                this.addOutPacket(iqc.okResult((String)null, 0));
                            } else {
                                this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "The user resource you want to remove does not exist.", true));
                                log.info("Can not find resource connection for packet: " + iqc.toStringSecure());
                            }
                        }
                    } else {
                        try {
                            this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(iqc, "Only trusted entity can do it.", true));
                        }
                        catch (PacketErrorTypeException e) {
                            log.warning("Packet error type when not expected: " + iqc.toStringSecure());
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        this.addOutPacket(Authorization.UNDEFINED_CONDITION.getResponseMessage(iqc, "Unexpected error occured during the request: " + e, true));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    log.log(Level.WARNING, "USER_STATUS session creation error: ", e);
                }
                processing_result = true;
                break;
            }
            case OTHER: {
                break;
            }
        }
        return processing_result;
    }

    protected void processPacket(Packet packet, XMPPResourceConnection conn) {
        packet.setPacketTo(this.getComponentId());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("processing packet: " + packet.toStringSecure() + ", connection: " + conn);
        }
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        boolean stop = false;
        if (!stop && this.filter.preprocess(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet preprocessed: " + packet.toStringSecure());
                if (results.size() > 0) {
                    for (Packet p : results) {
                        log.finest("Preprocess result: " + p.toStringSecure());
                    }
                }
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            for (XMPPPreprocessorIfc preproc : this.preProcessors.values()) {
                stop |= preproc.preProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && this.filter.forward(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-foward");
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet forwarded: " + packet.toStringSecure());
            }
            this.addOutPackets(packet, conn, results);
            return;
        }
        if (!stop) {
            this.walk(packet, conn, packet.getElement(), results);
        }
        if (!stop) {
            for (XMPPPostprocessorIfc postproc : this.postProcessors.values()) {
                postproc.postProcess(packet, conn, this.naUserRepository, results);
            }
        }
        if (!stop && !packet.wasProcessed() && (packet.getStanzaTo() == null || packet.getStanzaTo() != null && !this.isLocalDomain(packet.getStanzaTo().toString())) && this.filter.process(packet, conn, this.naUserRepository, results)) {
            packet.processedBy("filter-process");
        }
        this.setPermissions(conn, results);
        this.addOutPackets(packet, conn, results);
        if (!packet.wasProcessed()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet not processed: " + packet.toStringSecure());
            }
            Packet error = null;
            if (stop || conn == null && packet.getStanzaFrom() != null && packet.getStanzaTo() != null && !packet.getStanzaTo().equals((Object)this.getComponentId()) && (packet.getElemName() == "iq" || packet.getElemName() == "message")) {
                try {
                    error = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.fine("Service not available. Packet is error type already: " + packet.toStringSecure());
                }
            } else if (packet.getStanzaFrom() != null || conn != null) {
                try {
                    error = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not supported yet.", true);
                }
                catch (PacketErrorTypeException e) {
                    log.fine("Feature not supported yet. Packet is error type already: " + packet.toStringSecure());
                }
            }
            if (error != null) {
                if (error.getStanzaTo() != null) {
                    conn = this.getResourceConnection(error.getStanzaTo());
                }
                try {
                    if (conn != null) {
                        error.setPacketTo(conn.getConnectionId());
                    }
                    this.addOutPacket(error);
                }
                catch (NoConnectionIdException e) {
                    log.warning("Error packet to the SM's own session: " + error);
                }
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("Packet processed by: " + packet.getProcessorsIds().toString());
        }
    }

    protected void registerNewSession(BareJID userId, XMPPResourceConnection conn) {
        XMPPSession session = this.sessionsByNodeId.get(userId);
        if (session == null) {
            session = new XMPPSession(userId.getLocalpart());
            this.sessionsByNodeId.put(userId, session);
            int currSize = this.sessionsByNodeId.size();
            if (currSize > this.maxUserSessions) {
                this.maxUserSessions = currSize;
            }
            ++this.totalUserSessions;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Created new XMPPSession for: " + userId);
            }
        } else {
            List<XMPPResourceConnection> connections = session.getActiveResources();
            if (connections != null) {
                for (XMPPResourceConnection connection : connections) {
                    if (connection == conn) continue;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Checking connection: " + connection);
                    }
                    try {
                        this.addOutPacketWithTimeout(Command.CHECK_USER_CONNECTION.getPacket(this.getComponentId(), connection.getConnectionId(), StanzaType.get, UUID.randomUUID().toString()), this.connectionCheckCommandHandler, 30L, TimeUnit.SECONDS);
                    }
                    catch (NoConnectionIdException ex) {
                        log.log(Level.WARNING, "This should not happen, check it out!, ", ex);
                    }
                }
            }
        }
        try {
            session.addResourceConnection(conn);
        }
        catch (TigaseStringprepException ex) {
            log.info("Stringprep problem for resource connection: " + conn);
            this.handleLogout(userId.getLocalpart(), conn);
        }
    }

    protected void sendToAdmins(Packet packet) {
        for (BareJID admin : this.admins) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Sending packet to admin: " + admin);
            }
            Packet admin_pac = packet.copyElementOnly();
            admin_pac.initVars(packet.getStanzaFrom(), JID.jidInstance((BareJID)admin));
            this.processPacket(admin_pac);
        }
    }

    private void addPlugin(String plug_id, Integer conc) {
        XMPPPacketFilterIfc filterproc;
        XMPPStopListenerIfc stoplist;
        XMPPPostprocessorIfc postproc;
        XMPPPreprocessorIfc preproc;
        XMPPProcessorIfc proc = ProcessorFactory.getProcessor(plug_id);
        int concurrency = conc != null ? conc : (proc != null ? proc.concurrentQueuesNo() : 0);
        System.out.println("Loading plugin: " + plug_id + "=" + concurrency + " ...");
        boolean loaded = false;
        if (proc != null) {
            ProcessorWorkerThread worker = new ProcessorWorkerThread(proc);
            ProcessingThreads<ProcessorWorkerThread> pt = new ProcessingThreads<ProcessorWorkerThread>(worker, concurrency, proc.concurrentThreadsPerQueue(), this.maxQueueSize, proc.id());
            this.processors.put(plug_id, pt);
            log.config("Added processor: " + proc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((preproc = ProcessorFactory.getPreprocessor(plug_id)) != null) {
            this.preProcessors.put(plug_id, preproc);
            log.config("Added preprocessor: " + preproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((postproc = ProcessorFactory.getPostprocessor(plug_id)) != null) {
            this.postProcessors.put(plug_id, postproc);
            log.config("Added postprocessor: " + postproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((stoplist = ProcessorFactory.getStopListener(plug_id)) != null) {
            this.stopListeners.put(plug_id, stoplist);
            log.config("Added stopped processor: " + stoplist.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if ((filterproc = ProcessorFactory.getPacketFilter(plug_id)) != null) {
            this.outFilters.put(plug_id, filterproc);
            log.config("Added packet filter: " + filterproc.getClass().getSimpleName() + " for plugin id: " + plug_id);
            loaded = true;
        }
        if (!loaded) {
            log.warning("No implementation found for plugin id: " + plug_id);
        }
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            Element[] features = proc_t.getWorkerThread().processor.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    private void setPermissions(XMPPResourceConnection conn, Queue<Packet> results) {
        Permissions perms = Permissions.NONE;
        if (conn != null) {
            perms = Permissions.LOCAL;
            if (conn.isAuthorized()) {
                perms = Permissions.AUTH;
                if (conn.isAnonymous()) {
                    perms = Permissions.ANONYM;
                } else {
                    try {
                        JID id = conn.getJID();
                        if (this.isTrusted(id)) {
                            perms = Permissions.TRUSTED;
                        }
                        if (this.isAdmin(id)) {
                            perms = Permissions.ADMIN;
                        }
                    }
                    catch (NotAuthorizedException e) {
                        perms = Permissions.NONE;
                    }
                }
            }
        }
        for (Packet res : results) {
            res.setPermissions(perms);
        }
    }

    private void walk(Packet packet, XMPPResourceConnection connection, Element elem, Queue<Packet> results) {
        for (ProcessingThreads<ProcessorWorkerThread> proc_t : this.processors.values()) {
            XMPPProcessorIfc processor;
            String xmlns = elem.getXMLNS();
            if (xmlns == null) {
                xmlns = "jabber:client";
            }
            if (!(processor = proc_t.getWorkerThread().processor).isSupporting(elem.getName(), xmlns)) continue;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XMPPProcessorIfc: " + processor.getClass().getSimpleName() + " (" + processor.id() + ")" + "\n Request: " + elem.toString() + ", conn: " + connection);
            }
            if (proc_t.addItem(packet, connection)) {
                packet.processedBy(processor.id());
                continue;
            }
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Can not add packet: " + packet.toStringSecure() + " to processor: " + proc_t.getName() + " internal queue full.");
        }
        List children = elem.getChildren();
        if (children != null) {
            for (Element child : children) {
                this.walk(packet, connection, child, results);
            }
        }
    }

    private class SessionOpenWorkerThread
    extends WorkerThread {
        private SessionManager sm = null;

        public SessionOpenWorkerThread(SessionManager sm) {
            this.sm = sm;
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueueAbstract<QueueItem> queue) {
            SessionOpenWorkerThread worker = new SessionOpenWorkerThread(this.sm);
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            if (item.conn == null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Adding resource connection for: " + item.packet.getFrom());
                }
                String hostname = Command.getFieldValue(item.packet, "hostname");
                try {
                    item.conn = SessionManager.this.createUserSession(item.packet.getFrom(), hostname);
                }
                catch (TigaseStringprepException ex) {
                    log.warning("Incrrect hostname, did not pass stringprep processing: " + hostname);
                    return;
                }
                SessionManager.this.addTimerTask(new AuthenticationTimer(item.packet.getFrom()), 2L, TimeUnit.MINUTES);
            } else if (log.isLoggable(Level.FINEST)) {
                log.finest("Stream opened for existing session, authorized: " + item.conn.isAuthorized());
            }
            item.conn.setSessionId(Command.getFieldValue(item.packet, "session-id"));
            item.conn.setDefLang(Command.getFieldValue(item.packet, "xml:lang"));
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting session-id " + item.conn.getSessionId() + " for connection: " + item.conn);
            }
            SessionManager.this.fastAddOutPacket(item.packet.okResult((String)null, 0));
        }
    }

    private class SessionCloseWorkerThread
    extends WorkerThread {
        private SessionCloseWorkerThread() {
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueueAbstract<QueueItem> queue) {
            SessionCloseWorkerThread worker = new SessionCloseWorkerThread();
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            SessionManager.this.closeConnection(item.packet.getFrom(), false);
        }
    }

    private class ProcessorWorkerThread
    extends WorkerThread {
        private XMPPProcessorIfc processor = null;
        private ArrayDeque<Packet> local_results = new ArrayDeque();

        public ProcessorWorkerThread(XMPPProcessorIfc processor) {
            this.processor = processor;
        }

        @Override
        public WorkerThread getNewInstance(PriorityQueueAbstract<QueueItem> queue) {
            ProcessorWorkerThread worker = new ProcessorWorkerThread(this.processor);
            worker.setQueue(queue);
            return worker;
        }

        @Override
        public void process(QueueItem item) {
            try {
                if (item.conn != null) {
                    this.processor.process(item.packet, item.conn, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                    SessionManager.this.setPermissions(item.conn, this.local_results);
                } else {
                    this.processor.process(item.packet, null, SessionManager.this.naUserRepository, this.local_results, (Map)SessionManager.this.plugin_config.get(this.processor.id()));
                }
                SessionManager.this.addOutPackets(item.packet, item.conn, this.local_results);
            }
            catch (PacketErrorTypeException e) {
                log.info("Already error packet, ignoring: " + item.packet.toStringSecure());
            }
            catch (XMPPException e) {
                log.log(Level.WARNING, "Exception during packet processing: " + item.packet.toStringSecure(), e);
            }
        }
    }

    private class NARepository
    implements NonAuthUserRepository {
        private final Set<String> existing_domains = new ConcurrentSkipListSet<String>();
        private final UserRepository rep;

        NARepository(UserRepository userRep) {
            this.rep = userRep;
        }

        @Override
        public void addOfflineData(String user, String subnode, String key, String value) throws UserNotFoundException, DataOverwriteException {
            String node = this.calcNode("offline", subnode);
            try {
                String data = this.rep.getData(user, node, key);
                if (data != null) {
                    throw new DataOverwriteException("Not authorized attempt to overwrite data.");
                }
                this.rep.setData(user, node, key, value);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }

        @Override
        public void addOfflineDataList(String user, String subnode, String key, String[] list) throws UserNotFoundException {
            try {
                if (!this.rep.userExists(user)) {
                    throw new UserNotFoundException("User: " + user + " has not been found inthe repository.");
                }
                this.rep.addDataList(user, this.calcNode("offline", subnode), key, list);
            }
            catch (UserNotFoundException e) {
                log.info("User not found in repository: " + user);
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
            }
        }

        @Override
        public String getDomainTempData(String domain, String subnode, String key, String def) throws TigaseDBException {
            this.checkDomain(domain);
            return this.rep.getData(domain, subnode, key, def);
        }

        @Override
        public String getPublicData(String user, String subnode, String key, String def) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getData(user, this.calcNode("public", subnode), key, def) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public String[] getPublicDataList(String user, String subnode, String key) throws UserNotFoundException {
            try {
                return this.rep.userExists(user) ? this.rep.getDataList(user, this.calcNode("public", subnode), key) : null;
            }
            catch (TigaseDBException e) {
                log.log(Level.SEVERE, "Problem accessing repository data.", e);
                return null;
            }
        }

        @Override
        public String getTempData(String subnode, String key, String def) throws TigaseDBException {
            this.checkDomain(SessionManager.this.getDefHostName());
            return this.rep.getData(SessionManager.this.getDefHostName(), subnode, key, def);
        }

        @Override
        public void putDomainTempData(String domain, String subnode, String key, String value) throws TigaseDBException {
            this.checkDomain(domain);
            this.rep.setData(domain, subnode, key, value);
        }

        @Override
        public void putTempData(String subnode, String key, String value) throws TigaseDBException {
            this.checkDomain(SessionManager.this.getDefHostName());
            this.rep.setData(SessionManager.this.getDefHostName(), subnode, key, value);
        }

        @Override
        public void removeDomainTempData(String domain, String subnode, String key) throws TigaseDBException {
            this.checkDomain(SessionManager.this.getDefHostName());
            this.rep.removeData(domain, subnode, key);
        }

        @Override
        public void removeTempData(String subnode, String key) throws TigaseDBException {
            this.checkDomain(SessionManager.this.getDefHostName());
            this.rep.removeData(SessionManager.this.getDefHostName(), subnode, key);
        }

        private String calcNode(String base, String subnode) {
            if (subnode == null) {
                return base;
            }
            return base + "/" + subnode;
        }

        private void checkDomain(String domain) throws TigaseDBException {
            if (!this.existing_domains.contains(domain) && !this.rep.userExists(domain)) {
                this.rep.addUser(domain);
                this.existing_domains.add(domain);
            }
        }
    }

    private class ConnectionCheckCommandHandler
    implements ReceiverTimeoutHandler {
        private ConnectionCheckCommandHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (response.getType() == StanzaType.error) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Connection checker error received, closing connection: " + packet.getTo());
                }
                SessionManager.this.closeConnection(packet.getTo(), false);
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Connection checker timeout expired, closing connection: " + packet.getTo());
            }
            SessionManager.this.closeConnection(packet.getTo(), false);
        }
    }

    private class AuthenticationTimer
    extends TimerTask {
        private JID connId = null;

        private AuthenticationTimer(JID connId) {
            this.connId = connId;
        }

        @Override
        public void run() {
            XMPPResourceConnection conn = SessionManager.this.connectionsByFrom.get(this.connId);
            if (conn != null && !conn.isAuthorized()) {
                SessionManager.this.connectionsByFrom.remove(this.connId);
                ++SessionManager.this.authTimeouts;
                log.info("Authentication timeout expired, closing connection: " + this.connId);
                SessionManager.this.fastAddOutPacket(Command.CLOSE.getPacket(SessionManager.this.getComponentId(), this.connId, StanzaType.set, conn.nextStanzaId()));
            }
        }
    }
}

