/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.sreceiver;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.sreceiver.PropertyItem;
import tigase.server.sreceiver.ReceiverTaskIfc;
import tigase.server.sreceiver.StanzaReceiver;
import tigase.server.sreceiver.TaskCommandIfc;
import tigase.server.sreceiver.TaskCommons;
import tigase.server.sreceiver.TaskType;
import tigase.util.TigaseStringprepException;
import tigase.xml.XMLUtils;
import tigase.xmpp.BareJID;

public class NewTaskCommand
implements TaskCommandIfc {
    private static Logger log = Logger.getLogger("tigase.server.sreceiver.NewTaskCommand");

    @Override
    public String getNodeName() {
        return "new-task";
    }

    @Override
    public String getDescription() {
        return "Add new task...";
    }

    private boolean checkTaskName(String task_name, Packet result, StanzaReceiver receiv) {
        String msg = BareJID.parseJID((String)task_name)[0];
        if (msg != null) {
            Command.addFieldValue(result, "Info", "Note!! " + msg + ", please provide valid task name.", "fixed");
            return false;
        }
        ReceiverTaskIfc task = receiv.getTaskInstances().get(task_name);
        if (task != null) {
            Command.addFieldValue(result, "Info", "Note!! Task with provided name already exists.", "fixed");
            Command.addFieldValue(result, "Info", "Please provide different task name.", "fixed");
            return false;
        }
        return true;
    }

    private void newTask_Step1(Packet result, StanzaReceiver receiv) {
        Command.addFieldValue(result, "Info", "Press:", "fixed");
        Command.addFieldValue(result, "Info", "'Next' to set all parameters for the new task.", "fixed");
        Command.setStatus(result, Command.Status.executing);
        Command.addAction(result, Command.Action.next);
        Command.addFieldValue(result, "Task name", "", "text-single", "Task name");
        String[] task_types = receiv.getTaskTypes().keySet().toArray(new String[0]);
        Command.addFieldValue(result, "Task type", task_types[0], "Task type", task_types, task_types);
    }

    private void newTask_Step2(Packet packet, Packet result, StanzaReceiver receiv) {
        int end;
        String task_type = Command.getFieldValue(packet, "Task type");
        ReceiverTaskIfc task_t = receiv.getTaskTypes().get(task_type).getTaskType();
        int start = 0;
        int line_len = 60;
        do {
            int n = end = start + line_len < task_t.getHelp().length() ? start + line_len : task_t.getHelp().length();
            while (end < task_t.getHelp().length() && task_t.getHelp().charAt(end) != ' ') {
                ++end;
            }
            Command.addFieldValue(result, "task" + start, task_t.getHelp().substring(start, end), "fixed");
        } while ((start = end) < task_t.getHelp().length());
        Command.addFieldValue(result, "Info2", "1. 'Finish' to create component with this parameters.", "fixed");
        Command.addFieldValue(result, "Info3", "2. 'Previous' to go back and select different component.", "fixed");
        Command.setStatus(result, Command.Status.executing);
        Command.addAction(result, Command.Action.complete);
        Command.addAction(result, Command.Action.prev);
        Map<String, PropertyItem> default_props = task_t.getDefaultParams();
        PropertyItem pi = default_props.get("task-owner");
        if (pi != null) {
            pi.setValue(packet.getStanzaFrom().getBareJID().toString());
        }
        TaskCommons.propertyItems2Command(default_props, result);
    }

    private void newTask_Step3(Packet packet, Packet result, StanzaReceiver receiv) throws TigaseStringprepException {
        String task_name = Command.getFieldValue(packet, "Task name");
        String task_type = Command.getFieldValue(packet, "Task type");
        Map<String, PropertyItem> default_props = receiv.getTaskTypes().get(task_type).getTaskType().getDefaultParams();
        LinkedHashMap<String, Object> new_params = new LinkedHashMap<String, Object>();
        for (String key : default_props.keySet()) {
            if (default_props.get(key).isMultiValue()) {
                String[] values = Command.getFieldValues(packet, XMLUtils.escape((String)key));
                new_params.put(key, values);
                continue;
            }
            String value = Command.getFieldValue(packet, XMLUtils.escape((String)key));
            if (value == null) {
                value = "";
            }
            value = XMLUtils.unescape((String)value);
            new_params.put(key, value);
        }
        receiv.addTaskInstance(task_type, task_name, new_params);
        Command.addFieldValue(result, "Info", "Created task: " + task_name, "fixed");
    }

    @Override
    public void processCommand(Packet packet, Packet result, StanzaReceiver receiv) {
        String task_name = Command.getFieldValue(packet, "Task name");
        if (task_name == null || !this.checkTaskName(task_name, result, receiv) || Command.getAction(packet) == Command.Action.prev) {
            Command.addFieldValue(result, "step", "step1", "hidden");
            this.newTask_Step1(result, receiv);
            return;
        }
        String task_type = Command.getFieldValue(packet, "Task type");
        TaskType tt = receiv.getTaskTypes().get(task_type);
        if (tt == null) {
            Command.addFieldValue(result, "Info", "I am sorry there is a problem with instantiating task of this type: " + task_type, "fixed");
            return;
        }
        if (tt.getMaxInstancesNo() <= tt.getInstancesNo()) {
            Command.addFieldValue(result, "Info", "I am sorry, maximum number of tasks instances for this type has been exceeded: " + task_type, "fixed");
            return;
        }
        if (!receiv.isAllowedCreate(packet.getFrom(), task_type)) {
            Command.addFieldValue(result, "Info", "I am sorry, you are not allowed to create task of this type: " + task_type, "fixed");
            return;
        }
        Command.addFieldValue(result, "Task name", task_name, "hidden");
        Command.addFieldValue(result, "Task type", task_type, "hidden");
        String step = Command.getFieldValue(packet, "step");
        if (step == null || step.equals("step1")) {
            Command.addFieldValue(result, "step", "step2", "hidden");
            this.newTask_Step2(packet, result, receiv);
            return;
        }
        try {
            this.newTask_Step3(packet, result, receiv);
        }
        catch (TigaseStringprepException ex) {
            Logger.getLogger(NewTaskCommand.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

