/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.script;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.script.AbstractScriptCommand;
import tigase.server.script.Script;

public class AddScriptCommand
extends AbstractScriptCommand {
    private static final Logger log = Logger.getLogger(AddScriptCommand.class.getName());

    @Override
    public void runCommand(Iq packet, Bindings binds, Queue<Packet> results) {
        String language = Command.getFieldValue(packet, "Language");
        String commandId = Command.getFieldValue(packet, "Command Id");
        String description = Command.getFieldValue(packet, "Description");
        String[] scriptText = Command.getFieldValues(packet, "Script text");
        boolean saveToDisk = Command.getCheckBoxFieldValue(packet, "Save to disk");
        if (this.isEmpty(language) || this.isEmpty(commandId) || this.isEmpty(description) || scriptText == null) {
            results.offer(this.prepareScriptCommand(packet, binds));
        } else {
            StringBuilder sb = new StringBuilder();
            for (String string : scriptText) {
                if (string == null) continue;
                sb.append(string + "\n");
            }
            try {
                Script s = this.addAdminScript(commandId, description, sb.toString(), language, null, binds);
                Packet result = packet.commandResult(Command.DataType.result);
                Command.addTextField(result, "Note", "Script loaded successfuly.");
                results.offer(result);
                if (saveToDisk) {
                    this.saveCommandToDisk(commandId, description, sb, s.getFileExtension(), binds);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Can't initialize script: ", e);
                Packet result = packet.commandResult(Command.DataType.result);
                Command.addTextField(result, "Note", "Script initialization error.");
                StackTraceElement[] ste = e.getStackTrace();
                String[] error = new String[ste.length + 2];
                error[0] = e.getMessage();
                error[1] = e.toString();
                for (int i = 0; i < ste.length; ++i) {
                    error[i + 2] = ste[i].toString();
                }
                Command.addTextField(result, "Error message", e.getMessage());
                Command.addFieldMultiValue(result, "Debug info", Arrays.asList(error));
                results.offer(result);
            }
        }
    }

    public Script addAdminScript(String cmdId, String cmdDescr, String script, String lang, String ext, Bindings binds) throws ScriptException {
        Script as = new Script();
        as.init(cmdId, cmdDescr, script, lang, ext, binds);
        Map adminCommands = (Map)binds.get("adminCommands");
        adminCommands.put(as.getCommandId(), as);
        return as;
    }

    private Packet prepareScriptCommand(Iq packet, Bindings binds) {
        Packet result = packet.commandResult(Command.DataType.form);
        Command.addFieldValue(result, "Description", "Short description");
        Command.addFieldValue(result, "Command Id", "new-command");
        ScriptEngineManager scriptEngineManager = (ScriptEngineManager)binds.get("scriptManager");
        List<ScriptEngineFactory> scriptFactories = scriptEngineManager.getEngineFactories();
        if (scriptFactories != null) {
            String[] langs = new String[scriptFactories.size()];
            int idx = 0;
            String def = null;
            for (ScriptEngineFactory scriptEngineFactory : scriptFactories) {
                langs[idx++] = scriptEngineFactory.getLanguageName();
                if (!scriptEngineFactory.getLanguageName().equals("groovy")) continue;
                def = "groovy";
            }
            if (def == null) {
                def = langs[0];
            }
            Command.addFieldValue(result, "Language", def, "Language", langs, langs);
        }
        Command.addFieldMultiValue(result, "Script text", Collections.nCopies(1, ""));
        Command.addCheckBoxField(result, "Save to disk", true);
        return result;
    }

    @Override
    public Bindings getBindings() {
        return null;
    }

    private void saveCommandToDisk(String commandId, String description, StringBuilder sb, String fileExtension, Bindings binds) throws IOException {
        File fileName = new File((String)binds.get("scriptCompDir"), commandId + "." + fileExtension);
        log.info("Saving command: " + commandId + " to disk file: " + fileName.toString());
        FileWriter fw = new FileWriter(fileName, false);
        String comment = (String)lineCommentStart.get(fileExtension);
        if (comment == null) {
            comment = "//";
        }
        fw.write(comment + " " + "AS:Description:" + " " + description + '\n');
        fw.write(comment + " " + "AS:CommandId:" + " " + commandId + '\n');
        fw.write(comment + " " + "AS:Component:" + " " + binds.get("componentName") + '\n');
        fw.write(sb.toString());
        fw.close();
    }
}

