/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentConnection;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.server.ext.StreamOpenHandler;
import tigase.xmpp.XMPPIOService;

public class ComponentAcceptStreamOpenHandler
implements StreamOpenHandler {
    private static final Logger log = Logger.getLogger(ComponentAcceptStreamOpenHandler.class.getName());
    private static final String XMLNS = "jabber:component:accept";
    private String[] xmlnss = new String[]{"jabber:component:accept"};

    @Override
    public String streamOpened(XMPPIOService<List<ComponentConnection>> serv, Map<String, String> attribs, ComponentProtocolHandler handler) {
        switch (serv.connectionType()) {
            case connect: {
                String id = attribs.get("id");
                if (id == null) {
                    serv.stop();
                    return null;
                }
                serv.getSessionData().put("sessionID", id);
                ExtProcessor proc = handler.getProcessor("handshake");
                if (proc != null) {
                    ArrayDeque<Packet> results = new ArrayDeque<Packet>();
                    proc.startProcessing(null, serv, handler, results);
                    if (results != null) {
                        StringBuilder sb = new StringBuilder();
                        for (Packet p : results) {
                            sb.append(p.getElement().toString());
                        }
                        return sb.toString();
                    }
                } else {
                    log.warning("Required processor is not available: 'handshake'");
                }
                return null;
            }
            case accept: {
                String hostname = attribs.get("to");
                CompRepoItem repoItem = handler.getCompRepoItem(hostname);
                if (repoItem != null) {
                    serv.getSessionData().put("repo-item", repoItem);
                    serv.getSessionData().put("hostname-key", hostname);
                    log.finest("CompRepoItem for " + hostname + " set: " + repoItem.toString());
                    String id = UUID.randomUUID().toString();
                    serv.getSessionData().put("sessionID", id);
                    log.finest("ID generated and set: " + id);
                    return "<stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + ">";
                }
                return "<stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'>" + "<stream:error>" + "<host-unknown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error></stream:stream>";
            }
        }
        return null;
    }

    @Override
    public String[] getXMLNSs() {
        return this.xmlnss;
    }

    @Override
    public String serviceStarted(XMPPIOService<List<ComponentConnection>> serv) {
        switch (serv.connectionType()) {
            case connect: {
                CompRepoItem repoItem = (CompRepoItem)serv.getSessionData().get("repo-item");
                serv.getSessionData().put("hostname-key", repoItem.getRemoteHost());
                String data = "<stream:stream xmlns='jabber:component:accept' xmlns:stream='http://etherx.jabber.org/streams' to='" + repoItem.getDomain() + "'" + ">";
                return data;
            }
        }
        return null;
    }
}

