/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Message;
import tigase.server.Permissions;
import tigase.server.Presence;
import tigase.server.Priority;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class Packet {
    private static final String ERROR_NS = "urn:ietf:params:xml:ns:xmpp-stanzas";
    public static boolean FULL_DEBUG = Boolean.getBoolean("packet.debug.full");
    private JID packetFrom = null;
    private JID packetTo = null;
    private String packetToString = null;
    private String packetToStringSecure = null;
    private Set<String> processorsIds = new LinkedHashSet<String>(4, 0.9f);
    private JID stanzaFrom = null;
    private String stanzaId = null;
    private JID stanzaTo = null;
    private Priority priority = Priority.NORMAL;
    private Permissions permissions = Permissions.NONE;
    protected Element elem;
    private boolean routed;
    private StanzaType type;

    protected Packet(Element elem) throws TigaseStringprepException {
        this.setElem(elem);
        this.initVars();
    }

    protected Packet(Element elem, JID stanzaFrom, JID stanzaTo) {
        this.setElem(elem);
        this.initVars(stanzaFrom, stanzaTo);
    }

    public static Packet packetInstance(Element elem) throws TigaseStringprepException {
        if (elem.getName() == "message") {
            return new Message(elem);
        }
        if (elem.getName() == "presence") {
            return new Presence(elem);
        }
        if (elem.getName() == "iq") {
            return new Iq(elem);
        }
        return new Packet(elem);
    }

    public static Packet packetInstance(Element elem, JID stanzaFrom, JID stanzaTo) {
        if (elem.getName() == "message") {
            return new Message(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "presence") {
            return new Presence(elem, stanzaFrom, stanzaTo);
        }
        if (elem.getName() == "iq") {
            return new Iq(elem, stanzaFrom, stanzaTo);
        }
        return new Packet(elem, stanzaFrom, stanzaTo);
    }

    public static Packet packetInstance(String el_name, String from, String to, StanzaType type) throws TigaseStringprepException {
        Element elem = new Element(el_name, new String[]{"from", "to", "type"}, new String[]{from, to, type.toString()});
        return Packet.packetInstance(elem);
    }

    public Packet copyElementOnly() {
        Element res_elem = this.elem.clone();
        Packet result = Packet.packetInstance(res_elem, this.getStanzaFrom(), this.getStanzaTo());
        result.setPriority(this.priority);
        return result;
    }

    public String debug() {
        return this.toString() + ", stanzaFrom=" + this.stanzaFrom + ", stanzaTo=" + this.stanzaTo;
    }

    public Packet errorResult(String errorType, Integer errorCode, String errorCondition, String errorText, boolean includeOriginalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.error.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute("id", this.getStanzaId());
        }
        if (includeOriginalXML) {
            reply.addChildren(this.elem.getChildren());
        }
        if (this.getAttribute("xmlns") != null) {
            reply.setAttribute("xmlns", this.getAttribute("xmlns"));
        }
        Element error = new Element("error");
        if (errorCode != null) {
            error.setAttribute("code", errorCode.toString());
        }
        error.setAttribute("type", errorType);
        Element cond = new Element(errorCondition);
        cond.setXMLNS(ERROR_NS);
        error.addChild((XMLNodeIfc)cond);
        if (errorText != null) {
            Element t = new Element("text", errorText, new String[]{"xml:lang", "xmlns"}, new String[]{"en", ERROR_NS});
            error.addChild((XMLNodeIfc)t);
        }
        reply.addChild((XMLNodeIfc)error);
        return this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
    }

    public String getAttribute(String key) {
        return this.elem.getAttribute(key);
    }

    public String getAttribute(String path, String key) {
        return this.elem.getAttribute(path, key);
    }

    public Command getCommand() {
        return null;
    }

    public String getElemCData(String xmlPath) {
        return this.elem.getCData(xmlPath);
    }

    public String getElemCData() {
        return this.elem.getCData();
    }

    public List<Element> getElemChildren(String xmlPath) {
        return this.elem.getChildren(xmlPath);
    }

    @Deprecated
    public String getElemFrom() {
        return this.stanzaFrom != null ? this.stanzaFrom.toString() : null;
    }

    public String getElemName() {
        return this.elem.getName();
    }

    @Deprecated
    public String getElemTo() {
        return this.stanzaTo != null ? this.stanzaTo.toString() : null;
    }

    public Element getElement() {
        return this.elem;
    }

    public String getErrorCondition() {
        List children = this.elem.getChildren(this.elem.getName() + "/error");
        if (children != null) {
            for (Element cond : children) {
                if (cond.getName().equals("text")) continue;
                return cond.getName();
            }
        }
        return null;
    }

    public JID getFrom() {
        return this.packetFrom != null ? this.packetFrom : this.stanzaFrom;
    }

    public JID getPacketFrom() {
        return this.packetFrom;
    }

    public JID getPacketTo() {
        return this.packetTo;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Set<String> getProcessorsIds() {
        return this.processorsIds;
    }

    public JID getStanzaFrom() {
        return this.stanzaFrom;
    }

    public String getStanzaId() {
        return this.stanzaId;
    }

    public JID getStanzaTo() {
        return this.stanzaTo;
    }

    public JID getTo() {
        return this.packetTo != null ? this.packetTo : this.stanzaTo;
    }

    public StanzaType getType() {
        return this.type;
    }

    public String getXMLNS() {
        return this.elem.getXMLNS();
    }

    public void initVars(JID stanzaFrom, JID stanzaTo) {
        if (this.stanzaFrom != stanzaFrom) {
            this.stanzaFrom = stanzaFrom;
            if (stanzaFrom == null) {
                this.elem.removeAttribute("from");
            } else {
                this.elem.setAttribute("from", stanzaFrom.toString());
            }
        }
        if (this.stanzaTo != stanzaTo) {
            this.stanzaTo = stanzaTo;
            if (stanzaTo == null) {
                this.elem.removeAttribute("to");
            } else {
                this.elem.setAttribute("to", stanzaTo.toString());
            }
        }
        this.stanzaId = this.elem.getAttribute("id");
        this.packetToString = null;
    }

    public void initVars() throws TigaseStringprepException {
        String tmp = this.elem.getAttribute("to");
        if (tmp != null) {
            this.stanzaTo = JID.jidInstance((String)tmp);
        }
        if ((tmp = this.elem.getAttribute("from")) != null) {
            this.stanzaFrom = JID.jidInstance((String)tmp);
        }
        this.stanzaId = this.elem.getAttribute("id");
        this.packetToString = null;
    }

    public boolean isCommand() {
        return false;
    }

    public boolean isElement(String name, String xmlns) {
        return this.elem.getName() == name && xmlns == this.elem.getXMLNS();
    }

    public boolean isRouted() {
        return this.routed;
    }

    public boolean isServiceDisco() {
        return false;
    }

    public boolean isXMLNS(String elementPath, String xmlns) {
        String this_xmlns = this.elem.getXMLNS(elementPath);
        return this_xmlns == xmlns;
    }

    public Packet okResult(String includeXML, int originalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute("id", this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML; ++i) {
            old_child = (Element)old_child.getChildren().get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setXMLNS(old_child.getXMLNS());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.setCData(includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet okResult(Element includeXML, int originalXML) {
        Element reply = new Element(this.elem.getName());
        reply.setAttribute("type", StanzaType.result.toString());
        if (this.getStanzaId() != null) {
            reply.setAttribute("id", this.getStanzaId());
        }
        Element old_child = this.elem;
        Element new_child = reply;
        for (int i = 0; i < originalXML; ++i) {
            old_child = (Element)old_child.getChildren().get(0);
            Element tmp = new Element(old_child.getName());
            tmp.setXMLNS(old_child.getXMLNS());
            new_child.addChild((XMLNodeIfc)tmp);
            new_child = tmp;
        }
        if (includeXML != null) {
            new_child.addChild((XMLNodeIfc)includeXML);
        }
        Packet result = this.swapFromTo(reply, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet packRouted() {
        Element routedp = new Element("route", new String[]{"to", "from"}, new String[]{this.getTo().toString(), this.getFrom().toString()});
        routedp.addChild((XMLNodeIfc)this.elem);
        return Packet.packetInstance(routedp, this.getFrom(), this.getTo());
    }

    public void processedBy(String id) {
        this.processorsIds.add(id);
    }

    public void setPacketFrom(JID from) {
        this.packetFrom = from;
    }

    public void setPacketTo(JID to) {
        this.packetTo = to;
    }

    public void setPermissions(Permissions perm) {
        this.packetToString = null;
        this.packetToStringSecure = null;
        this.permissions = perm;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    @Deprecated
    public Packet swapElemFromTo() {
        return this.swapStanzaFromTo();
    }

    @Deprecated
    public Packet swapElemFromTo(StanzaType type) {
        return this.swapStanzaFromTo(type);
    }

    public Packet swapFromTo(Element el, JID stanzaFrom, JID stanzaTo) {
        Packet packet = Packet.packetInstance(el, stanzaFrom, stanzaTo);
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapFromTo() {
        Element el = this.elem.clone();
        Packet packet = Packet.packetInstance(el, this.getStanzaFrom(), this.getStanzaTo());
        packet.setPacketTo(this.getFrom());
        packet.setPacketFrom(this.getTo());
        packet.setPriority(this.priority);
        return packet;
    }

    public Packet swapStanzaFromTo() {
        Element copy = this.elem.clone();
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public Packet swapStanzaFromTo(StanzaType type) {
        Element copy = this.elem.clone();
        copy.setAttribute("type", type.toString());
        Packet result = Packet.packetInstance(copy, this.getStanzaTo(), this.getStanzaFrom());
        result.setPriority(this.priority);
        return result;
    }

    public String toString() {
        if (this.packetToString == null) {
            this.packetToString = ", data=" + this.elem.toString() + ", XMLNS=" + this.elem.getXMLNS() + ", priority=" + (Object)((Object)this.priority);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + this.packetToString;
    }

    public String toString(boolean secure) {
        String result = secure ? this.toStringSecure() : this.toString();
        return result;
    }

    public String toStringSecure() {
        if (FULL_DEBUG) {
            return this.toString();
        }
        if (this.packetToStringSecure == null) {
            this.packetToStringSecure = ", data=" + this.elem.toStringSecure() + ", XMLNS=" + this.elem.getXMLNS() + ", priority=" + (Object)((Object)this.priority);
        }
        return "from=" + this.packetFrom + ", to=" + this.packetTo + this.packetToStringSecure;
    }

    public Packet unpackRouted() throws TigaseStringprepException {
        Packet result = Packet.packetInstance((Element)this.elem.getChildren().get(0));
        result.setPacketTo(this.getTo());
        result.setPacketFrom(this.getFrom());
        return result;
    }

    public boolean wasProcessed() {
        return this.processorsIds.size() > 0;
    }

    public boolean wasProcessedBy(String id) {
        return this.processorsIds.contains(id);
    }

    private void setElem(Element elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        this.elem = elem;
        this.type = elem.getAttribute("type") != null ? StanzaType.valueof(elem.getAttribute("type")) : null;
        if (elem.getName() == "cluster") {
            this.setPriority(Priority.CLUSTER);
        } else if (elem.getName() == "presence" && (this.type == null || this.type == StanzaType.available || this.type == StanzaType.unavailable || this.type == StanzaType.probe)) {
            this.setPriority(Priority.PRESENCE);
        } else {
            this.routed = elem.getName() == "route";
        }
    }
}

