/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.ClusteredComponent;
import tigase.conf.Configurable;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.util.DNSResolver;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ClusterController
extends AbstractComponentRegistrator<ClusteredComponent>
implements Configurable {
    private static final Logger log = Logger.getLogger("tigase.cluster.ClusterController");
    public static final String MY_DOMAIN_NAME_PROP_KEY = "domain-name";
    public static final String MY_DOMAIN_NAME_PROP_VAL = "localhost";
    private JID my_address = null;
    private JID my_hostname = null;
    private Level statsLevel = Level.INFO;
    private String this_node = DNSResolver.getDefaultHostname();

    @Override
    public void componentAdded(ClusteredComponent component) {
        component.setClusterController(this);
        this.updateServiceDiscoveryItem(this.getName(), component.getName(), "Component: " + component.getName(), true);
    }

    @Override
    public void componentRemoved(ClusteredComponent component) {
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String[] local_domains = DNSResolver.getDefHostNames();
        if (params.get("--virt-hosts") != null) {
            local_domains = ((String)params.get("--virt-hosts")).split(",");
        }
        defs.put(MY_DOMAIN_NAME_PROP_KEY, local_domains[0]);
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return "load";
    }

    @Override
    public String getDiscoDescription() {
        return "Server clustering";
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof ClusteredComponent;
    }

    public void nodeConnected(String node) {
        for (ClusteredComponent comp : this.components.values()) {
            comp.nodeConnected(node);
        }
    }

    public void nodeDisconnected(String node) {
        for (ClusteredComponent comp : this.components.values()) {
            comp.nodeDisconnected(node);
        }
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.my_hostname = JID.jidInstanceNS((String)((String)properties.get(MY_DOMAIN_NAME_PROP_KEY)));
        this.my_address = JID.jidInstanceNS((String)this.getName(), (String)((String)properties.get(MY_DOMAIN_NAME_PROP_KEY)), null);
    }

    private Packet sendClusterNotification(String msg, String subject, String nodes) {
        String message = msg;
        if (nodes != null) {
            message = msg + "\n";
        }
        int cnt = 0;
        for (String node : nodes.split(",")) {
            message = message + "" + ++cnt + ". " + node + " connected to " + this.this_node;
        }
        Packet p_msg = Message.getMessage(this.my_address, this.my_hostname, StanzaType.normal, message, subject, "xyz", this.newPacketId(null));
        return p_msg;
    }
}

