/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl.roster;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.roster.Roster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;

public class RosterFlat
extends RosterAbstract {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.roster.RosterFlat");
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static int maxRosterSize = new Long(Runtime.getRuntime().maxMemory() / 250000L).intValue();

    public static boolean parseRoster(String roster_str, Map<BareJID, RosterElement> roster, XMPPResourceConnection session) {
        boolean result = false;
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, roster_str.toCharArray(), 0, roster_str.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            for (Element elem : elems) {
                try {
                    RosterElement relem = new RosterElement(elem, session);
                    result |= relem.isModified();
                    if (RosterFlat.addBuddy(relem, roster)) continue;
                    break;
                }
                catch (Exception e) {
                    log.warning("Can't load roster element: " + elem.toString());
                }
            }
        }
        return result;
    }

    private static boolean addBuddy(RosterElement relem, Map<BareJID, RosterElement> roster) {
        if (roster.size() < maxRosterSize) {
            roster.put(relem.getJid().getBareJID(), relem);
            return true;
        }
        return false;
    }

    @Override
    public void addBuddy(XMPPResourceConnection session, JID buddy, String name, String[] groups, String otherData) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            Map<BareJID, RosterElement> roster = this.getUserRoster(session);
            relem = new RosterElement(buddy, name, groups, session);
            relem.setOtherData(otherData);
            if (!RosterFlat.addBuddy(relem, roster)) {
                throw new TigaseDBException("Too many elements in the user roster.");
            }
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Added buddy to roster: " + buddy);
            }
        } else {
            if (name != null && !name.isEmpty()) {
                relem.setName(name);
            }
            if (groups != null && groups.length > 0) {
                relem.setGroups(groups);
            }
            this.saveUserRoster(session);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updated buddy in roster: " + buddy);
            }
        }
    }

    @Override
    public boolean addBuddyGroup(XMPPResourceConnection session, JID buddy, String[] groups) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.addGroups(groups);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBuddy(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        return this.getRosterElement(session, buddy) != null;
    }

    @Override
    public JID[] getBuddies(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        JID[] result = new JID[roster.size()];
        int idx = 0;
        for (RosterElement rosterElement : roster.values()) {
            result[idx++] = rosterElement.getJid();
        }
        return result;
    }

    @Override
    public String[] getBuddyGroups(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getGroups();
    }

    public Element getBuddyItem(RosterElement relem) {
        return relem.getRosterItem();
    }

    @Override
    public String getBuddyName(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getName();
    }

    @Override
    public RosterAbstract.SubscriptionType getBuddySubscription(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem == null) {
            return null;
        }
        return relem.getSubscription();
    }

    @Override
    public List<Element> getRosterItems(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        LinkedList<Element> items = new LinkedList<Element>();
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        for (RosterElement relem : roster.values()) {
            items.add(this.getBuddyItem(relem));
        }
        return items;
    }

    @Override
    public boolean removeBuddy(XMPPResourceConnection session, JID jid) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        roster.remove(jid.getBareJID());
        this.saveUserRoster(session);
        return true;
    }

    @Override
    public void setBuddyName(XMPPResourceConnection session, JID buddy, String name) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting name: '" + name + "' for buddy: " + buddy);
            }
            if (name != null && !name.isEmpty()) {
                relem.setName(name);
            }
            this.saveUserRoster(session);
        } else {
            log.warning("Setting buddy name for non-existen contact: " + buddy);
        }
    }

    @Override
    public void setBuddySubscription(XMPPResourceConnection session, RosterAbstract.SubscriptionType subscription, JID buddy) throws NotAuthorizedException, TigaseDBException {
        RosterElement relem = this.getRosterElement(session, buddy);
        if (relem != null) {
            relem.setSubscription(subscription);
            this.saveUserRoster(session);
        } else {
            log.warning("Missing roster contact for subscription set: " + buddy);
        }
    }

    protected RosterElement getRosterElement(XMPPResourceConnection session, JID buddy) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        return roster.get(buddy.getBareJID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<BareJID, RosterElement> getUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = null;
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            roster = (Map<BareJID, RosterElement>)session.getCommonSessionData("roster");
            if (roster == null) {
                roster = this.loadUserRoster(session);
            }
        }
        return roster;
    }

    private Map<BareJID, RosterElement> loadUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        ConcurrentHashMap<BareJID, RosterElement> roster = new ConcurrentHashMap<BareJID, RosterElement>(100, 0.25f, 1);
        session.putCommonSessionData("roster", roster);
        String roster_str = session.getData(null, "roster", null);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Loaded user roster: " + roster_str);
        }
        if (roster_str != null && !roster_str.isEmpty()) {
            this.updateRosterHash(roster_str, session);
            boolean modified = RosterFlat.parseRoster(roster_str, roster, session);
            if (modified) {
                this.saveUserRoster(session);
            }
        } else {
            Roster oldRoster = new Roster();
            JID[] buddies = oldRoster.getBuddies(session);
            if (buddies != null && buddies.length > 0) {
                for (JID buddy : buddies) {
                    String name = oldRoster.getBuddyName(session, buddy);
                    RosterAbstract.SubscriptionType subscr = oldRoster.getBuddySubscription(session, buddy);
                    String[] groups = oldRoster.getBuddyGroups(session, buddy);
                    RosterElement relem = new RosterElement(buddy, name, groups, session);
                    relem.setSubscription(subscr);
                    if (!RosterFlat.addBuddy(relem, roster)) break;
                }
                this.saveUserRoster(session);
            }
        }
        return roster;
    }

    private void saveUserRoster(XMPPResourceConnection session) throws NotAuthorizedException, TigaseDBException {
        Map<BareJID, RosterElement> roster = this.getUserRoster(session);
        StringBuilder sb = new StringBuilder();
        for (RosterElement relem : roster.values()) {
            sb.append(relem.getRosterElement().toString());
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Saving user roster: " + sb.toString());
        }
        session.setData(null, "roster", sb.toString());
    }
}

