/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class SaslAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String XMLNS = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.SaslAuth");
    private static final String ID = "urn:ietf:params:xml:ns:xmpp-sasl";
    private static final String[] ELEMENTS = new String[]{"auth", "response", "challenge", "failure", "success", "abort"};
    private static final String[] XMLNSS = new String[]{"urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl", "urn:ietf:params:xml:ns:xmpp-sasl"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return "urn:ietf:params:xml:ns:xmpp-sasl";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int concurrentThreadsPerQueue() {
        return 2;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("protocol", "sasl");
        session.queryAuth(query);
        String[] auth_mechs = (String[])query.get("result");
        Element[] mechs = new Element[auth_mechs.length];
        int idx = 0;
        for (String mech : auth_mechs) {
            mechs[idx++] = new Element("mechanism", mech);
        }
        return new Element[]{new Element("mechanisms", mechs, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-sasl"})};
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (session == null) {
            return;
        }
        Element request = packet.getElement();
        HashMap<String, Object> authProps = (HashMap<String, Object>)session.getSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
        if (authProps == null) {
            authProps = new HashMap<String, Object>();
            authProps.put("protocol", "sasl");
            authProps.put("mechanism", request.getAttribute("/auth", "mechanism"));
            authProps.put("realm", session.getDomain());
            authProps.put("server-name", session.getDomain());
            session.putSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps", authProps);
        }
        authProps.put("data", request.getCData());
        try {
            Authorization result = session.loginOther(authProps);
            String challenge_data = (String)authProps.get("result");
            if (result == Authorization.AUTHORIZED) {
                results.offer(packet.swapFromTo(this.createReply(ElementType.success, challenge_data), null, null));
                authProps.clear();
                session.removeSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
            } else {
                results.offer(packet.swapFromTo(this.createReply(ElementType.challenge, challenge_data), null, null));
            }
        }
        catch (Exception e) {
            session.removeSessionData("urn:ietf:params:xml:ns:xmpp-sasl-authProps");
            results.offer(packet.swapFromTo(this.createReply(ElementType.failure, "<not-authorized/>"), null, null));
            Integer retries = (Integer)session.getSessionData("auth-retries");
            if (retries == null) {
                retries = new Integer(0);
            }
            if (retries < 3) {
                session.putSessionData("auth-retries", new Integer(retries + 1));
            }
            results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, packet.getStanzaId()));
        }
    }

    private Element createReply(ElementType type, String cdata) {
        Element reply = new Element(type.toString());
        reply.setXMLNS("urn:ietf:params:xml:ns:xmpp-sasl");
        if (cdata != null) {
            reply.setCData(cdata);
        }
        return reply;
    }

    public static enum ElementType {
        auth,
        abort,
        response,
        challenge,
        failure,
        success;

    }
}

