/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPostprocessorIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class OfflineMessages
extends XMPPProcessor
implements XMPPPostprocessorIfc,
XMPPProcessorIfc {
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.OfflineMessage");
    private static final String ID = "msgoffline";
    private static final String XMLNS = "jabber:client";
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"msgoffline"})};
    private SimpleParser parser = SingletonFactory.getParserInstance();
    private final SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int concurrentThreadsPerQueue() {
        return 2;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
        if (conn == null || conn.isAnonymous()) {
            return;
        }
        if (conn.getSessionData(ID) != null) {
            return;
        }
        StanzaType type = packet.getType();
        if (type == null || type == StanzaType.available) {
            String priority_str = packet.getElemCData("/presence/priority");
            int priority = 0;
            if (priority_str != null) {
                try {
                    priority = Integer.decode(priority_str);
                }
                catch (NumberFormatException e) {
                    priority = 0;
                }
            }
            if (priority >= 0) {
                conn.putSessionData(ID, ID);
                try {
                    Queue<Packet> packets = this.restorePacketForOffLineUser(conn);
                    if (packets != null) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("Sending off-line messages: " + packets.size());
                        }
                        results.addAll(packets);
                    }
                }
                catch (NotAuthorizedException e) {
                    log.info("User not authrized to retrieve offline messages, this happens quite often on some installations where there are a very short living client connections. They can disconnect at any time. " + e);
                }
                catch (TigaseDBException e) {
                    log.warning("Error accessing database for offline message: " + e);
                }
            }
        }
    }

    @Override
    public void postProcess(Packet packet, XMPPResourceConnection conn, NonAuthUserRepository repo, Queue<Packet> queue) {
        block4: {
            if (conn == null) {
                try {
                    if (this.savePacketForOffLineUser(packet, repo)) {
                        packet.processedBy(ID);
                    }
                }
                catch (UserNotFoundException e) {
                    if (!log.isLoggable(Level.FINEST)) break block4;
                    log.finest("UserNotFoundException at trying to save packet for off-line user." + packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePacketForOffLineUser(Packet pac, NonAuthUserRepository repo) throws UserNotFoundException {
        StanzaType type = pac.getType();
        if (pac.getElemName().equals("message") && pac.getElement().findChild("/message/body") != null && (type == null || type == StanzaType.normal || type == StanzaType.chat) || pac.getElemName().equals("presence") && (type == StanzaType.subscribe || type == StanzaType.subscribed || type == StanzaType.unsubscribe || type == StanzaType.unsubscribed)) {
            Element packet = pac.getElement().clone();
            String stamp = null;
            SimpleDateFormat simpleDateFormat = this.formater;
            synchronized (simpleDateFormat) {
                stamp = this.formater.format(new Date());
            }
            String from = pac.getStanzaTo().getDomain();
            Element x = new Element("delay", "Offline Storage", new String[]{"from", "stamp", "xmlns"}, new String[]{from, stamp, "urn:xmpp:delay"});
            packet.addChild((XMLNodeIfc)x);
            String user_id = pac.getStanzaTo().getBareJID().toString();
            repo.addOfflineDataList(user_id, ID, "messages", new String[]{packet.toString()});
            return true;
        }
        return false;
    }

    public Queue<Packet> restorePacketForOffLineUser(XMPPResourceConnection conn) throws NotAuthorizedException, TigaseDBException {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        Object[] msgs = conn.getOfflineDataList(ID, "messages");
        if (msgs != null && msgs.length > 0) {
            conn.removeOfflineData(ID, "messages");
            LinkedList<Packet> pacs = new LinkedList<Packet>();
            StringBuilder sb = new StringBuilder();
            for (String string : msgs) {
                sb.append(string);
            }
            char[] data = sb.toString().toCharArray();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue elems = domHandler.getParsedElements();
            Element elem = null;
            while ((elem = (Element)elems.poll()) != null) {
                try {
                    pacs.offer(Packet.packetInstance(elem));
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    log.warning("Packet addressing problem, stringprep failed: " + elem);
                }
            }
            try {
                Collections.sort(pacs, new StampComparator());
            }
            catch (NullPointerException nullPointerException) {
                try {
                    log.warning("Can not sort off line messages, user=" + conn.getJID() + ",\n" + Arrays.toString(msgs) + ",\n" + nullPointerException);
                }
                catch (Exception exc) {
                    log.log(Level.WARNING, "Can not print log message.", exc);
                }
            }
            return pacs;
        }
        return null;
    }

    private class StampComparator
    implements Comparator<Packet> {
        private StampComparator() {
        }

        @Override
        public int compare(Packet p1, Packet p2) {
            String stamp1 = "";
            String stamp2 = "";
            Element stamp_el1 = p1.getElement().getChild("delay", "urn:xmpp:delay");
            if (stamp_el1 == null) {
                stamp_el1 = p1.getElement().getChild("x", "jabber:x:delay");
            }
            stamp1 = stamp_el1.getAttribute("stamp");
            Element stamp_el2 = p2.getElement().getChild("delay", "urn:xmpp:delay");
            if (stamp_el2 == null) {
                stamp_el2 = p2.getElement().getChild("x", "jabber:x:delay");
            }
            stamp2 = stamp_el2.getAttribute("stamp");
            return stamp1.compareTo(stamp2);
        }
    }
}

