/*
 * Decompiled with CFR 0.152.
 */
package tigase.vhosts;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.ComponentRepository;
import tigase.db.TigaseDBException;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.vhosts.VHostItem;
import tigase.vhosts.VHostListener;
import tigase.vhosts.VHostManagerIfc;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class VHostManager
extends AbstractComponentRegistrator<VHostListener>
implements VHostManagerIfc,
StatisticsContainer {
    public static final String VHOSTS_REPO_CLASS_PROPERTY = "--vhost-repo-class";
    public static final String VHOSTS_REPO_CLASS_PROP_KEY = "repository-class";
    public static final String VHOSTS_REPO_CLASS_PROP_VAL = "tigase.vhosts.VHostJDBCRepository";
    private static final Logger log = Logger.getLogger(VHostManager.class.getName());
    private long getComponentsForLocalDomainCalls = 0L;
    private long getComponentsForNonLocalDomainCalls = 0L;
    private long isAnonymousEnabledCalls = 0L;
    private long isLocalDomainCalls = 0L;
    private LinkedHashSet<VHostListener> localDomainsHandlers = new LinkedHashSet();
    private LinkedHashSet<VHostListener> nonLocalDomainsHandlers = new LinkedHashSet();
    private LinkedHashSet<VHostListener> nameSubdomainsHandlers = new LinkedHashSet();
    private ConcurrentSkipListSet<String> registeredComponentDomains = new ConcurrentSkipListSet();
    private ComponentRepository<VHostItem> repo = null;
    private ServiceEntity serviceEntity = null;

    @Override
    public void addComponentDomain(String domain) {
        this.registeredComponentDomains.add(domain);
    }

    @Override
    public void componentAdded(VHostListener component) {
        component.setVHostManager(this);
        if (component.handlesLocalDomains()) {
            this.localDomainsHandlers.add(component);
        }
        if (component.handlesNonLocalDomains()) {
            this.nonLocalDomainsHandlers.add(component);
        }
        if (component.handlesNameSubdomains()) {
            this.nameSubdomainsHandlers.add(component);
        }
    }

    @Override
    public void componentRemoved(VHostListener component) {
        this.localDomainsHandlers.remove(component);
        this.nonLocalDomainsHandlers.remove(component);
        this.nameSubdomainsHandlers.remove(component);
    }

    @Override
    public ServerComponent[] getComponentsForLocalDomain(String domain) {
        ++this.getComponentsForLocalDomainCalls;
        VHostItem vhost = this.repo.getItem(domain);
        if (vhost == null) {
            int idx = domain.indexOf(46);
            if (idx > 0) {
                String name = domain.substring(0, idx);
                String basedomain = domain.substring(idx + 1);
                VHostListener listener = (VHostListener)this.components.get(name);
                if (listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain)) {
                    return new ServerComponent[]{listener};
                }
            }
            return null;
        }
        LinkedHashSet<VHostListener> results = new LinkedHashSet<VHostListener>();
        results.addAll(this.localDomainsHandlers);
        if (results.size() > 0) {
            return results.toArray(new ServerComponent[results.size()]);
        }
        return null;
    }

    @Override
    public ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        ++this.getComponentsForNonLocalDomainCalls;
        if (this.nonLocalDomainsHandlers.size() > 0) {
            return this.nonLocalDomainsHandlers.toArray(new ServerComponent[this.nonLocalDomainsHandlers.size()]);
        }
        return null;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String repo_class = (String)params.get(VHOSTS_REPO_CLASS_PROPERTY);
        if (repo_class == null) {
            repo_class = VHOSTS_REPO_CLASS_PROP_VAL;
        }
        defs.put(VHOSTS_REPO_CLASS_PROP_KEY, repo_class);
        try {
            ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repo_class).newInstance();
            repo_tmp.getDefaults(defs, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate VHosts repository for class: " + repo_class, e);
        }
        return defs;
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart()) && this.isAdmin(from)) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.isAdmin(from)) {
            if (this.getName().equals(jid.getLocalpart()) || this.getComponentId().equals((Object)jid)) {
                List<Element> items = this.serviceEntity.getDiscoItems(node, jid.toString());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing discoItems for node: " + node + ", result: " + (items == null ? null : items.toString()));
                }
                return items;
            }
            if (node == null) {
                Element item = this.serviceEntity.getDiscoItem(null, BareJID.toString((String)this.getName(), (String)jid.toString()));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing discoItems, result: " + (item == null ? null : item.toString()));
                }
                return Arrays.asList(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Number of VHosts", this.repo.size(), Level.FINE);
        list.add(this.getName(), "Checks: is local domain", this.isLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Checks: is anonymous domain", this.isAnonymousEnabledCalls, Level.FINER);
        list.add(this.getName(), "Get components for local domain", this.getComponentsForLocalDomainCalls, Level.FINER);
        list.add(this.getName(), "Get components for non-local domain", this.getComponentsForNonLocalDomainCalls, Level.FINER);
    }

    @Override
    public VHostItem getVHostItem(String domain) {
        return this.repo.getItem(domain);
    }

    @Override
    public boolean isAnonymousEnabled(String domain) {
        ++this.isAnonymousEnabledCalls;
        VHostItem vhost = this.repo.getItem(domain);
        if (vhost == null) {
            return false;
        }
        return vhost.isAnonymousEnabled();
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof VHostListener;
    }

    @Override
    public boolean isLocalDomain(String domain) {
        ++this.isLocalDomainCalls;
        return this.repo.contains(domain);
    }

    @Override
    public boolean isLocalDomainOrComponent(String domain) {
        int idx;
        boolean result = this.isLocalDomain(domain);
        if (!result) {
            result = this.registeredComponentDomains.contains(domain);
        }
        if (!result && (idx = domain.indexOf(46)) > 0) {
            String name = domain.substring(0, idx);
            String basedomain = domain.substring(idx + 1);
            VHostListener listener = (VHostListener)this.components.get(name);
            result = listener != null && listener.handlesNameSubdomains() && this.isLocalDomain(basedomain);
        }
        return result;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (!packet.isCommand() || packet.getType() != null && packet.getType() == StanzaType.result) {
            return;
        }
        if (packet.getPermissions() != Permissions.ADMIN) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        Iq iqc = (Iq)packet;
        Command.Action action = Command.getAction(iqc);
        if (action == Command.Action.cancel) {
            Packet result = iqc.commandResult(null);
            results.offer(result);
            return;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Processing command: " + iqc.toString());
        }
        Packet result = null;
        result = iqc.getCommand() == Command.VHOSTS_RELOAD || Command.getData(iqc) != null ? iqc.commandResult(Command.DataType.result) : iqc.commandResult(Command.DataType.form);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Preparing result: " + result.toString());
        }
        switch (iqc.getCommand()) {
            case VHOSTS_RELOAD: {
                try {
                    this.repo.reload();
                }
                catch (TigaseDBException ex) {
                    log.log(Level.WARNING, "Problem reloading VHost repository: ", ex);
                }
                this.addCompletedVHostsField(result);
                results.offer(result);
                break;
            }
            case VHOSTS_UPDATE: {
                if (Command.getData(packet) == null) {
                    this.prepareVHostData(result);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Sending result back: " + result.toString());
                    }
                    results.offer(result);
                    break;
                }
                this.updateVHostChanges(packet, result);
                results.offer(result);
                break;
            }
            case VHOSTS_REMOVE: {
                if (Command.getData(packet) == null) {
                    this.prepareVHostRemove(result);
                    results.offer(result);
                    break;
                }
                this.updateVHostRemove(packet, result);
                results.offer(result);
                break;
            }
        }
    }

    @Override
    public void removeComponentDomain(String domain) {
        this.registeredComponentDomains.remove(domain);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, null, "VHosts Manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "generic", "VHost Manager"), new ServiceIdentity("automation", "command-list", "VHosts management commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
        ServiceEntity item = new ServiceEntity(this.getName(), Command.VHOSTS_RELOAD.toString(), "Reload VHosts from repository");
        item.addFeatures(CMD_FEATURES);
        item.addIdentities(new ServiceIdentity("automation", "command-node", "Reload VHosts from repository"));
        this.serviceEntity.addItems(item);
        item = new ServiceEntity(this.getName(), Command.VHOSTS_UPDATE.toString(), "Add/Update selected VHost information");
        item.addFeatures(CMD_FEATURES);
        item.addIdentities(new ServiceIdentity("automation", "command-node", "Add/Update selected VHost information"));
        this.serviceEntity.addItems(item);
        item = new ServiceEntity(this.getName(), Command.VHOSTS_REMOVE.toString(), "Remove selected VHost");
        item.addFeatures(CMD_FEATURES);
        item.addIdentities(new ServiceIdentity("automation", "command-node", "Remove selected VHost"));
        this.serviceEntity.addItems(item);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        String repo_class = (String)properties.get(VHOSTS_REPO_CLASS_PROP_KEY);
        try {
            ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repo_class).newInstance();
            repo_tmp.setProperties(properties);
            this.repo = repo_tmp;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create VHost repository instance for class: " + repo_class, e);
        }
    }

    private void addCompletedVHostsField(Packet result) {
        Command.addFieldValue(result, "Note", "Current number of VHosts: " + this.repo.size(), "fixed");
    }

    private void prepareVHostData(Packet result) {
        Command.addFieldValue(result, "VHost", "");
        Command.addFieldValue(result, "Enabled", "true", "Enabled", new String[]{"true", "false"}, new String[]{"true", "false"});
    }

    private void prepareVHostRemove(Packet result) {
        Command.addFieldValue(result, "VHost", "");
    }

    private void updateVHostChanges(Packet packet, Packet result) {
        String vh = Command.getFieldValue(packet, "VHost");
        if (vh != null && !vh.isEmpty()) {
            VHostItem vhost = new VHostItem(vh);
            String enabled = Command.getFieldValue(packet, "Enabled");
            vhost.setEnabled(enabled == null || enabled.isEmpty() || "true".equals(enabled));
            try {
                this.repo.addItem(vhost);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Problem adding VHost item to repository: ", ex);
            }
            this.addCompletedVHostsField(result);
        } else {
            Command.addFieldValue(result, "Note", "Incorrect VHost name given", "fixed");
        }
    }

    private void updateVHostRemove(Packet packet, Packet result) {
        String vh = Command.getFieldValue(packet, "VHost");
        if (vh != null && !vh.isEmpty()) {
            try {
                this.repo.removeItem(vh);
            }
            catch (TigaseDBException ex) {
                log.log(Level.WARNING, "Problem removing VHost item from repository: ", ex);
            }
            this.addCompletedVHostsField(result);
        } else {
            Command.addFieldValue(result, "Note", "Incorrect VHost name given", "fixed");
        }
    }
}

