/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.PriorityQueueAbstract;
import tigase.util.QueueItem;
import tigase.util.WorkerThread;
import tigase.xmpp.XMPPResourceConnection;

public class ProcessingThreads<E extends WorkerThread> {
    private long droppedPackets = 0L;
    private int maxQueueSize = 10000;
    private String name = null;
    private int numQueues = 2;
    private int numWorkerThreads = 1;
    private ArrayDeque<E> workerThreads = new ArrayDeque();
    private ArrayList<PriorityQueueAbstract<QueueItem>> queues = new ArrayList();

    public ProcessingThreads(E worker, int numQueues, int numWorkerThreads, int maxQueueSize, String name) {
        this.numQueues = numQueues;
        this.maxQueueSize = maxQueueSize;
        this.numWorkerThreads = numWorkerThreads;
        this.name = name;
        for (int i = 0; i < numQueues; ++i) {
            PriorityQueueAbstract queue = PriorityQueueAbstract.getPriorityQueue(Priority.values().length, maxQueueSize);
            this.queues.add(queue);
            for (int j = 0; j < numWorkerThreads; ++j) {
                WorkerThread t = ((WorkerThread)worker).getNewInstance(this.queues.get(i));
                t.setDaemon(true);
                t.setName(name + " Queue " + i + " Worker " + j);
                t.start();
                this.workerThreads.add(t);
            }
        }
    }

    public boolean addItem(Packet packet, XMPPResourceConnection conn) {
        boolean ret = false;
        QueueItem item = new QueueItem();
        item.conn = conn;
        item.packet = packet;
        try {
            ret = item.conn != null && item.conn.isAuthorized() ? this.queues.get(Math.abs(conn.getJID().getBareJID().hashCode() % this.numQueues)).offer(item, packet.getPriority().ordinal()) : (packet.getStanzaTo() != null ? this.queues.get(Math.abs(packet.getStanzaTo().hashCode() % this.numQueues)).offer(item, packet.getPriority().ordinal()) : this.queues.get(Math.abs(packet.getTo().hashCode() % this.numQueues)).offer(item, packet.getPriority().ordinal()));
        }
        catch (Exception e) {
            ret = packet.getStanzaTo() != null ? this.queues.get(Math.abs(packet.getStanzaTo().hashCode() % this.numQueues)).offer(item, packet.getPriority().ordinal()) : this.queues.get(Math.abs(packet.getTo().hashCode() % this.numQueues)).offer(item, packet.getPriority().ordinal());
        }
        if (!ret) {
            ++this.droppedPackets;
        }
        return ret;
    }

    public long getAverageProcessingTime() {
        long average = 0L;
        int counters = 0;
        for (WorkerThread workerThread : this.workerThreads) {
            if (workerThread.getAverageProcessingTime() <= 0L) continue;
            average += workerThread.getAverageProcessingTime();
            ++counters;
        }
        if (counters > 0) {
            return average / (long)counters;
        }
        return 0L;
    }

    public long getDroppedPackets() {
        return this.droppedPackets;
    }

    public String getName() {
        return this.name;
    }

    public int getTotalQueueSize() {
        int ret = 0;
        for (PriorityQueueAbstract<QueueItem> pq : this.queues) {
            ret += pq.totalSize();
        }
        return ret;
    }

    public int getTotalRuns() {
        int ret = 0;
        for (WorkerThread workerThread : this.workerThreads) {
            ret = (int)((long)ret + workerThread.getRunsCounter());
        }
        return ret;
    }

    public E getWorkerThread() {
        try {
            return (E)((WorkerThread)this.workerThreads.getFirst());
        }
        catch (Exception e) {
            return null;
        }
    }
}

