/*
 * Decompiled with CFR 0.152.
 */
package tigase.util;

import tigase.util.NonpriorityQueue;
import tigase.util.PriorityQueue;

public abstract class PriorityQueueAbstract<E> {
    public static final String NONPRIORITY_QUEUE = "nonpriority-queue";

    public abstract boolean offer(E var1, int var2);

    public abstract void put(E var1, int var2) throws InterruptedException;

    public abstract void setMaxSize(int var1);

    public abstract int[] size();

    public abstract E take() throws InterruptedException;

    public abstract int totalSize();

    public static <E> PriorityQueueAbstract<E> getPriorityQueue(int maxPriority, int maxSize) {
        if (Boolean.getBoolean(NONPRIORITY_QUEUE)) {
            return new NonpriorityQueue(maxSize);
        }
        return new PriorityQueue(maxPriority, maxSize);
    }
}

