/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext.handlers;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Packet;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentConnection;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.util.Algorithms;
import tigase.xml.Element;
import tigase.xmpp.XMPPIOService;

public class HandshakeProcessor
implements ExtProcessor {
    private static final Logger log = Logger.getLogger(HandshakeProcessor.class.getName());
    private static final String EL_NAME = "handshake";
    private static final String ID = "handshake";

    @Override
    public boolean process(Packet p, XMPPIOService<List<ComponentConnection>> serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        boolean result = false;
        if (p.getElemName() == "handshake") {
            result = true;
            switch (serv.connectionType()) {
                case connect: {
                    String data = p.getElemCData();
                    if (data == null) {
                        handler.authenticated(serv);
                        break;
                    }
                    log.warning("Incorrect packet received: " + p);
                    serv.stop();
                    break;
                }
                case accept: {
                    String digest = p.getElemCData();
                    CompRepoItem comp = (CompRepoItem)serv.getSessionData().get("repo-item");
                    String id = (String)serv.getSessionData().get("sessionID");
                    String secret = comp.getAuthPasswd();
                    try {
                        String loc_digest = Algorithms.hexDigest((String)id, (String)secret, (String)"SHA");
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Calculating digest: id=" + id + ", secret=" + secret + ", digest=" + loc_digest);
                        }
                        if (digest != null && digest.equals(loc_digest)) {
                            handler.authenticated(serv);
                            Packet resp = Packet.packetInstance(new Element("handshake"), null, null);
                            results.offer(resp);
                            break;
                        }
                        log.info("Handshaking passwords don't match, disconnecting...");
                        serv.stop();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Handshaking error.", e);
                    }
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public List<Element> getStreamFeatures(XMPPIOService<List<ComponentConnection>> serv, ComponentProtocolHandler handler) {
        return null;
    }

    @Override
    public String getId() {
        return "handshake";
    }

    @Override
    public void startProcessing(Packet p, XMPPIOService<List<ComponentConnection>> serv, ComponentProtocolHandler handler, Queue<Packet> results) {
        String secret = ((CompRepoItem)serv.getSessionData().get("repo-item")).getAuthPasswd();
        try {
            String id = (String)serv.getSessionData().get("sessionID");
            String digest = Algorithms.hexDigest((String)id, (String)secret, (String)"SHA");
            Packet result = Packet.packetInstance(new Element("handshake", digest), null, null);
            results.offer(result);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, "Can not generate digest for pass phrase.", e);
            serv.stop();
        }
    }
}

