/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.db.ComponentRepository;
import tigase.net.ConnectionType;
import tigase.net.SocketType;
import tigase.server.ConnectionManager;
import tigase.server.Packet;
import tigase.server.ext.CompRepoItem;
import tigase.server.ext.ComponentConnection;
import tigase.server.ext.ComponentProtocolHandler;
import tigase.server.ext.ExtProcessor;
import tigase.server.ext.StreamOpenHandler;
import tigase.server.ext.handlers.BindProcessor;
import tigase.server.ext.handlers.ComponentAcceptStreamOpenHandler;
import tigase.server.ext.handlers.ComponentConnectStreamOpenHandler;
import tigase.server.ext.handlers.HandshakeProcessor;
import tigase.server.ext.handlers.JabberClientStreamOpenHandler;
import tigase.server.ext.handlers.SASLProcessor;
import tigase.server.ext.handlers.StartTLSProcessor;
import tigase.server.ext.handlers.StreamFeaturesProcessor;
import tigase.server.ext.handlers.UnknownXMLNSStreamOpenHandler;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.XMPPIOService;

public class ComponentProtocol
extends ConnectionManager<XMPPIOService<List<ComponentConnection>>>
implements ComponentProtocolHandler {
    private static final Logger log = Logger.getLogger(ComponentProtocol.class.getName());
    public static final String EXTCOMP_REPO_CLASS_PROPERTY = "--extcomp-repo-class";
    public static final String EXTCOMP_REPO_CLASS_PROP_KEY = "repository-class";
    public static final String EXTCOMP_REPO_CLASS_PROP_VAL = "tigase.server.ext.CompDBRepository";
    public static final String EXTCOMP_BIND_HOSTNAMES = "--bind-ext-hostnames";
    public static final String PACK_ROUTED_KEY = "pack-routed";
    public static final String RETURN_SERVICE_DISCO_KEY = "service-disco";
    public static final boolean RETURN_SERVICE_DISCO_VAL = true;
    public static final String IDENTITY_TYPE_KEY = "identity-type";
    public static final String IDENTITY_TYPE_VAL = "generic";
    public static final String CLOSE_ON_SEQUENCE_ERROR_PROP_KEY = "close-on-seq-error";
    public static final String MAX_AUTH_ATTEMPTS_PROP_KEY = "max-auth-attempts";
    public static final String AUTHENTICATION_TIMEOUT_PROP_KEY = "auth-timeout";
    public boolean PACK_ROUTED_VAL = false;
    private long authenticationTimeOut = 15L;
    private Map<String, ArrayList<ComponentConnection>> connections = new ConcurrentHashMap<String, ArrayList<ComponentConnection>>();
    private String[] hostnamesToBind = null;
    private int maxAuthenticationAttempts = 1;
    private ComponentRepository<CompRepoItem> repo = null;
    private Map<String, StreamOpenHandler> streamOpenHandlers = new LinkedHashMap<String, StreamOpenHandler>();
    private Map<String, ExtProcessor> processors = new LinkedHashMap<String, ExtProcessor>();
    private UnknownXMLNSStreamOpenHandler unknownXMLNSHandler = new UnknownXMLNSStreamOpenHandler();
    private String identity_type = "generic";
    private boolean closeOnSequenceError = true;

    public ComponentProtocol() {
        StreamOpenHandler handler = new JabberClientStreamOpenHandler();
        if (handler.getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
        if ((handler = new ComponentAcceptStreamOpenHandler()).getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
        if ((handler = new ComponentConnectStreamOpenHandler()).getXMLNSs() != null) {
            for (String xmlns : handler.getXMLNSs()) {
                this.streamOpenHandlers.put(xmlns, handler);
            }
        }
    }

    @Override
    public void authenticated(XMPPIOService<List<ComponentConnection>> serv) {
        serv.setAuthenticated(true);
        String hostname = (String)serv.getSessionData().get("hostname-key");
        this.bindHostname(hostname, serv);
        if (this.hostnamesToBind != null) {
            serv.getSessionData().put("bind-ext-hostnames", this.hostnamesToBind);
            ExtProcessor proc = this.getProcessor("bind");
            if (proc != null) {
                ArrayDeque<Packet> results = new ArrayDeque<Packet>();
                proc.startProcessing(null, serv, this, results);
                this.writePacketsToSocket(serv, results);
            }
        }
    }

    @Override
    public void authenticationFailed(XMPPIOService<List<ComponentConnection>> serv, Packet packet) {
        this.writePacketToSocket(serv, packet);
        Integer fails = (Integer)serv.getSessionData().get("auth-fails");
        fails = fails == null ? Integer.valueOf(1) : Integer.valueOf(fails + 1);
        if (fails >= this.maxAuthenticationAttempts) {
            serv.stop();
        }
    }

    @Override
    public void bindHostname(String hostname, XMPPIOService<List<ComponentConnection>> serv) {
        String[] routings = new String[]{hostname, ".*@" + hostname, ".*\\." + hostname};
        if (serv.connectionType() == ConnectionType.connect) {
            routings = new String[]{".*"};
        }
        this.updateRoutings(routings, true);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Authenticated: " + hostname);
        }
        this.updateServiceDiscoveryItem(hostname, null, "XEP-0114 connected", false);
        this.addComponentConnection(hostname, serv);
        this.addComponentDomain(hostname);
    }

    @Override
    public CompRepoItem getCompRepoItem(String hostname) {
        return this.repo.getItem(hostname);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String repo_class = (String)params.get(EXTCOMP_REPO_CLASS_PROPERTY);
        if (repo_class == null) {
            repo_class = EXTCOMP_REPO_CLASS_PROP_VAL;
        }
        defs.put(EXTCOMP_REPO_CLASS_PROP_KEY, repo_class);
        try {
            this.repo = (ComponentRepository)Class.forName(repo_class).newInstance();
            this.repo.getDefaults(defs, params);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not instantiate items repository for class: " + repo_class, e);
        }
        defs.put(PACK_ROUTED_KEY, this.PACK_ROUTED_VAL);
        defs.put(RETURN_SERVICE_DISCO_KEY, true);
        defs.put(IDENTITY_TYPE_KEY, IDENTITY_TYPE_VAL);
        String bind_hostnames = (String)params.get(EXTCOMP_BIND_HOSTNAMES);
        if (bind_hostnames != null) {
            defs.put("bind-ext-hostnames", bind_hostnames.split(","));
        } else {
            defs.put("bind-ext-hostnames", new String[]{""});
        }
        defs.put(CLOSE_ON_SEQUENCE_ERROR_PROP_KEY, this.closeOnSequenceError);
        defs.put(MAX_AUTH_ATTEMPTS_PROP_KEY, this.maxAuthenticationAttempts);
        defs.put(AUTHENTICATION_TIMEOUT_PROP_KEY, this.authenticationTimeOut);
        return defs;
    }

    @Override
    public String getDiscoCategoryType() {
        return this.identity_type;
    }

    @Override
    public String getDiscoDescription() {
        return "External component";
    }

    @Override
    public ExtProcessor getProcessor(String key) {
        return this.processors.get(key);
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Number of external domains", this.connections.size(), Level.FINE);
        int size = 0;
        for (ArrayList<ComponentConnection> conns : this.connections.values()) {
            size += conns.size();
        }
        list.add(this.getName(), "Number of external component connections", size, Level.FINER);
    }

    @Override
    public List<Element> getStreamFeatures(XMPPIOService<List<ComponentConnection>> serv) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (ExtProcessor proc : this.processors.values()) {
            List<Element> proc_res = proc.getStreamFeatures(serv, this);
            if (proc_res == null) continue;
            results.addAll(proc_res);
        }
        return results;
    }

    @Override
    public StreamOpenHandler getStreamOpenHandler(String xmlns) {
        return this.streamOpenHandlers.get(xmlns);
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getTo() != null) {
            return packet.getTo().hashCode();
        }
        return super.hashCodeForPacket(packet);
    }

    @Override
    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put("comp_repo", (Object)this.repo);
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<List<ComponentConnection>> serv) {
        Packet p = null;
        ArrayDeque<Packet> results = new ArrayDeque<Packet>();
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing socket data: " + p);
            }
            boolean processed = false;
            for (ExtProcessor proc : this.processors.values()) {
                processed |= proc.process(p, serv, this, results);
                this.writePacketsToSocket(serv, results);
            }
            if (processed) continue;
            if (serv.isAuthenticated()) {
                Packet result = p;
                if (p.isRouted()) {
                    try {
                        result = p.unpackRouted();
                    }
                    catch (TigaseStringprepException ex) {
                        log.warning("Packet stringprep addressing problem, dropping packet: " + p);
                        return null;
                    }
                }
                this.addOutPacket(result);
                continue;
            }
            try {
                Packet error = Authorization.NOT_AUTHORIZED.getResponseMessage(p, "Connection not yet authorized to send this packet.", true);
                this.writePacketToSocket(serv, error);
            }
            catch (PacketErrorTypeException ex) {
                log.fine("Received an error packet from unauthorized connection: " + p.toString());
            }
            if (!this.closeOnSequenceError) continue;
            serv.stop();
        }
        return null;
    }

    @Override
    public int processingThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void serviceStarted(XMPPIOService<List<ComponentConnection>> serv) {
        super.serviceStarted(serv);
        this.addTimerTask(new AuthenticationTimer(serv), this.authenticationTimeOut, TimeUnit.SECONDS);
        String xmlns = ((CompRepoItem)serv.getSessionData().get("repo-item")).getXMLNS();
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Connection started: " + serv.getRemoteAddress() + ", xmlns: " + xmlns + ", type: " + serv.connectionType().toString() + ", id=" + serv.getUniqueId());
        }
        StreamOpenHandler handler = this.streamOpenHandlers.get(xmlns);
        String result = null;
        if (handler == null) {
            log.fine("XMLNS not set, accepting a new connection with xmlns auto-detection.");
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("cid: " + (String)serv.getSessionData().get("cid") + ", sending: " + result);
            }
            result = handler.serviceStarted(serv);
        }
        if (result != null) {
            serv.xmppStreamOpen(result);
        }
    }

    @Override
    public boolean serviceStopped(XMPPIOService<List<ComponentConnection>> service) {
        boolean result = super.serviceStopped(service);
        if (result) {
            ConcurrentMap<String, Object> sessionData = service.getSessionData();
            String hostname = (String)sessionData.get("hostname-key");
            if (hostname != null && !hostname.isEmpty()) {
                List conns = (List)service.getRefObject();
                if (conns != null) {
                    for (ComponentConnection conn : conns) {
                        boolean moreConnections = this.removeComponentConnection(conn.getDomain(), conn);
                        if (moreConnections) continue;
                        this.removeRoutings(conn.getDomain());
                    }
                } else {
                    log.finer("Closing XMPPIOService has not yet set ComponentConnection as RefObject: " + hostname + ", id: " + service.getUniqueId());
                }
            } else {
                log.finer("Stopped service which hasn't sent initial stream open yet" + service.getUniqueId());
            }
            ConnectionType type = service.connectionType();
            if (type == ConnectionType.connect) {
                this.addWaitingTask(sessionData);
            }
        }
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.identity_type = (String)properties.get(IDENTITY_TYPE_KEY);
        super.setProperties(properties);
        String repo_class = (String)properties.get(EXTCOMP_REPO_CLASS_PROP_KEY);
        try {
            ComponentRepository repo_tmp = (ComponentRepository)Class.forName(repo_class).newInstance();
            repo_tmp.setProperties(properties);
            this.repo = repo_tmp;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Can not create items repository instance for class: " + repo_class, e);
        }
        for (CompRepoItem repoItem : this.repo) {
            log.info("Loaded repoItem: " + repoItem.toString());
            if (repoItem.getPort() <= 0) continue;
            LinkedHashMap<String, Object> port_props = new LinkedHashMap<String, Object>();
            port_props.put("port-no", repoItem.getPort());
            if (repoItem.getDomain() != null) {
                port_props.put("local-host", repoItem.getDomain());
            }
            String[] remote_host = this.PORT_IFC_PROP_VAL;
            if (repoItem.getRemoteHost() != null) {
                port_props.put("remote-host", repoItem.getRemoteHost());
                remote_host = new String[]{repoItem.getRemoteHost()};
            }
            port_props.put("type", (Object)repoItem.getConnectionType());
            port_props.put("socket", (Object)SocketType.plain);
            port_props.put("ifc", remote_host);
            port_props.put("max-reconnects", 0x6DDD00);
            port_props.put("repo-item", repoItem);
            log.info("Starting connection: " + port_props);
            this.addWaitingTask(port_props);
        }
        this.hostnamesToBind = (String[])properties.get("bind-ext-hostnames");
        if (this.hostnamesToBind.length == 1 && this.hostnamesToBind[0].isEmpty()) {
            this.hostnamesToBind = null;
        }
        log.config("Hostnames to bind: " + Arrays.toString(this.hostnamesToBind));
        this.processors = new LinkedHashMap<String, ExtProcessor>();
        ExtProcessor proc = new HandshakeProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new StreamFeaturesProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new StartTLSProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new SASLProcessor();
        this.processors.put(proc.getId(), proc);
        proc = new BindProcessor();
        this.processors.put(proc.getId(), proc);
    }

    @Override
    public void unbindHostname(String hostname, XMPPIOService<List<ComponentConnection>> serv) {
        ArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns != null) {
            boolean moreConnections;
            ComponentConnection conn = null;
            for (ComponentConnection componentConnection : conns) {
                if (componentConnection.getService() != serv) continue;
                conn = componentConnection;
            }
            if (conn != null && !(moreConnections = this.removeComponentConnection(conn.getDomain(), conn))) {
                this.removeRoutings(conn.getDomain());
            }
        }
    }

    @Override
    public boolean writePacketToSocket(XMPPIOService<List<ComponentConnection>> ios, Packet p) {
        p.getElement().removeAttribute("xmlns");
        return super.writePacketToSocket(ios, p);
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<List<ComponentConnection>> serv) {
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<List<ComponentConnection>> serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Stream opened: " + serv.getRemoteAddress() + ", xmlns: " + attribs.get("xmlns") + ", type: " + serv.connectionType().toString() + ", uniqueId=" + serv.getUniqueId() + ", to=" + attribs.get("to"));
        }
        String s_xmlns = attribs.get("xmlns");
        String result = null;
        StreamOpenHandler handler = this.streamOpenHandlers.get(s_xmlns);
        if (handler == null || s_xmlns == null) {
            log.finest("unknownXMLNSHandler is processing request");
            result = this.unknownXMLNSHandler.streamOpened(serv, attribs, this);
        } else {
            log.finest(handler.getClass().getName() + " is processing request");
            result = handler.streamOpened(serv, attribs, this);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending back: " + result);
        }
        return result;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected XMPPIOService<List<ComponentConnection>> getXMPPIOService(Packet p) {
        if (p.getStanzaTo() == null) {
            return null;
        }
        XMPPIOService<List<ComponentConnection>> result = null;
        String hostname = p.getStanzaTo().getDomain();
        ArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns != null) {
            for (ComponentConnection componentConnection : conns) {
                XMPPIOService<List<ComponentConnection>> serv = componentConnection.getService();
                if (serv != null) {
                    if (serv.isConnected()) {
                        result = serv;
                    } else {
                        log.info("Service is not connected for connection for hostname: " + hostname);
                    }
                } else {
                    log.info("Service is null for connection for hostname: " + hostname);
                }
                if (result == null) continue;
                break;
            }
        } else {
            log.info("No ext connection for hostname: " + hostname);
        }
        return result;
    }

    @Override
    protected XMPPIOService<List<ComponentConnection>> getXMPPIOServiceInstance() {
        return new XMPPIOService<List<ComponentConnection>>();
    }

    @Override
    protected boolean isHighThroughput() {
        return true;
    }

    private synchronized void addComponentConnection(String hostname, XMPPIOService<List<ComponentConnection>> s) {
        boolean result;
        ComponentConnection conn = new ComponentConnection(hostname, s);
        CopyOnWriteArrayList<ComponentConnection> refObject = (CopyOnWriteArrayList<ComponentConnection>)s.getRefObject();
        if (refObject == null) {
            refObject = new CopyOnWriteArrayList<ComponentConnection>();
            s.setRefObject(refObject);
        }
        refObject.add(conn);
        ArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns == null) {
            conns = new ArrayList();
            this.connections.put(hostname, conns);
        }
        if (result = conns.add(conn)) {
            log.finer("A new component connection added for: " + hostname);
        } else {
            log.fine("A new component connection NOT added for: " + hostname);
        }
    }

    private synchronized boolean removeComponentConnection(String hostname, ComponentConnection conn) {
        boolean result = false;
        ArrayList<ComponentConnection> conns = this.connections.get(hostname);
        if (conns != null) {
            boolean removed = conns.remove(conn);
            if (removed) {
                log.finer("A component connection removed for: " + hostname);
            } else {
                log.fine("A component connection NOT removed for: " + hostname);
            }
            for (ComponentConnection compCon : conns) {
                XMPPIOService<List<ComponentConnection>> serv = compCon.getService();
                if (serv != null && serv.isConnected()) {
                    result = true;
                    continue;
                }
                log.warning("Null or disconnected service for ComponentConnection for host: " + hostname);
            }
        } else {
            log.warning("That should not happen, ComponentConnection is not null but the collection is: " + hostname);
        }
        return result;
    }

    private void removeRoutings(String hostname) {
        String[] routings = new String[]{hostname, ".*@" + hostname, ".*\\." + hostname};
        this.updateRoutings(routings, false);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Disonnected from: " + hostname);
        }
        this.updateServiceDiscoveryItem(hostname, null, "XEP-0114 disconnected", false);
        this.removeComponentDomain(hostname);
    }

    private void updateRoutings(String[] routings, boolean add) {
        if (add) {
            for (String route : routings) {
                try {
                    this.addRegexRouting(route);
                }
                catch (Exception e) {
                    log.warning("Can not add regex routing '" + route + "' : " + e);
                }
            }
        } else {
            for (String route : routings) {
                try {
                    this.removeRegexRouting(route);
                    log.fine("Removed routings: " + route);
                }
                catch (Exception e) {
                    log.warning("Can not remove regex routing '" + route + "' : " + e);
                }
            }
        }
        log.finest("All regex routings: " + this.getRegexRoutings().toString());
    }

    private class AuthenticationTimer
    extends TimerTask {
        private XMPPIOService<List<ComponentConnection>> serv = null;

        private AuthenticationTimer(XMPPIOService<List<ComponentConnection>> serv) {
            this.serv = serv;
        }

        @Override
        public void run() {
            if (!this.serv.isAuthenticated()) {
                this.serv.stop();
            }
        }
    }
}

