/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.util.logging.Logger;
import tigase.db.RepositoryItem;
import tigase.net.ConnectionType;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;

public class CompRepoItem
implements RepositoryItem {
    private static final Logger log = Logger.getLogger(CompRepoItem.class.getName());
    public static final String REPO_ITEM_ELEM_NAME = "item";
    public static final String DOMAIN_ATTR = "domain";
    public static final String REMOTE_HOST_ATTR = "remote";
    public static final String CONN_TYPE_ATTR = "type";
    public static final String PORT_NO_ATTR = "port";
    public static final String PASSWORD_ATTR = "pass";
    public static final String PROTO_XMLNS_ATTR = "proto-xmlns";
    public static final String ROUTINGS_ATTR = "routings";
    public static final String DOMAIN_NAME_LABEL = "Domain name";
    public static final String DOMAIN_PASS_LABEL = "Domain password";
    public static final String CONNECTION_TYPE_LABEL = "Connection type";
    public static final String PORT_NO_LABEL = "Port number";
    public static final String REMOTE_HOST_LABEL = "Remote host";
    public static final String PROTO_XMLNS_LABEL = "Protocol";
    public static final String ROUTINGS_LABEL = "(Optional) Routings";
    private String domain = null;
    private String remoteHost = null;
    private ConnectionType type = ConnectionType.accept;
    private int port = -1;
    private String auth_pass = null;
    private String xmlns = null;
    private String prop_xmlns = null;
    private String[] routings = null;

    @Override
    public void initFromPropertyString(String propString) {
        String[] props = propString.split(":");
        if (props.length > 0) {
            this.setDomain(props[0]);
        }
        if (props.length > 1) {
            this.auth_pass = props[1];
        }
        if (props.length > 2) {
            this.setConnectionType(props[2]);
        }
        if (props.length > 3) {
            this.port = this.parsePortNo(props[3]);
        }
        if (props.length > 4) {
            this.remoteHost = props[4];
        }
        if (props.length > 5) {
            this.setProtocol(props[5]);
        }
    }

    private String parseProtoXMLNS(String input) {
        String result = input;
        if (input.equals("accept")) {
            result = "jabber:component:accept";
        }
        if (input.equals("client")) {
            result = "jabber:client";
        }
        if (input.equals("connect")) {
            result = "jabber:component:connect";
        }
        return result;
    }

    private int parsePortNo(String input) {
        int result = -1;
        try {
            result = Integer.parseInt(input);
        }
        catch (Exception e) {
            result = 5277;
            log.warning("Incorrect port number, can't parse: " + input);
        }
        return result;
    }

    private ConnectionType parseConnectionType(String input) {
        ConnectionType result = ConnectionType.accept;
        if (input.equals("connect")) {
            result = ConnectionType.connect;
        }
        if (input.equals("accept") || input.equals("listen")) {
            result = ConnectionType.accept;
        }
        return result;
    }

    @Override
    public String toPropertyString() {
        return this.domain + ":" + this.auth_pass + ":" + this.type.name() + ":" + this.port + ":" + this.remoteHost + ":" + this.prop_xmlns;
    }

    @Override
    public void initFromElement(Element elem) {
        if (elem.getName() != REPO_ITEM_ELEM_NAME) {
            throw new IllegalArgumentException("Incorrect element name, expected: item");
        }
        this.setDomain(elem.getAttribute(DOMAIN_ATTR));
        this.auth_pass = elem.getAttribute(PASSWORD_ATTR);
        this.remoteHost = elem.getAttribute(REMOTE_HOST_ATTR);
        String tmp = elem.getAttribute(CONN_TYPE_ATTR);
        if (tmp != null) {
            this.setConnectionType(tmp);
        }
        if ((tmp = elem.getAttribute(PORT_NO_ATTR)) != null) {
            this.port = this.parsePortNo(tmp);
        }
        if ((tmp = elem.getAttribute(PROTO_XMLNS_ATTR)) != null) {
            this.setProtocol(tmp);
        }
        if ((tmp = elem.getAttribute(ROUTINGS_ATTR)) != null) {
            this.routings = tmp.split(",");
        }
    }

    @Override
    public Element toElement() {
        Element elem = new Element(REPO_ITEM_ELEM_NAME);
        elem.addAttribute(DOMAIN_ATTR, this.domain);
        elem.addAttribute(PASSWORD_ATTR, this.auth_pass);
        if (this.remoteHost != null && !this.remoteHost.isEmpty()) {
            elem.addAttribute(REMOTE_HOST_ATTR, this.remoteHost);
        }
        elem.addAttribute(CONN_TYPE_ATTR, this.type.name());
        if (this.port > 0) {
            elem.addAttribute(PORT_NO_ATTR, "" + this.port);
        }
        elem.addAttribute(PROTO_XMLNS_ATTR, this.prop_xmlns);
        StringBuilder route = new StringBuilder();
        for (String r : this.routings) {
            if (route.length() > 0) {
                route.append(',');
            }
            route.append(r);
        }
        elem.addAttribute(ROUTINGS_ATTR, route.toString());
        return elem;
    }

    @Override
    public void addCommandFields(Packet packet) {
        Command.addFieldValue(packet, DOMAIN_NAME_LABEL, this.domain != null ? this.domain : "");
        Command.addFieldValue(packet, DOMAIN_PASS_LABEL, this.auth_pass != null ? this.auth_pass : "");
        String[] types = new String[ConnectionType.values().length];
        int i = 0;
        for (ConnectionType t : ConnectionType.values()) {
            types[i++] = t.name();
        }
        Command.addFieldValue(packet, CONNECTION_TYPE_LABEL, this.type.name(), CONNECTION_TYPE_LABEL, types, types);
        Command.addFieldValue(packet, PORT_NO_LABEL, this.port > 0 ? "" + this.port : "");
        Command.addFieldValue(packet, REMOTE_HOST_LABEL, this.remoteHost != null ? this.remoteHost : "");
        Command.addFieldValue(packet, PROTO_XMLNS_LABEL, this.prop_xmlns != null ? this.prop_xmlns : "");
        Command.addFieldValue(packet, ROUTINGS_LABEL, "");
    }

    @Override
    public void initFromCommand(Packet packet) {
        this.domain = Command.getFieldValue(packet, DOMAIN_NAME_LABEL);
        this.routings = new String[]{this.domain, ".*@" + this.domain, ".*\\." + this.domain};
        this.auth_pass = Command.getFieldValue(packet, DOMAIN_PASS_LABEL);
        String tmp = Command.getFieldValue(packet, REMOTE_HOST_LABEL);
        if (tmp != null && !tmp.isEmpty()) {
            this.remoteHost = tmp;
        }
        if ((tmp = Command.getFieldValue(packet, CONNECTION_TYPE_LABEL)) != null && !tmp.isEmpty()) {
            this.type = this.parseConnectionType(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, PORT_NO_LABEL)) != null && !tmp.isEmpty()) {
            this.port = this.parsePortNo(tmp);
        }
        if ((tmp = Command.getFieldValue(packet, PROTO_XMLNS_LABEL)) != null && !tmp.isEmpty()) {
            this.prop_xmlns = tmp;
            this.xmlns = this.parseProtoXMLNS(this.prop_xmlns);
        }
        if ((tmp = Command.getFieldValue(packet, ROUTINGS_LABEL)) != null && !tmp.isEmpty()) {
            this.routings = tmp.split(",");
        }
    }

    @Override
    public String getKey() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.routings = new String[]{domain, ".*@" + domain, ".*\\." + domain};
    }

    public ConnectionType getConnectionType() {
        return this.type;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthPasswd() {
        return this.auth_pass;
    }

    public String[] getRoutings() {
        return this.routings;
    }

    public String getXMLNS() {
        return this.xmlns;
    }

    public String toString() {
        return this.toPropertyString();
    }

    void setPassword(String password) {
        this.auth_pass = password;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setRemoteDomain(String remote_domain) {
        this.remoteHost = remote_domain;
    }

    void setProtocol(String protocol) {
        this.prop_xmlns = protocol;
        this.xmlns = this.parseProtoXMLNS(protocol);
    }

    void setConnectionType(String connection_type) {
        this.type = this.parseConnectionType(connection_type);
    }
}

