/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.bosh;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.bosh.BoshIOService;
import tigase.server.bosh.BoshSession;
import tigase.server.bosh.BoshSessionTaskHandler;
import tigase.server.xmppclient.ClientConnectionManager;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;

public class BoshConnectionManager
extends ClientConnectionManager
implements BoshSessionTaskHandler {
    private static final Logger log = Logger.getLogger("tigase.server.bosh.BoshConnectionManager");
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    private static final String ROUTING_ENTRY_PROP_VAL = "sess-man@localhost";
    private static final int DEF_PORT_NO = 5280;
    private int[] PORTS = new int[]{5280};
    private long max_wait = 30L;
    private long min_polling = 10L;
    private long max_pause = 10L;
    private long max_inactivity = 10L;
    private int hold_requests = 1;
    private int concurrent_requests = 2;
    private ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private final Map<UUID, BoshSession> sessions = new LinkedHashMap<UUID, BoshSession>();

    @Override
    public boolean addOutStreamClosed(Packet packet, BoshSession bs) {
        packet.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
        packet.setPacketTo(bs.getDataReceiver());
        return this.addOutPacketWithTimeout(packet, this.stoppedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public boolean addOutStreamOpen(Packet packet, BoshSession bs) {
        packet.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
        packet.setPacketTo(bs.getDataReceiver());
        return this.addOutPacketWithTimeout(packet, this.startedHandler, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void cancelTask(TimerTask tt) {
        tt.cancel();
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        props.put("max-wait", 30L);
        props.put("min-polling", 10L);
        props.put("max-inactivity", 10L);
        props.put("concurrent-requests", 2);
        props.put("hold-requests", 1);
        props.put("max-inactivity", 10L);
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Bosh connection manager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> srv) {
        BoshIOService serv = (BoshIOService)srv;
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
            BoshSession bs = null;
            String sid_str = null;
            Object object = this.sessions;
            synchronized (object) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing socket data: " + p.toString());
                }
                sid_str = p.getAttribute("sid");
                UUID sid = null;
                if (sid_str == null) {
                    String hostname = p.getAttribute("to");
                    if (hostname != null && this.isLocalDomain(hostname)) {
                        bs = new BoshSession(this.getDefHostName(), JID.jidInstanceNS((String)this.routings.computeRouting(hostname)), this);
                        sid = bs.getSid();
                        this.sessions.put(sid, bs);
                    } else {
                        log.info("Invalid hostname. Closing invalid connection");
                        try {
                            serv.sendErrorAndStop(Authorization.NOT_ALLOWED, p, "Invalid hostname.");
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "Problem sending invalid hostname error for sid =  " + sid, e);
                        }
                    }
                } else {
                    sid = UUID.fromString(sid_str);
                    bs = this.sessions.get(sid);
                }
            }
            try {
                if (bs != null) {
                    object = bs;
                    synchronized (object) {
                        if (sid_str == null) {
                            bs.init(p, serv, this.max_wait, this.min_polling, this.max_inactivity, this.concurrent_requests, this.hold_requests, this.max_pause, out_results);
                        } else {
                            bs.processSocketPacket(p, serv, out_results);
                        }
                    }
                } else {
                    log.info("There is no session with given SID. Closing invalid connection");
                    serv.sendErrorAndStop(Authorization.ITEM_NOT_FOUND, p, "Invalid SID");
                }
                this.addOutPackets(out_results, bs);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem processing socket data for sid =  " + sid_str, e);
            }
        }
        return null;
    }

    @Override
    public TimerTask scheduleTask(BoshSession bs, long delay) {
        BoshTask bt = new BoshTask(bs);
        this.addTimerTask(bt, delay);
        return bt;
    }

    @Override
    public void serviceStarted(BoshIOService service) {
        super.serviceStarted(service);
    }

    public void serviceStopped(BoshIOService service) {
        BoshSession bs;
        super.serviceStopped(service);
        UUID sid = service.getSid();
        if (sid != null && (bs = this.sessions.get(sid)) != null) {
            bs.disconnected(service);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        this.max_wait = (Long)props.get("max-wait");
        this.min_polling = (Long)props.get("min-polling");
        this.max_inactivity = (Long)props.get("max-inactivity");
        this.concurrent_requests = (Integer)props.get("concurrent-requests");
        this.hold_requests = (Integer)props.get("hold-requests");
        this.max_pause = (Long)props.get("max-inactivity");
    }

    @Override
    public void writeRawData(BoshIOService ios, String data) {
        super.writeRawData(ios, data);
    }

    @Override
    public void xmppStreamClosed(BoshIOService serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed.");
        }
    }

    @Override
    public String xmppStreamOpened(BoshIOService serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port as Bosh yet.");
        }
        return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='1' from='" + this.getDefHostName() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<invalid-namespace xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "<text xmlns='urn:ietf:params:xml:ns:xmpp-streams' xml:lang='langcode'>" + "Ups, what just happened? Stream open. Hey, this is a Bosh connection manager. c2s and s2s are not supported on the same port... yet." + "</text>" + "</stream:error>" + "</stream:stream>";
    }

    @Override
    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            String sessionId = session.getSessionId();
            if (sessionId.equals(command_sessionId)) {
                JID old_receiver = session.getDataReceiver();
                session.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.info("Incorrect session ID, ignoring data redirect for: " + newAddress);
        }
        return null;
    }

    protected BoshSession getBoshSession(JID jid) {
        UUID sid = UUID.fromString(jid.getResource());
        return this.sessions.get(sid);
    }

    @Override
    protected int[] getDefPlainPorts() {
        return this.PORTS;
    }

    @Override
    protected int[] getDefSSLPorts() {
        return null;
    }

    @Override
    protected long getMaxInactiveTime() {
        return 600000L;
    }

    @Override
    protected BoshIOService getXMPPIOServiceInstance() {
        return new BoshIOService();
    }

    @Override
    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    @Override
    protected void processCommand(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        switch (packet.getCommand()) {
            case CLOSE: {
                if (session != null) {
                    log.fine("Closing session for command CLOSE: " + session.getSid());
                    session.close();
                    this.sessions.remove(session.getSid());
                    break;
                }
                log.info("Session does not exist for packet: " + packet.toString());
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (session != null) {
                    this.addOutPacket(packet.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.info("Error packet is not really expected here: " + packet.toString());
                }
                break;
            }
            default: {
                super.processCommand(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean writePacketToSocket(Packet packet) {
        BoshSession session = this.getBoshSession(packet.getTo());
        if (session != null) {
            BoshSession boshSession = session;
            synchronized (boshSession) {
                ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
                session.processPacket(packet, out_results);
                this.addOutPackets(out_results, session);
            }
            return true;
        }
        log.info("Session does not exist for packet: " + packet.toString());
        return false;
    }

    private void addOutPackets(Queue<Packet> out_results, BoshSession bs) {
        for (Packet res : out_results) {
            res.setPacketFrom(this.getFromAddress(bs.getSid().toString()));
            res.setPacketTo(bs.getDataReceiver());
            this.addOutPacket(res);
        }
        out_results.clear();
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName(), (String)id);
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            BoshConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.warning("No response within time limit received for a packet: " + packet.toString());
            BoshSession session = BoshConnectionManager.this.getBoshSession(packet.getFrom());
            if (session != null) {
                log.fine("Closing session for timeout: " + session.getSid());
                session.close();
                BoshConnectionManager.this.sessions.remove(session.getSid());
            } else {
                log.info("Session does not exist for packet: " + packet.toString());
            }
        }
    }

    private class BoshTask
    extends TimerTask {
        private BoshSession bs = null;

        public BoshTask(BoshSession bs) {
            this.bs = bs;
        }

        @Override
        public void run() {
            ArrayDeque<Packet> out_results = new ArrayDeque<Packet>();
            if (this.bs.task(out_results, this)) {
                log.fine("Closing session for BS task: " + this.bs.getSid());
                BoshConnectionManager.this.sessions.remove(this.bs.getSid());
            }
            BoshConnectionManager.this.addOutPackets(out_results, this.bs);
        }
    }
}

