/*
 * Decompiled with CFR 0.152.
 */
package tigase.io;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import tigase.io.TLSEventHandler;
import tigase.io.TLSStatus;

public class TLSWrapper {
    private static Logger log = Logger.getLogger("tigase.io.TLSWrapper");
    private SSLEngine tlsEngine = null;
    private SSLEngineResult tlsEngineResult = null;
    private int netBuffSize = 0;
    private int appBuffSize = 0;
    private TLSEventHandler eventHandler = null;

    public TLSWrapper(SSLContext sslc, TLSEventHandler eventHandler, boolean clientMode) {
        this.tlsEngine = sslc.createSSLEngine();
        this.tlsEngine.setUseClientMode(clientMode);
        this.netBuffSize = this.tlsEngine.getSession().getPacketBufferSize();
        this.appBuffSize = this.tlsEngine.getSession().getApplicationBufferSize();
        this.eventHandler = eventHandler;
    }

    public boolean isClientMode() {
        return this.tlsEngine.getUseClientMode();
    }

    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
    }

    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    public int getPacketBuffSize() {
        return this.tlsEngine.getSession().getPacketBufferSize();
    }

    public TLSStatus getStatus() {
        TLSStatus status = null;
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            status = TLSStatus.UNDERFLOW;
        } else if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            status = TLSStatus.CLOSED;
        } else {
            switch (this.tlsEngine.getHandshakeStatus()) {
                case NEED_WRAP: {
                    status = TLSStatus.NEED_WRITE;
                    break;
                }
                case NEED_UNWRAP: {
                    status = TLSStatus.NEED_READ;
                    break;
                }
                case FINISHED: {
                    if (this.eventHandler == null) break;
                    this.eventHandler.handshakeCompleted();
                    break;
                }
                default: {
                    status = TLSStatus.OK;
                }
            }
        }
        return status;
    }

    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        out = this.resizeApplicationBuffer(out);
        this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("unwrap() \ntlsEngineRsult.getStatus() = " + (Object)((Object)this.tlsEngineResult.getStatus()) + "\ntlsEngineRsult.getHandshakeStatus() = " + (Object)((Object)this.tlsEngineResult.getHandshakeStatus()));
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("unwrap() doTasks(), handshake: " + (Object)((Object)this.tlsEngine.getHandshakeStatus()));
            }
        }
        return out;
    }

    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("wrap() \ntlsEngineRsult.getStatus() = " + (Object)((Object)this.tlsEngineResult.getStatus()) + "\ntlsEngineRsult.getHandshakeStatus() = " + (Object)((Object)this.tlsEngineResult.getHandshakeStatus()));
        }
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
            if (log.isLoggable(Level.FINEST)) {
                log.finest("wrap() doTasks(): " + (Object)((Object)this.tlsEngine.getHandshakeStatus()));
            }
        }
    }

    public int bytesConsumed() {
        return this.tlsEngineResult.bytesConsumed();
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer app) {
        if (app.remaining() < this.appBuffSize) {
            ByteBuffer bb = ByteBuffer.allocate(app.capacity() + this.appBuffSize);
            app.flip();
            bb.put(app);
            return bb;
        }
        return app;
    }

    private void doTasks() {
        Runnable runnable = null;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }
}

