/*
 * Decompiled with CFR 0.152.
 */
package tigase.db.comp;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.RepositoryFactory;
import tigase.db.RepositoryItem;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.db.comp.ConfigRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public abstract class UserRepoRepository<Item extends RepositoryItem>
extends ConfigRepository<Item> {
    private static final Logger log = Logger.getLogger(UserRepoRepository.class.getName());
    public static final String REPO_CLASS_PROP_KEY = "repo-class";
    public static final String REPO_URI_PROP_KEY = "repo-uri";
    private String items_list_pkey = "items-lists";
    private UserRepository repo = null;

    public abstract String getRepoUser();

    public String getItemsListPKey() {
        return this.items_list_pkey;
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        super.getDefaults(defs, params);
        String repo_class = "tigase.db.jdbc.JDBCRepository";
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db") != null) {
            repo_class = (String)params.get("--user-db");
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(REPO_CLASS_PROP_KEY, repo_class);
        defs.put(REPO_URI_PROP_KEY, repo_uri);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        super.setProperties(properties);
        this.repo = (UserRepository)properties.get("shared-user-repo");
        if (this.repo != null) {
            log.config("Using shared repository instance.");
        } else {
            String repo_class = (String)properties.get(REPO_CLASS_PROP_KEY);
            String repo_uri = (String)properties.get(REPO_URI_PROP_KEY);
            try {
                this.repo = RepositoryFactory.getUserRepository(this.getRepoUser(), repo_class, repo_uri, null);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Can't initialize Items repository", e);
                this.repo = null;
            }
        }
        if (this.repo != null) {
            try {
                this.repo.addUser(this.getRepoUser());
            }
            catch (UserExistsException e) {
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Problem with adding '" + this.getRepoUser() + "' user to the database", e);
            }
            this.reload();
        }
    }

    @Override
    public void reload() {
        super.reload();
        try {
            String items_list = this.repo.getData(this.getRepoUser(), this.getItemsListPKey());
            if (items_list != null && !items_list.isEmpty()) {
                DomBuilderHandler domHandler = new DomBuilderHandler();
                SimpleParser parser = SingletonFactory.getParserInstance();
                parser.parse((SimpleHandler)domHandler, items_list.toCharArray(), 0, items_list.length());
                Queue elems = domHandler.getParsedElements();
                if (elems != null && elems.size() > 0) {
                    for (Element elem : elems) {
                        Object item = this.getItemInstance();
                        item.initFromElement(elem);
                        this.items.put(item.getKey(), item);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Problem with loading items list from the database.", ex);
        }
        log.config("All loaded items: " + this.items.toString());
    }

    @Override
    public void store() {
        super.store();
        StringBuilder sb = new StringBuilder();
        for (RepositoryItem item : this.items.values()) {
            sb.append(item.toElement().toString());
        }
        try {
            this.repo.setData(this.getRepoUser(), this.getItemsListPKey(), sb.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error storing items list in the repository", e);
        }
    }
}

