/*
 * Decompiled with CFR 0.152.
 */
package tigase.conf;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfigItem;
import tigase.conf.ConfigurationCache;
import tigase.conf.ConfigurationException;
import tigase.db.TigaseDBException;
import tigase.util.DataTypes;
import tigase.util.JDBCAbstract;

public class ConfigSQLRepository
extends ConfigurationCache {
    public static final String CONFIG_REPO_URI_PROP_KEY = "tigase-config-repo-uri";
    public static final String CONFIG_REPO_URI_INIT_KEY = "--tigase-config-repo-uri";
    private static final Logger log = Logger.getLogger(ConfigSQLRepository.class.getName());
    private JDBCAccess dbAccess = new JDBCAccess();

    @Override
    public void init(Map<String, Object> params) throws ConfigurationException {
        String config_db_uri = System.getProperty(CONFIG_REPO_URI_PROP_KEY);
        if (config_db_uri == null) {
            config_db_uri = (String)params.get(CONFIG_REPO_URI_INIT_KEY);
        }
        if (config_db_uri == null) {
            config_db_uri = (String)params.get("--user-db-uri");
        }
        if (config_db_uri == null) {
            log.severe("Missing configuration database connection string.");
            log.severe("Tigase needs a database connection string to load configuration.");
            log.severe("You can provide it in a few ways and the Tigase server checks");
            log.severe("following parameters in the order below:");
            log.severe("1. System property: -Dtigase-config-repo-uri=db-connection-string");
            log.severe("2. init.properties file or command line parameter: --tigase-config-repo-uri=db-connection-string");
            log.severe("3. init.properties file or command line parameter: --user-db-uri=db-connection-string");
            log.severe("Please correct the error and restart the server.");
            System.exit(1);
        }
        try {
            this.dbAccess.initRepository(config_db_uri, null);
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, "Problem connecting to configuration database: ", ex);
            log.severe("Please check whether the database connection string is correct: " + config_db_uri);
            System.exit(1);
        }
    }

    @Override
    public Set<ConfigItem> getItemsForComponent(String compName) {
        return this.dbAccess.getCompItems(compName);
    }

    @Override
    public ConfigItem getItem(String compName, String node, String key) {
        return this.dbAccess.getItem(compName, node, key);
    }

    @Override
    public void addItem(String compName, ConfigItem item) {
        this.dbAccess.addItem(item);
    }

    @Override
    public void removeItem(String compName, ConfigItem item) {
        this.dbAccess.removeItem(item);
    }

    @Override
    public String[] getCompNames() {
        return this.dbAccess.getComponentNames();
    }

    @Override
    public String[] getKeys(String compName, String node) {
        return this.dbAccess.getKeys(compName, node);
    }

    @Override
    public int size() {
        return this.dbAccess.getPropertiesCount();
    }

    @Override
    public Collection<ConfigItem> allItems() throws TigaseDBException {
        return this.dbAccess.getAllItems();
    }

    private class JDBCAccess
    extends JDBCAbstract {
        public static final String TABLE_NAME = "tigase_configuration";
        private static final String CLUSTER_NODE_COLUMN = "cluster_node";
        private static final String COMPONENT_NAME_COLUMN = "component_name";
        private static final String NODE_NAME_COLUMN = "key_node";
        private static final String KEY_NAME_COLUMN = "key_name";
        private static final String VALUE_COLUMN = "value";
        private static final String FLAG_COLUMN = "flag";
        private static final String VALUE_TYPE_COLUMN = "value_type";
        private static final String LAST_UPDATE_COLUMN = "last_update";
        private static final String CREATE_TABLE_QUERY = "create table tigase_configuration (  component_name varchar(127) NOT NULL,  key_name varchar(127) NOT NULL,  value varchar(8191) NOT NULL,  cluster_node varchar(255) NOT NULL DEFAULT '',  key_node varchar(127) NOT NULL DEFAULT '',  flag varchar(32) NOT NULL DEFAULT 'DEFAULT',  value_type varchar(8) NOT NULL DEFAULT 'S',  last_update timestamp,  primary key(cluster_node, component_name, key_node, key_name, flag))";
        private static final String CLUSTER_NODE_WHERE_PART = " (cluster_node = ''  OR cluster_node = ?) ";
        private static final String ITEM_WHERE_PART = " where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String CHECK_TABLE_QUERY = "select count(*) from tigase_configuration";
        private static final String GET_ITEM_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String ADD_ITEM_QUERY = "insert into tigase_configuration (cluster_node, component_name, key_node, key_name, value, value_type, flag)  values (?, ?, ?, ?, ?, ?, ?)";
        private static final String UPDATE_ITEM_QUERY = "update tigase_configuration set value = ?  where (cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?)";
        private static final String DELETE_ITEM_QUERY = "delete from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)  AND (key_node = ?)  AND (key_name = ?) ";
        private static final String GET_ALL_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?) ";
        private static final String GET_COMPONENT_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?)";
        private static final String GET_UPDATED_ITEMS_QUERY = "select * from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (flag <> 'INITIAL') AND (last_update > ?)";
        private static final String GET_COMPONENT_NAMES_QUERY = "select distinct(component_name) from tigase_configuration where cluster_node";
        private static final String GET_PROPERTIES_COUNT_QUERY = "select count(*) as count from tigase_configuration where cluster_node";
        private static final String GET_KEYS_QUERY = "select key_name from tigase_configuration where  (cluster_node = ''  OR cluster_node = ?)  AND (component_name = ?) AND (key_node = ?)";
        private PreparedStatement createTableSt = null;
        private PreparedStatement checkTableSt = null;
        private PreparedStatement getItemSt = null;
        private PreparedStatement getAllItemsSt = null;
        private PreparedStatement getCompItemsSt = null;
        private PreparedStatement getUpdatedItemsSt = null;
        private PreparedStatement addItemSt = null;
        private PreparedStatement updateItemSt = null;
        private PreparedStatement deleteItemSt = null;
        private PreparedStatement getCompNamesSt = null;
        private PreparedStatement getPropertiesCountSt = null;
        private PreparedStatement getKeysSt = null;

        private JDBCAccess() {
        }

        public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
            this.setResourceUri(conn_str);
            this.checkConnection();
            this.checkDB();
        }

        protected void initPreparedStatements() throws SQLException {
            super.initPreparedStatements();
            this.checkTableSt = this.prepareStatement(CHECK_TABLE_QUERY);
            this.getItemSt = this.prepareStatement(GET_ITEM_QUERY);
            this.getAllItemsSt = this.prepareStatement(GET_ALL_ITEMS_QUERY);
            this.getCompItemsSt = this.prepareStatement(GET_COMPONENT_ITEMS_QUERY);
            this.addItemSt = this.prepareStatement(ADD_ITEM_QUERY);
            this.updateItemSt = this.prepareStatement(UPDATE_ITEM_QUERY);
            this.deleteItemSt = this.prepareStatement(DELETE_ITEM_QUERY);
            this.getUpdatedItemsSt = this.prepareStatement(GET_UPDATED_ITEMS_QUERY);
            this.getCompNamesSt = this.prepareStatement(GET_COMPONENT_NAMES_QUERY);
            this.getPropertiesCountSt = this.prepareStatement(GET_PROPERTIES_COUNT_QUERY);
            this.getKeysSt = this.prepareStatement(GET_KEYS_QUERY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDB() throws SQLException {
            ResultSet rs = null;
            try {
                rs = this.checkTableSt.executeQuery();
                if (rs.next()) {
                    long count = rs.getLong(1);
                    log.info("DB for external component OK, items: " + count);
                }
            }
            catch (Exception e) {
                this.initializeDB();
            }
            finally {
                this.release(null, rs);
                rs = null;
            }
        }

        private void initializeDB() throws SQLException {
            this.createTableSt = this.prepareStatement(CREATE_TABLE_QUERY);
            log.info("DB for external component is not OK, creating missing tables...");
            this.createTableSt.executeUpdate();
            log.info("DB for external component created OK");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection<ConfigItem> getAllItems() {
            ArrayList<ConfigItem> result = new ArrayList<ConfigItem>();
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getAllItemsSt;
                synchronized (preparedStatement) {
                    this.getAllItemsSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    rs = this.getAllItemsSt.executeQuery();
                    while (rs.next()) {
                        ConfigItem item = this.createItemFromRS(rs);
                        if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                        result.add(item);
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result;
        }

        private ConfigItem createItemFromRS(ResultSet rs) throws SQLException {
            ConfigItem result = ConfigSQLRepository.this.getItemInstance();
            String clusterNode = rs.getString(CLUSTER_NODE_COLUMN);
            String compName = rs.getString(COMPONENT_NAME_COLUMN);
            String nodeName = rs.getString(NODE_NAME_COLUMN);
            String keyName = rs.getString(KEY_NAME_COLUMN);
            String value_str = rs.getString(VALUE_COLUMN);
            String value_type = rs.getString(VALUE_TYPE_COLUMN);
            String flag_str = rs.getString(FLAG_COLUMN);
            result.set(clusterNode, compName, nodeName, keyName, value_str, value_type.charAt(0), flag_str);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<ConfigItem> getCompItems(String compName) {
            LinkedHashSet<ConfigItem> result = new LinkedHashSet<ConfigItem>();
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getCompItemsSt;
                synchronized (preparedStatement) {
                    this.getCompItemsSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    this.getCompItemsSt.setString(2, compName);
                    rs = this.getCompItemsSt.executeQuery();
                    while (rs.next()) {
                        ConfigItem item = this.createItemFromRS(rs);
                        if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                        result.add(item);
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ConfigItem getItem(String compName, String node, String key) {
            ConfigItem result = null;
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getItemSt;
                synchronized (preparedStatement) {
                    this.getItemSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    this.getItemSt.setString(2, compName);
                    this.getItemSt.setString(3, node);
                    this.getItemSt.setString(4, key);
                    rs = this.getItemSt.executeQuery();
                    while (rs.next()) {
                        ConfigItem item = this.createItemFromRS(rs);
                        if (item.getFlag() == ConfigItem.FLAGS.INITIAL) continue;
                        result = item;
                        break;
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addItem(ConfigItem item) {
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.addItemSt;
                synchronized (preparedStatement) {
                    this.addItemSt.setString(1, item.getClusterNode() != null ? item.getClusterNode() : "");
                    this.addItemSt.setString(2, item.getCompName());
                    this.addItemSt.setString(3, item.getNodeName() != null ? item.getNodeName() : "");
                    this.addItemSt.setString(4, item.getKeyName());
                    this.addItemSt.setString(5, item.getConfigValToString());
                    this.addItemSt.setString(6, "" + DataTypes.getTypeId(item.getConfigVal()));
                    this.addItemSt.setString(7, item.getFlag().name());
                    this.addItemSt.executeUpdate();
                }
            }
            catch (SQLException e) {
                try {
                    this.checkConnection();
                    PreparedStatement preparedStatement = this.updateItemSt;
                    synchronized (preparedStatement) {
                        this.updateItemSt.setString(1, item.getConfigValToString());
                        this.updateItemSt.setString(2, item.getClusterNode() != null ? item.getClusterNode() : "");
                        this.updateItemSt.setString(3, item.getCompName());
                        this.updateItemSt.setString(4, item.getNodeName() != null ? item.getNodeName() : "");
                        this.updateItemSt.setString(5, item.getKeyName());
                        this.updateItemSt.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    try {
                        log.log(Level.WARNING, "Problem adding/updating an item to DB: " + item.toElement() + "\n", ex);
                        log.log(Level.WARNING, "SQLWarning: " + this.updateItemSt.getWarnings().getMessage() + ", state: " + this.updateItemSt.getWarnings().getSQLState());
                    }
                    catch (SQLException ex1) {
                        Logger.getLogger(ConfigSQLRepository.class.getName()).log(Level.SEVERE, null, ex1);
                    }
                }
            }
            catch (Exception e) {
                log.warning(e + "Exception while adding config item: " + item.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getComponentNames() {
            ArrayList<String> result = new ArrayList<String>();
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getCompNamesSt;
                synchronized (preparedStatement) {
                    this.getCompNamesSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    rs = this.getCompNamesSt.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString(COMPONENT_NAME_COLUMN));
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting component names from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result.toArray(new String[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getPropertiesCount() {
            int result = 0;
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getPropertiesCountSt;
                synchronized (preparedStatement) {
                    this.getPropertiesCountSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    rs = this.getPropertiesCountSt.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("count");
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting elements count from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getKeys(String compName, String node) {
            ArrayList<String> result = new ArrayList<String>();
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getKeysSt;
                synchronized (preparedStatement) {
                    this.getKeysSt.setString(1, ConfigSQLRepository.this.getDefHostname());
                    this.getKeysSt.setString(2, compName);
                    this.getKeysSt.setString(3, node);
                    rs = this.getKeysSt.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString(KEY_NAME_COLUMN));
                    }
                }
                this.release(null, rs);
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem getting keys from DB: ", e);
            }
            finally {
                this.release(null, rs);
            }
            return result.toArray(new String[result.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeItem(ConfigItem item) {
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.deleteItemSt;
                synchronized (preparedStatement) {
                    this.deleteItemSt.setString(1, item.getClusterNode() != null ? item.getClusterNode() : "");
                    this.deleteItemSt.setString(2, item.getCompName());
                    this.deleteItemSt.setString(3, item.getNodeName() != null ? item.getNodeName() : "");
                    this.deleteItemSt.setString(4, item.getKeyName());
                    this.deleteItemSt.executeUpdate();
                }
            }
            catch (SQLException e) {
                log.log(Level.WARNING, "Problem removing an item from DB: " + item.toElement(), e);
            }
        }
    }
}

