/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.server.Packet;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPProcessorAbstract;
import tigase.xmpp.XMPPResourceConnection;

public class VCardTemp
extends XMPPProcessorAbstract {
    public static final String VCARD_KEY = "vCard";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.VCardTemp");
    private static final String XMLNS = "vcard-temp";
    private static final String ID = "vcard-temp";
    private static final String[] ELEMENTS = new String[]{"vCard", "VCARD"};
    private static final String[] XMLNSS = new String[]{"vcard-temp", "vcard-temp"};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"vcard-temp"})};
    private static final SimpleParser parser = SingletonFactory.getParserInstance();

    @Override
    public String id() {
        return "vcard-temp";
    }

    @Override
    public void processFromUserToServerPacket(JID connectionId, Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() != null) {
            try {
                switch (packet.getType()) {
                    case get: {
                        String strvCard = session.getPublicData("vcard-temp", VCARD_KEY, null);
                        if (strvCard != null) {
                            results.offer(this.parseXMLData(strvCard, packet));
                            break;
                        }
                        results.offer(packet.okResult((String)null, 1));
                        break;
                    }
                    case set: {
                        Element elvCard = packet.getElement().getChild(ELEMENTS[0]);
                        if (elvCard == null) {
                            elvCard = packet.getElement().getChild(ELEMENTS[1]);
                        }
                        if (elvCard != null) {
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Adding vCard: " + elvCard);
                            }
                            session.setPublicData("vcard-temp", VCARD_KEY, elvCard.toString());
                        } else {
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("Removing vCard");
                            }
                            session.removePublicData("vcard-temp", VCARD_KEY);
                        }
                        results.offer(packet.okResult((String)null, 0));
                        break;
                    }
                }
            }
            catch (NotAuthorizedException ex) {
                log.warning("Received vCard request but user session is not authorized yet: " + packet);
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
            }
            catch (TigaseDBException ex) {
                log.warning("Database problem, please contact admin: " + ex);
                results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
            }
        }
    }

    @Override
    public void processNullSessionPacket(Packet packet, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        if (packet.getType() == StanzaType.get) {
            try {
                String strvCard = repo.getPublicData(packet.getStanzaTo().getBareJID().toString(), "vcard-temp", VCARD_KEY, null);
                if (strvCard != null) {
                    results.offer(this.parseXMLData(strvCard, packet));
                } else {
                    results.offer(packet.okResult((String)null, 1));
                }
            }
            catch (UserNotFoundException e) {
                results.offer(Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "User not found", true));
            }
        }
    }

    @Override
    public void processServerSessionPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) {
    }

    @Override
    public void processToUserPacket(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws PacketErrorTypeException {
        this.processNullSessionPacket(packet, repo, results, settings);
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    private Packet parseXMLData(String data, Packet packet) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        Packet result = packet.okResult((Element)null, 0);
        for (Element el : elems) {
            result.getElement().addChild((XMLNodeIfc)el);
        }
        return result;
    }
}

