/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public abstract class Presence {
    public static final String DIRECT_PRESENCE = "direct-presences";
    public static final String PRESENCE_ELEMENT_NAME = "presence";
    protected static final String XMLNS = "jabber:client";
    private static Logger log = Logger.getLogger("tigase.xmpp.impl.Presence");
    private static final String[] XMLNSS = new String[]{"jabber:client"};
    private static final String[] ELEMENTS = new String[]{"presence"};
    private static long requiredNo = 0L;
    private static long requiredYes = 0L;
    private static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();

    public static void addDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        LinkedHashSet<JID> direct_presences = (LinkedHashSet<JID>)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences == null) {
            direct_presences = new LinkedHashSet<JID>();
            session.putSessionData(DIRECT_PRESENCE, direct_presences);
        }
        direct_presences.add(jid);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Added direct presence jid: " + jid);
        }
    }

    public static void broadcastProbe(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies_from;
        JID[] buddies_to;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Broadcasting probes for: " + session);
        }
        Element presInit = session.getPresence();
        Element presProbe = new Element(PRESENCE_ELEMENT_NAME);
        presProbe.setXMLNS(XMLNS);
        presProbe.setAttribute("type", StanzaType.probe.toString());
        presProbe.setAttribute("from", session.getBareJID().toString());
        JID[] buddies = roster_util.getBuddies(session, RosterAbstract.SUB_BOTH);
        buddies = DynamicRoster.addBuddies(session, settings, buddies);
        if (buddies != null) {
            for (JID buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending probe and intial to: " + buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presProbe);
                Presence.sendPresence(null, null, buddy, results, presInit);
            }
        }
        if ((buddies_to = roster_util.getBuddies(session, RosterAbstract.SUB_TO)) != null) {
            for (JID buddy : buddies_to) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending probe to: " + buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presProbe);
            }
        }
        if ((buddies_from = roster_util.getBuddies(session, RosterAbstract.SUB_FROM)) != null) {
            for (JID buddy : buddies_from) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Sending initial to: " + buddy);
                }
                Presence.sendPresence(null, null, buddy, results, presInit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            try {
                JID jid = session.getJID();
                RosterAbstract.PresenceType pres_type = roster_util.getPresenceType(session, packet);
                if (pres_type == null) {
                    log.warning("Invalid presence found: " + packet);
                    return;
                }
                StanzaType type = packet.getType();
                if (type == null) {
                    type = StanzaType.available;
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest((Object)((Object)pres_type) + " presence found: " + packet);
                }
                switch (pres_type) {
                    case in_unsubscribe: 
                    case in_subscribe: 
                    case in_unsubscribed: 
                    case in_subscribed: {
                        if (packet.getStanzaFrom() == null) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("'in' subscription presence without valid 'from' address, dropping packet: " + packet);
                            }
                            return;
                        }
                        if (!session.isUserId(packet.getStanzaFrom().getBareJID())) break;
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("'in' subscription to myself, not allowed, returning error for packet: " + packet);
                        }
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "You can not subscribe to yourself.", false));
                        return;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: 
                    case out_subscribed: 
                    case out_unsubscribed: {
                        packet.initVars(session.getJID().copyWithoutResource(), packet.getStanzaTo().copyWithoutResource());
                        break;
                    }
                }
                boolean subscr_changed = false;
                switch (pres_type) {
                    case out_initial: {
                        if (packet.getStanzaTo() != null) {
                            if (session.isAnonymous()) {
                                Presence.outInitialAnonymous(packet, session, results);
                            }
                            results.offer(packet.copyElementOnly());
                            if (packet.getType() == StanzaType.unavailable) {
                                Presence.removeDirectPresenceJID(packet.getStanzaTo(), session);
                                break;
                            }
                            Presence.addDirectPresenceJID(packet.getStanzaTo(), session);
                            break;
                        }
                        boolean first = false;
                        if (session.getPresence() == null) {
                            first = true;
                        }
                        packet.initVars(jid, packet.getStanzaTo());
                        session.setPresence(packet.getElement());
                        if (type == StanzaType.available) {
                            if (first) {
                                Presence.broadcastProbe(session, results, settings);
                                Presence.resendPendingInRequests(session, results);
                            } else {
                                Presence.sendPresenceBroadcast(type, session, RosterAbstract.FROM_SUBSCRIBED, results, packet.getElement(), settings);
                            }
                        }
                        Presence.updateUserResources(packet.getElement(), session, results);
                        break;
                    }
                    case out_subscribe: 
                    case out_unsubscribe: {
                        RosterAbstract.SubscriptionType current_subscription;
                        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
                        if (pres_type == RosterAbstract.PresenceType.out_subscribe && (current_subscription = roster_util.getBuddySubscription(session, packet.getStanzaTo())) == null) {
                            roster_util.addBuddy(session, packet.getStanzaTo(), null, null, null);
                        }
                        if (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaTo())) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getStanzaTo()));
                        }
                        break;
                    }
                    case out_subscribed: 
                    case out_unsubscribed: {
                        Presence.forwardPresence(results, packet, session.getJID().copyWithoutResource());
                        JID buddy = packet.getStanzaTo().copyWithoutResource();
                        subscr_changed = roster_util.updateBuddySubscription(session, pres_type, buddy);
                        if (subscr_changed) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, buddy));
                            if (pres_type == RosterAbstract.PresenceType.out_subscribed) {
                                Element presence = session.getPresence();
                                JID from = presence == null ? session.getJID() : null;
                                Presence.sendPresence(StanzaType.available, from, buddy, results, presence);
                                break;
                            }
                            Presence.sendPresence(StanzaType.unavailable, session.getJID(), buddy, results, null);
                        }
                        break;
                    }
                    case in_initial: {
                        if (packet.getStanzaFrom() == null) {
                            log.warning("Initial presence without from attribute set: " + packet);
                            return;
                        }
                        String resource = packet.getStanzaTo().getResource();
                        if (resource != null && !resource.isEmpty()) {
                            XMPPResourceConnection direct = session.getParentSession().getResourceForResource(resource);
                            if (direct != null) {
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Received direct presence from: " + packet.getStanzaFrom() + " to: " + packet.getStanzaTo());
                                }
                                Packet result = packet.copyElementOnly();
                                result.setPacketTo(direct.getConnectionId());
                                result.setPacketFrom(packet.getTo());
                                results.offer(result);
                                break;
                            }
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Ignoring direct presence from: " + packet.getStanzaFrom() + " to: " + packet.getStanzaTo() + ", resource gone.");
                            }
                        } else {
                            JID presBuddy = packet.getStanzaFrom().copyWithoutResource();
                            if (roster_util.isSubscribedTo(session, presBuddy) || DynamicRoster.getBuddyItem(session, settings, presBuddy) != null) {
                                boolean online;
                                boolean bl = online = StanzaType.unavailable != packet.getType();
                                if (log.isLoggable(Level.FINEST)) {
                                    log.finest("Received initial presence, setting buddy: " + packet.getStanzaFrom() + " online status to: " + online);
                                }
                                Presence.updatePresenceChange(packet, session, results);
                            }
                        }
                        break;
                    }
                    case in_subscribe: {
                        if (roster_util.isSubscribedFrom(session, packet.getStanzaFrom())) {
                            Presence.sendPresence(StanzaType.subscribed, session.getJID().copyWithoutResource(), packet.getStanzaFrom(), results, null);
                            break;
                        }
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getStanzaFrom());
                        if (curr_sub == null) {
                            curr_sub = RosterAbstract.SubscriptionType.none;
                            roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
                        }
                        roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
                        Presence.updatePresenceChange(packet, session, results);
                        break;
                    }
                    case in_unsubscribe: {
                        subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom());
                        if (subscr_changed) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                        }
                        break;
                    }
                    case in_subscribed: {
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getStanzaFrom());
                        if (curr_sub == null) {
                            curr_sub = RosterAbstract.SubscriptionType.none;
                            roster_util.addBuddy(session, packet.getStanzaFrom(), null, null, null);
                        }
                        if (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom())) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                        }
                        break;
                    }
                    case in_unsubscribed: {
                        RosterAbstract.SubscriptionType curr_sub = roster_util.getBuddySubscription(session, packet.getStanzaFrom());
                        if (curr_sub != null && (subscr_changed = roster_util.updateBuddySubscription(session, pres_type, packet.getStanzaFrom()))) {
                            roster_util.updateBuddyChange(session, results, roster_util.getBuddyItem(session, packet.getStanzaFrom()));
                        }
                        break;
                    }
                    case in_probe: {
                        if (session.getPresence() == null) {
                            return;
                        }
                        RosterAbstract.SubscriptionType buddy_subscr = null;
                        buddy_subscr = DynamicRoster.getBuddyItem(session, settings, packet.getStanzaFrom()) != null ? RosterAbstract.SubscriptionType.both : roster_util.getBuddySubscription(session, packet.getStanzaFrom());
                        if (buddy_subscr == null) {
                            buddy_subscr = RosterAbstract.SubscriptionType.none;
                        }
                        switch (buddy_subscr) {
                            case none: 
                            case none_pending_out: 
                            case to: {
                                results.offer(Authorization.FORBIDDEN.getResponseMessage(packet, "Presence information is forbidden.", false));
                                break;
                            }
                            case none_pending_in: 
                            case none_pending_out_in: 
                            case to_pending_in: {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to get presence information.", false));
                                break;
                            }
                        }
                        if (roster_util.isSubscribedFrom(buddy_subscr)) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Received probe, setting buddy: " + packet.getStanzaFrom() + " as online.");
                            }
                            for (XMPPResourceConnection conn : session.getActiveSessions()) {
                                try {
                                    Element pres = conn.getPresence();
                                    if (pres == null) continue;
                                    Presence.sendPresence(null, null, packet.getStanzaFrom().copyWithoutResource(), results, pres);
                                    if (!log.isLoggable(Level.FINEST)) continue;
                                    log.finest("Received probe, sending presence response to: " + packet.getStanzaFrom());
                                }
                                catch (Exception e) {}
                            }
                        }
                        break;
                    }
                    case error: {
                        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
                        if (direct_presences != null && direct_presences.contains(packet.getStanzaFrom())) {
                            Packet result = packet.copyElementOnly();
                            result.setPacketTo(session.getConnectionId());
                            result.setPacketFrom(packet.getTo());
                            results.offer(result);
                        }
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                    }
                }
            }
            catch (NotAuthorizedException e) {
                log.info("Can not access user Roster, user session is not authorized yet: " + packet);
                log.log(Level.FINEST, "presence problem...", e);
            }
            catch (TigaseDBException e) {
                log.warning("Error accessing database for presence data: " + e);
            }
        }
    }

    public static void removeDirectPresenceJID(JID jid, XMPPResourceConnection session) {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null) {
            direct_presences.remove(jid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Added direct presence jid: " + jid);
        }
    }

    public static void resendPendingInRequests(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies = roster_util.getBuddies(session, RosterAbstract.PENDING_IN);
        if (buddies != null) {
            for (JID buddy : buddies) {
                Element presence = new Element(PRESENCE_ELEMENT_NAME);
                presence.setAttribute("type", StanzaType.subscribe.toString());
                presence.setXMLNS(XMLNS);
                Packet pres = Packet.packetInstance(presence, buddy, null);
                Presence.updatePresenceChange(pres, session, results);
            }
        }
    }

    public static void sendPresence(StanzaType t, JID from, JID to, Queue<Packet> results, Element pres) {
        Element presence = null;
        if (pres == null) {
            presence = new Element(PRESENCE_ELEMENT_NAME);
            if (t != null) {
                presence.setAttribute("type", t.toString());
            } else {
                presence.setAttribute("type", StanzaType.unavailable.toString());
            }
            presence.setAttribute("from", from.toString());
            presence.setXMLNS(XMLNS);
        } else {
            presence = pres.clone();
        }
        presence.setAttribute("to", to.toString());
        try {
            Packet packet = Packet.packetInstance(presence);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending presence info: " + packet);
            }
            results.offer(packet);
        }
        catch (TigaseStringprepException ex) {
            log.warning("Packet stringprep addressing problem, skipping presence send: " + presence);
        }
    }

    public static void sendPresenceBroadcast(StanzaType t, XMPPResourceConnection session, EnumSet<RosterAbstract.SubscriptionType> subscrs, Queue<Packet> results, Element pres, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        JID[] buddies = roster_util.getBuddies(session, subscrs);
        if ((buddies = DynamicRoster.addBuddies(session, settings, buddies)) != null) {
            for (JID buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                Presence.sendPresence(t, null, buddy, results, pres);
            }
        }
        Presence.broadcastDirectPresences(t, session, results, pres);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block12: {
                Set direct_presences;
                try {
                    if (session.getPresence() != null) {
                        Presence.broadcastOffline(session, results, settings);
                        Presence.updateOfflineChange(session, results);
                    } else {
                        Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, null);
                    }
                }
                catch (NotAuthorizedException e) {
                }
                catch (TigaseDBException e) {
                    log.warning("Error accessing database for offline message: " + e);
                }
                if (session.isAnonymous() && (direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE)) != null) {
                    try {
                        for (JID buddy : direct_presences) {
                            JID peer = buddy.copyWithoutResource();
                            Iq roster_update = Iq.createRosterPacket("set", session.nextStanzaId(), peer, peer, session.getJID().copyWithoutResource(), null, null, "remove", "anon");
                            results.offer(roster_update);
                        }
                    }
                    catch (NotAuthorizedException e) {
                        if (!log.isLoggable(Level.FINEST)) break block12;
                        log.finest("Anonymous user has logged out already: " + session);
                    }
                }
            }
        }
    }

    public static void updatePresenceChange(Packet presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean initial_p = presence.getAttribute("type") == null || "available".equals(presence.getAttribute("type")) || "unavailable".equals(presence.getAttribute("type"));
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            if (conn.getPresence() == null && initial_p) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.finest("Skipping update presence change for a resource which hasn't sent initial presence yet.");
                continue;
            }
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn);
                }
                Packet pres_update = presence.copyElementOnly();
                pres_update.initVars(presence.getStanzaFrom(), conn.getJID().copyWithoutResource());
                pres_update.setPacketTo(conn.getConnectionId());
                results.offer(pres_update);
            }
            catch (Exception e) {}
        }
    }

    public static void updateUserResources(Element presence, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn.getJID());
                }
                if (conn != session && conn.isResourceSet()) {
                    Element pres_update = presence.clone();
                    pres_update.setAttribute("from", session.getJID().toString());
                    pres_update.setAttribute("to", conn.getBareJID().toString());
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    Element presence_el = conn.getPresence();
                    if (presence_el == null) continue;
                    pres_update = presence_el.clone();
                    pack_update = Packet.packetInstance(pres_update, conn.getJID(), session.getJID().copyWithoutResource());
                    pack_update.setPacketTo(session.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    protected static void broadcastDirectPresences(StanzaType t, XMPPResourceConnection session, Queue<Packet> results, Element pres) throws NotAuthorizedException, TigaseDBException {
        Set direct_presences = (Set)session.getSessionData(DIRECT_PRESENCE);
        if (direct_presences != null && t != null && t == StanzaType.unavailable) {
            for (JID buddy : direct_presences) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Updating direct presence for: " + buddy);
                }
                Presence.sendPresence(t, session.getJID(), buddy, results, pres);
            }
        }
    }

    protected static void broadcastOffline(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        Element pres = session.getPresence();
        if (pres != null) {
            pres.setAttribute("type", StanzaType.unavailable.toString());
        }
        JID[] buddies = roster_util.getBuddies(session, RosterAbstract.FROM_SUBSCRIBED);
        if ((buddies = DynamicRoster.addBuddies(session, settings, buddies)) != null && pres != null) {
            for (JID buddy : buddies) {
                if (!Presence.requiresPresenceSending(buddy, session)) continue;
                Presence.sendPresence(StanzaType.unavailable, null, buddy, results, pres);
            }
        }
        Presence.broadcastDirectPresences(StanzaType.unavailable, session, results, pres);
    }

    protected static void forwardPresence(Queue<Packet> results, Packet packet, JID from) {
        Element result = packet.getElement().clone();
        result.setAttribute("from", from.toString());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("\n\nFORWARD presence: " + result.toString());
        }
        results.offer(Packet.packetInstance(result, from, packet.getStanzaTo()));
    }

    protected static void outInitialAnonymous(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Anonymous session: " + session);
        }
        JID peer = packet.getStanzaTo().copyWithoutResource();
        String nick = packet.getElemCData("/presence/nick");
        if (nick == null) {
            nick = session.getUserName();
        }
        Iq rost_update = Iq.createRosterPacket("set", session.nextStanzaId(), peer, peer, session.getJID().copyWithoutResource(), nick, new String[]{"Anonymous peers"}, null, "anon");
        results.offer(rost_update);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending roster update: " + rost_update);
        }
    }

    protected static void updateOfflineChange(XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        for (XMPPResourceConnection conn : session.getActiveSessions()) {
            try {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Update presence change to: " + conn.getJID());
                }
                if (conn != session && conn.getResource() != null && !conn.getResource().equals(session.getResource())) {
                    Element pres_update = new Element(PRESENCE_ELEMENT_NAME);
                    pres_update.setAttribute("from", session.getJID().toString());
                    pres_update.setAttribute("to", conn.getBareJID().toString());
                    pres_update.setAttribute("type", StanzaType.unavailable.toString());
                    pres_update.setXMLNS(XMLNS);
                    Packet pack_update = Packet.packetInstance(pres_update, session.getJID(), conn.getJID().copyWithoutResource());
                    pack_update.setPacketTo(conn.getConnectionId());
                    results.offer(pack_update);
                    continue;
                }
                if (!log.isLoggable(Level.FINER)) continue;
                log.finer("Skipping presence update to: " + conn.getJID());
            }
            catch (Exception e) {}
        }
    }

    private static boolean requiresPresenceSending(JID buddy, XMPPResourceConnection session) {
        boolean result;
        String buddy_domain = buddy.getDomain();
        boolean bl = result = !runtime.hasCompleteJidsInfo() || !session.isLocalDomain(buddy_domain, false) || runtime.isJidOnline(buddy);
        if (log.isLoggable(Level.FINEST)) {
            if (result) {
                ++requiredYes;
            } else {
                ++requiredNo;
            }
            log.finest("Yes/No: " + requiredYes + " / " + requiredNo + ", buddy: " + buddy + ", result=" + result + ", !runtime.hasCompleteJidsInfo()=" + !runtime.hasCompleteJidsInfo() + ", !session.isLocalDomain(buddy_domain, false)=" + !session.isLocalDomain(buddy_domain, false) + ", runtime.isJidOnline(buddy)=" + runtime.isJidOnline(buddy));
        }
        return result;
    }
}

