/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.DynamicRoster;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterFactory;

public abstract class JabberIqRoster {
    private static Logger log = Logger.getLogger(JabberIqRoster.class.getName());
    private static final String[] ELEMENTS = new String[]{"query", "query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:roster", "jabber:iq:roster-dynamic"};
    public static final String ANON = "anon";
    private static RosterAbstract roster_util = RosterFactory.getRosterImplementation(true);

    public static String[] getItemGroups(Element item) {
        List elgr = item.getChildren();
        if (elgr != null && elgr.size() > 0) {
            ArrayList<String> groups = new ArrayList<String>();
            for (Element grp : elgr) {
                if (grp.getName() != "group") continue;
                groups.add(grp.getCData());
            }
            if (groups.size() > 0) {
                return groups.toArray(new String[groups.size()]);
            }
        }
        return null;
    }

    public static void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        JID connectionId = session.getConnectionId();
        if (connectionId.equals((Object)packet.getPacketFrom())) {
            if (packet.getStanzaTo() != null && !session.isLocalDomain(packet.getStanzaTo().toString(), false) && !session.isUserId(packet.getStanzaTo().getBareJID())) {
                results.offer(packet.copyElementOnly());
                return;
            }
        } else if (session.isUserId(packet.getStanzaTo().getBareJID())) {
            Packet result = packet.copyElementOnly();
            result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
            result.setPacketFrom(packet.getTo());
            results.offer(result);
            return;
        }
        try {
            if (packet.getStanzaFrom() != null && !session.isUserId(packet.getStanzaFrom().getBareJID())) {
                log.warning("Roster request 'from' attribute doesn't match session: " + session + ", request: " + packet);
                return;
            }
            StanzaType type = packet.getType();
            String xmlns = packet.getElement().getXMLNS("/iq/query");
            if (xmlns == "jabber:iq:roster") {
                switch (type) {
                    case get: {
                        JabberIqRoster.processGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        JabberIqRoster.processSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else if (xmlns == "jabber:iq:roster-dynamic") {
                switch (type) {
                    case get: {
                        JabberIqRoster.dynamicGetRequest(packet, session, results, settings);
                        break;
                    }
                    case set: {
                        JabberIqRoster.dynamicSetRequest(packet, session, results, settings);
                        break;
                    }
                    case result: {
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Request type is incorrect", false));
                        break;
                    }
                }
            } else {
                log.warning("Unknown XMLNS for the roster plugin: " + packet);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("Received roster request but user session is not authorized yet: " + packet);
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
        catch (TigaseDBException e) {
            log.warning("Database problem, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    public static void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
    }

    private static void dynamicGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException {
        Element request = packet.getElement();
        Element item = request.findChild("/iq/query/item");
        if (item != null) {
            Element new_item = DynamicRoster.getItemExtraData(session, settings, item);
            if (new_item == null) {
                new_item = item;
            }
            results.offer(packet.okResult(new_item, 1));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    private static void dynamicSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        Element request = packet.getElement();
        List items = request.getChildren("/iq/query");
        if (items != null && items.size() > 0) {
            for (Element item : items) {
                DynamicRoster.setItemExtraData(session, settings, item);
            }
            results.offer(packet.okResult((String)null, 0));
        } else {
            try {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Missing 'item' element, request can not be processed.", true));
            }
            catch (PacketErrorTypeException ex) {
                log.log(Level.SEVERE, "Received error packet? not possible.", ex);
            }
        }
    }

    private static void processGetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws NotAuthorizedException, TigaseDBException {
        String incomingHash = packet.getElement().getAttribute("/iq/query", "ver");
        String storedHash = "";
        List<Element> its = DynamicRoster.getRosterItems(session, settings);
        if (its != null && its.size() > 0) {
            Iterator<Element> it = its.iterator();
            while (it.hasNext()) {
                Element element = it.next();
                try {
                    JID jid = JID.jidInstance((String)element.getAttribute("jid"));
                    if (!roster_util.containsBuddy(session, jid)) continue;
                    roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, jid);
                    String[] itemGroups = JabberIqRoster.getItemGroups(element);
                    if (itemGroups != null) {
                        roster_util.addBuddyGroup(session, jid, itemGroups);
                    }
                    it.remove();
                }
                catch (TigaseStringprepException ex) {
                    log.info("JID from dynamic roster is incorrect, stringprep failed for: " + element.getAttribute("jid"));
                    it.remove();
                }
            }
        }
        if (incomingHash != null && incomingHash.equals(storedHash = roster_util.getBuddiesHash(session))) {
            results.offer(packet.okResult((String)null, 0));
            return;
        }
        List<Element> ritems = roster_util.getRosterItems(session);
        if (ritems != null && ritems.size() > 0) {
            Element query = new Element("query");
            query.setXMLNS("jabber:iq:roster");
            if (incomingHash != null) {
                query.setAttribute("ver", storedHash);
            }
            query.addChildren(ritems);
            results.offer(packet.okResult(query, 0));
        } else {
            results.offer(packet.okResult((String)null, 1));
        }
        try {
            if (its != null && its.size() > 0) {
                ArrayDeque<Element> items = new ArrayDeque<Element>(its);
                while (items.size() > 0) {
                    Element iq = new Element("iq", new String[]{"type", "id", "to"}, new String[]{"set", "dr-" + items.size(), session.getJID().toString()});
                    Element query = new Element("query");
                    query.setXMLNS("jabber:iq:roster");
                    iq.addChild((XMLNodeIfc)query);
                    query.addChild((XMLNodeIfc)items.poll());
                    while (query.getChildren().size() < 20 && items.size() > 0) {
                        query.addChild((XMLNodeIfc)items.poll());
                    }
                    Packet rost_res = Packet.packetInstance(iq, null, session.getJID());
                    rost_res.setPacketTo(session.getConnectionId());
                    rost_res.setPacketFrom(packet.getTo());
                    results.offer(rost_res);
                }
            }
        }
        catch (NoConnectionIdException ex) {
            log.warning("Problem with roster request, no connection ID for session: " + session + ", request: " + packet);
        }
    }

    private static void processSetRequest(Packet packet, XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) throws XMPPException, NotAuthorizedException, TigaseDBException {
        List<Element> items = packet.getElemChildren("/iq/query");
        if (items != null) {
            try {
                for (Element item : items) {
                    JID buddy = JID.jidInstance((String)item.getAttribute("jid"));
                    if (session.isUserId(buddy.getBareJID())) {
                        results.offer(Authorization.NOT_ALLOWED.getResponseMessage(packet, "User can't add himself to the roster, RFC says NO.", true));
                        return;
                    }
                    String subscription = item.getAttribute("subscription");
                    if (subscription != null && subscription.equals("remove")) {
                        RosterAbstract.SubscriptionType sub = roster_util.getBuddySubscription(session, buddy);
                        if (sub == null) {
                            sub = RosterAbstract.SubscriptionType.none;
                        }
                        String type = item.getAttribute("type");
                        if (!(sub == RosterAbstract.SubscriptionType.none || type != null && type.equals(ANON))) {
                            Element pres = new Element("presence");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getJID().toString());
                            pres.setAttribute("type", "unavailable");
                            Packet pres_packet = Packet.packetInstance(pres, session.getJID(), buddy);
                            pres_packet.setPriority(Priority.HIGH);
                            results.offer(pres_packet);
                            pres = new Element("presence");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getBareJID().toString());
                            pres.setAttribute("type", "unsubscribe");
                            results.offer(Packet.packetInstance(pres, session.getJID().copyWithoutResource(), buddy));
                            pres = new Element("presence");
                            pres.setAttribute("to", buddy.toString());
                            pres.setAttribute("from", session.getBareJID().toString());
                            pres.setAttribute("type", "unsubscribed");
                            results.offer(Packet.packetInstance(pres, session.getJID().copyWithoutResource(), buddy));
                        }
                        Element it = new Element("item");
                        it.setAttribute("jid", buddy.toString());
                        it.setAttribute("subscription", "remove");
                        roster_util.updateBuddyChange(session, results, it);
                        roster_util.removeBuddy(session, buddy);
                        continue;
                    }
                    Element dynamicItem = DynamicRoster.getBuddyItem(session, settings, buddy);
                    String name = item.getAttribute("name");
                    List groups = item.getChildren();
                    String[] gr = null;
                    if (groups != null && groups.size() > 0) {
                        gr = new String[groups.size()];
                        int cnt = 0;
                        for (Element group : groups) {
                            gr[cnt++] = group.getCData() == null ? "" : group.getCData();
                        }
                    }
                    roster_util.addBuddy(session, buddy, name, gr, null);
                    String type = item.getAttribute("type");
                    if (type != null && type.equals(ANON)) {
                        roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy);
                        Element pres = (Element)session.getSessionData("user-presence");
                        pres = pres == null ? new Element("presence") : pres.clone();
                        pres.setAttribute("to", buddy.toString());
                        pres.setAttribute("from", session.getJID().toString());
                        results.offer(Packet.packetInstance(pres, session.getJID(), buddy));
                    }
                    Element new_buddy = roster_util.getBuddyItem(session, buddy);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("1. New Buddy: " + new_buddy.toString());
                    }
                    if (roster_util.getBuddySubscription(session, buddy) == null) {
                        roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.none, buddy);
                    }
                    if (dynamicItem != null) {
                        roster_util.setBuddySubscription(session, RosterAbstract.SubscriptionType.both, buddy);
                        String[] itemGroups = JabberIqRoster.getItemGroups(dynamicItem);
                        if (itemGroups != null) {
                            roster_util.addBuddyGroup(session, buddy, itemGroups);
                        }
                    }
                    new_buddy = roster_util.getBuddyItem(session, buddy);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("2. New Buddy: " + new_buddy.toString());
                    }
                    roster_util.updateBuddyChange(session, results, new_buddy);
                }
                results.offer(packet.okResult((String)null, 0));
            }
            catch (TigaseStringprepException ex) {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Buddy JID is incorrct, stringprep failed.", true));
            }
        } else {
            log.warning("No items found in roster set request: " + packet);
            results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "No items found in the roster set request", true));
        }
    }
}

