/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqRegister
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static Logger log = Logger.getLogger(JabberIqRegister.class.getName());
    private static final String ID = "jabber:iq:register";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:register"};
    private static final Element[] FEATURES = new Element[]{new Element("register", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-register"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:register"})};

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toString());
        }
        if (session == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Session is null, ignoring");
            }
            return;
        }
        BareJID id = session.getDomainAsJID().getBareJID();
        if (packet.getStanzaTo() != null) {
            id = packet.getStanzaTo().getBareJID();
        }
        try {
            if (packet.getPacketFrom().equals((Object)session.getConnectionId()) && (!session.isAuthorized() || session.isUserId(id) || session.isLocalDomain(id.toString(), false))) {
                Authorization result = Authorization.NOT_AUTHORIZED;
                Element request = packet.getElement();
                StanzaType type = packet.getType();
                switch (type) {
                    case set: {
                        Element elem = request.findChild("/iq/query/remove");
                        if (elem != null) {
                            elem = request.findChild("/iq/query");
                            if (elem.getChildren().size() > 1) {
                                result = Authorization.BAD_REQUEST;
                                break;
                            }
                            try {
                                result = session.unregister(packet.getStanzaFrom().toString());
                                Packet ok_result = packet.okResult((String)null, 0);
                                ok_result.setPriority(Priority.SYSTEM);
                                results.offer(ok_result);
                                results.offer(Command.CLOSE.getPacket(session.getSMComponentId(), session.getConnectionId(), StanzaType.set, session.nextStanzaId()));
                            }
                            catch (NotAuthorizedException e) {
                                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                            }
                            break;
                        }
                        String user_name = request.getChildCData("/iq/query/username");
                        String password = request.getChildCData("/iq/query/password");
                        String email = request.getChildCData("/iq/query/email");
                        LinkedHashMap<String, String> reg_params = null;
                        if (email != null && !email.trim().isEmpty()) {
                            reg_params = new LinkedHashMap<String, String>();
                            reg_params.put("email", email);
                        }
                        if ((result = session.register(user_name, password, reg_params)) == Authorization.AUTHORIZED) {
                            results.offer(result.getResponseMessage(packet, null, false));
                            break;
                        }
                        results.offer(result.getResponseMessage(packet, "Unsuccessful registration attempt", true));
                        break;
                    }
                    case get: {
                        results.offer(packet.okResult("<instructions>Choose a user name and password for use with this service.Please provide also your e-mail address.</instructions><username/><password/><email/>", 1));
                        break;
                    }
                    case result: {
                        Packet pack_res = packet.copyElementOnly();
                        pack_res.setPacketTo(session.getConnectionId());
                        results.offer(pack_res);
                        break;
                    }
                    default: {
                        results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", true));
                    }
                }
            } else if (session.isUserId(id)) {
                Packet pack_res = packet.copyElementOnly();
                pack_res.setPacketTo(session.getConnectionId());
                results.offer(pack_res);
            } else {
                results.offer(packet.copyElementOnly());
            }
        }
        catch (NotAuthorizedException e) {
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized to change registration settings.\n" + e.getMessage(), true));
        }
        catch (TigaseDBException e) {
            log.warning("Database proble, please contact admin: " + e);
            results.offer(Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, "Database access problem, please contact administrator.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        return FEATURES;
    }
}

