/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqCommand
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final String[] ELEMENTS = new String[]{"command"};
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqCommand");
    private static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/commands"};
    private static final String XMLNS = "http://jabber.org/protocol/commands";
    private static final String ID = "http://jabber.org/protocol/commands";
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/commands"})};

    @Override
    public String id() {
        return "http://jabber.org/protocol/commands";
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        try {
            BareJID id;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Received packet: " + packet.toString());
            }
            if (packet.getStanzaTo() == null) {
                packet.initVars(packet.getStanzaFrom(), session.getSMComponentId());
            }
            if (session.isUserId(id = packet.getStanzaTo().getBareJID())) {
                Packet result = packet.copyElementOnly();
                result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                result.setPacketFrom(packet.getTo());
                results.offer(result);
            } else {
                Packet result = packet.copyElementOnly();
                results.offer(result);
            }
        }
        catch (NotAuthorizedException e) {
            log.warning("NotAuthorizedException for packet: " + packet.toString());
            results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
        }
    }

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }
}

