/*
 * Decompiled with CFR 0.152.
 */
package tigase.xmpp.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class JabberIqAuth
extends XMPPProcessor
implements XMPPProcessorIfc {
    private static final Logger log = Logger.getLogger("tigase.xmpp.impl.JabberIqAuth");
    private static final String XMLNS = "jabber:iq:auth";
    private static final String ID = "jabber:iq:auth";
    private static final String[] ELEMENTS = new String[]{"query"};
    private static final String[] XMLNSS = new String[]{"jabber:iq:auth"};
    private static final Element[] FEATURES = new Element[]{new Element("auth", new String[]{"xmlns"}, new String[]{"http://jabber.org/features/iq-auth"})};
    private static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"jabber:iq:auth"})};

    @Override
    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    @Override
    public String id() {
        return "jabber:iq:auth";
    }

    @Override
    public String[] supElements() {
        return ELEMENTS;
    }

    @Override
    public String[] supNamespaces() {
        return XMLNSS;
    }

    @Override
    public Element[] supStreamFeatures(XMPPResourceConnection session) {
        if (session == null || session.isAuthorized()) {
            return null;
        }
        return FEATURES;
    }

    @Override
    public int concurrentQueuesNo() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int concurrentThreadsPerQueue() {
        return 2;
    }

    @Override
    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        if (session == null) {
            return;
        }
        Element request = packet.getElement();
        StanzaType type = packet.getType();
        switch (type) {
            case get: {
                HashMap<String, Object> query = new HashMap<String, Object>();
                query.put("protocol", "nonsasl");
                session.queryAuth(query);
                String[] auth_mechs = (String[])query.get("result");
                StringBuilder response = new StringBuilder("<username/>");
                for (String mech : auth_mechs) {
                    response.append("<").append(mech).append("/>");
                }
                response.append("<resource/>");
                results.offer(packet.okResult(response.toString(), 1));
                break;
            }
            case set: {
                String user_name = request.getChildCData("/iq/query/username");
                String resource = request.getChildCData("/iq/query/resource");
                String password = request.getChildCData("/iq/query/password");
                String digest = request.getChildCData("/iq/query/digest");
                Object auth_mod = null;
                try {
                    Authorization result = null;
                    if (password != null) {
                        result = session.loginPlain(user_name, password);
                    }
                    if (digest != null) {
                        result = session.loginDigest(user_name, digest, session.getSessionId(), "SHA");
                    }
                    if (result == Authorization.AUTHORIZED) {
                        session.setResource(resource);
                        results.offer(session.getAuthState().getResponseMessage(packet, "Authentication successful.", false));
                        break;
                    }
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "Authentication failed", false));
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, packet.getStanzaId()));
                }
                catch (NotAuthorizedException e) {
                    log.info("Authentication failed: " + user_name);
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, e.getMessage(), false));
                    Integer retries = (Integer)session.getSessionData("auth-retries");
                    if (retries == null) {
                        retries = new Integer(0);
                    }
                    if (retries < 3) {
                        session.putSessionData("auth-retries", new Integer(retries + 1));
                        break;
                    }
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, packet.getStanzaId()));
                }
                catch (Exception e) {
                    log.info("Authentication failed: " + user_name);
                    log.log(Level.WARNING, "Authentication failed: ", e);
                    results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, e.getMessage(), false));
                    results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, packet.getStanzaId()));
                }
                break;
            }
            default: {
                results.offer(Authorization.BAD_REQUEST.getResponseMessage(packet, "Message type is incorrect", false));
                results.offer(Command.CLOSE.getPacket(packet.getTo(), packet.getFrom(), StanzaType.set, packet.getStanzaId()));
            }
        }
    }
}

