/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import tigase.conf.ConfiguratorAbstract;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.server.AbstractComponentRegistrator;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ServerComponent;
import tigase.stats.StatRecord;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.stats.StatisticsProvider;
import tigase.sys.ShutdownHook;
import tigase.sys.TigaseRuntime;
import tigase.util.ElementUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xml.XMLUtils;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class StatisticsCollector
extends AbstractComponentRegistrator<StatisticsContainer>
implements ShutdownHook {
    public static final String STATISTICS_MBEAN_NAME = "tigase.stats:type=StatisticsProvider";
    private static final String STATS_XMLNS = "http://jabber.org/protocol/stats";
    private static final Logger log = Logger.getLogger("tigase.stats.StatisticsCollector");
    private ServiceEntity serviceEntity = null;
    private Level statsLevel = Level.INFO;

    @Override
    public void componentAdded(StatisticsContainer component) {
        ServiceEntity item = this.serviceEntity.findNode(component.getName());
        if (item == null) {
            item = new ServiceEntity(this.getName(), component.getName(), "Component: " + component.getName());
            item.addFeatures(CMD_FEATURES);
            item.addIdentities(new ServiceIdentity("automation", "command-node", "Component: " + component.getName()));
            this.serviceEntity.addItems(item);
        }
    }

    @Override
    public void componentRemoved(StatisticsContainer component) {
    }

    public StatisticsList getAllStats() {
        StatisticsList list = new StatisticsList(Level.ALL);
        this.getAllStats(list);
        return list;
    }

    public void getAllStats(StatisticsList list) {
        for (StatisticsContainer comp : this.components.values()) {
            this.getComponentStats(comp.getName(), list);
        }
    }

    public void getComponentStats(String name, StatisticsList list) {
        Object result = null;
        StatisticsContainer stats = (StatisticsContainer)this.components.get(name);
        if (stats != null) {
            stats.getStatistics(list);
        }
    }

    public List<String> getComponentsNames() {
        return new ArrayList<String>(this.components.keySet());
    }

    @Override
    public List<Element> getDiscoFeatures(JID from) {
        return null;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        if (jid != null && this.getName().equals(jid.getLocalpart()) && this.isAdmin(from)) {
            return this.serviceEntity.getDiscoInfo(node);
        }
        return null;
    }

    @Override
    public List<Element> getDiscoItems(String node, JID jid, JID from) {
        if (this.isAdmin(from)) {
            if (this.getName().equals(jid.getLocalpart()) || this.getComponentId().equals((Object)jid)) {
                List<Element> items = this.serviceEntity.getDiscoItems(node, jid.toString());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing discoItems for node: " + node + ", result: " + (items == null ? null : items.toString()));
                }
                return items;
            }
            if (node == null) {
                Element item = this.serviceEntity.getDiscoItem(null, BareJID.toString((String)this.getName(), (String)jid.toString()));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing discoItems, result: " + (item == null ? null : item.toString()));
                }
                return Arrays.asList(item);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean isCorrectType(ServerComponent component) {
        return component instanceof StatisticsContainer;
    }

    @Override
    public void processPacket(Packet packet, Queue<Packet> results) {
        if (!packet.isCommand() || packet.getType() == StanzaType.result) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(packet.getCommand().name() + " command received: " + packet);
        }
        Iq iqc = (Iq)packet;
        switch (iqc.getCommand()) {
            case GETSTATS: {
                Element iq = ElementUtils.createIqQuery(iqc.getStanzaTo(), iqc.getStanzaFrom(), StanzaType.result, iqc.getStanzaId(), STATS_XMLNS);
                Element query = iq.getChild("query");
                StatisticsList stats = this.getAllStats();
                if (stats != null) {
                    for (StatRecord record : stats) {
                        Element item = new Element("stat");
                        item.addAttribute("name", record.getComponent() + "/" + record.getDescription());
                        item.addAttribute("units", record.getUnit());
                        item.addAttribute("value", record.getValue());
                        query.addChild((XMLNodeIfc)item);
                    }
                }
                Packet result = Packet.packetInstance(iq, iqc.getStanzaTo(), iqc.getStanzaFrom());
                results.offer(result);
                break;
            }
            case OTHER: {
                if (iqc.getStrCommand() == null) {
                    return;
                }
                String nick = iqc.getTo().getLocalpart();
                if (!this.getName().equals(nick)) {
                    return;
                }
                Command.Action action = Command.getAction(iqc);
                if (action == Command.Action.cancel) {
                    Packet result = iqc.commandResult(null);
                    results.offer(result);
                    return;
                }
                String tmp_val = Command.getFieldValue(iqc, "Stats level");
                if (tmp_val != null) {
                    this.statsLevel = Level.parse(tmp_val);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("statsLevel parsed to: " + this.statsLevel.getName());
                    }
                }
                StatisticsList list = new StatisticsList(this.statsLevel);
                if (iqc.getStrCommand().equals("stats")) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Getting all stats for level: " + this.statsLevel.getName());
                    }
                    this.getAllStats(list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("All stats for level loaded: " + this.statsLevel.getName());
                    }
                } else {
                    String[] spl = iqc.getStrCommand().split("/");
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Getting stats for component: " + spl[1] + ", level: " + this.statsLevel.getName());
                    }
                    this.getComponentStats(spl[1], list);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Stats loaded for component: " + spl[1] + ", level: " + this.statsLevel.getName());
                    }
                }
                Packet result = iqc.commandResult(Command.DataType.form);
                if (list != null) {
                    for (StatRecord rec : list) {
                        if (rec.getType() == StatisticType.LIST) {
                            Command.addFieldMultiValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), rec.getListValue());
                            continue;
                        }
                        Command.addFieldValue(result, XMLUtils.escape((String)(rec.getComponent() + "/" + rec.getDescription())), XMLUtils.escape((String)rec.getValue()));
                    }
                }
                Command.addFieldValue(result, "Stats level", this.statsLevel.getName(), "Stats level", new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()}, new String[]{Level.INFO.getName(), Level.FINE.getName(), Level.FINER.getName(), Level.FINEST.getName()});
                results.offer(result);
                if (!log.isLoggable(Level.FINEST)) break;
                log.finest("Returning stats result: " + result);
                break;
            }
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.serviceEntity = new ServiceEntity(name, "stats", "Server statistics");
        this.serviceEntity.addIdentities(new ServiceIdentity("component", "stats", "Server statistics"), new ServiceIdentity("automation", "command-node", "All statistics"), new ServiceIdentity("automation", "command-list", "Statistics retrieving commands"));
        this.serviceEntity.addFeatures(DEF_FEATURES);
        this.serviceEntity.addFeatures(CMD_FEATURES);
        try {
            StatisticsProvider sp = new StatisticsProvider(this);
            String objName = STATISTICS_MBEAN_NAME;
            ObjectName on = new ObjectName(objName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(sp, on);
            ConfiguratorAbstract.putMXBean(objName, sp);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Can not install Statistics MXBean: ", ex);
        }
        TigaseRuntime.getTigaseRuntime().addShutdownHook(this);
    }

    @Override
    public String shutdown() {
        StatisticsList allStats = this.getAllStats();
        StringBuilder sb = new StringBuilder();
        for (StatRecord statRecord : allStats) {
            sb.append(statRecord.toString()).append('\n');
        }
        return sb.toString();
    }

    protected void statsUpdated() {
    }
}

