/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppsession;

import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class PacketFilter {
    private static final Logger log = Logger.getLogger("tigase.server.xmppsession.PacketFilter");
    private static TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
    private String[] AUTH_ONLY_ELEMS = new String[]{"message", "presence"};
    private String[] IGNORE_PACKETS = new String[]{"stream:features"};
    private StanzaType[] IGNORE_TYPES = new StanzaType[]{StanzaType.error};

    public boolean forward(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        return false;
    }

    public boolean preprocess(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        block18: {
            for (int i = 0; i < this.IGNORE_PACKETS.length; ++i) {
                if (packet.getElemName() != this.IGNORE_PACKETS[i] || packet.getType() != this.IGNORE_TYPES[i]) continue;
                return true;
            }
            if (session == null) {
                return false;
            }
            try {
                if (!session.getConnectionId().equals((Object)packet.getFrom())) break block18;
                if (!session.isAuthorized()) {
                    for (String elem : this.AUTH_ONLY_ELEMS) {
                        if (packet.getElemName() != elem) continue;
                        results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authenticate session first, before you can send any message or presence packet.", true));
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Packet received before the session has been authenticated.Session details: connectionId=" + session.getConnectionId() + ", sessionId=" + session.getSessionId() + ", ConnectionStatus=" + (Object)((Object)session.getConnectionStatus()) + ", packet=" + packet.toStringSecure());
                        }
                        return true;
                    }
                    return false;
                }
                if (session.isResourceSet() || packet.isXMLNS("/iq/bind", "urn:ietf:params:xml:ns:xmpp-bind") || packet.isXMLNS("compress", "http://jabber.org/protocol/compress")) {
                    JID from_jid = session.getJID();
                    if (from_jid != null) {
                        if (packet.getStanzaFrom() == null || !from_jid.getBareJID().equals((Object)packet.getStanzaFrom().getBareJID())) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Setting correct from attribute: " + from_jid);
                            }
                            packet.initVars(from_jid, packet.getStanzaTo());
                        } else if (log.isLoggable(Level.FINEST)) {
                            log.finest("Skipping setting correct from attribute: " + from_jid + ", is already correct.");
                        }
                    } else {
                        log.warning("Session is authenticated but session.getJid() is empty: " + packet.toStringSecure());
                    }
                    break block18;
                }
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must bind the resource first: http://www.xmpp.org/rfcs/rfc3920.html#bind", true));
                if (log.isLoggable(Level.INFO)) {
                    log.info("Session details: connectionId=" + session.getConnectionId() + ", sessionId=" + session.getSessionId() + ", ConnectionStatus=" + (Object)((Object)session.getConnectionStatus()));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Session more detais: JID=" + session.getjid());
                }
                return true;
            }
            catch (PacketErrorTypeException e) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Ignoring packet with an error to non-existen user session: " + packet.toStringSecure());
                }
            }
            catch (Exception e) {
                log.log(Level.FINEST, "Packet preprocessing exception: ", e);
                return false;
            }
        }
        return false;
    }

    public boolean process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session == null) {
            return false;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toStringSecure());
        }
        try {
            if (packet.getStanzaTo() == null) {
                if (packet.getElemName().equals("iq") && packet.getType() == StanzaType.result) {
                    return true;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("No 'to' address, can't deliver packet: " + packet.toString());
                }
                return false;
            }
            JID to = packet.getStanzaTo();
            if (session.isUserId(to.getBareJID())) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Yes, this is packet to 'this' client: " + to);
                }
                Packet result = packet.copyElementOnly();
                result.setPacketFrom(packet.getTo());
                try {
                    result.setPacketTo(session.getConnectionId(packet.getStanzaTo()));
                    results.offer(result);
                }
                catch (NoConnectionIdException ex) {
                    log.warning("Packet to the server which hasn't been properly processed: " + packet);
                }
                return true;
            }
            BareJID from = packet.getStanzaFrom().getBareJID();
            if (session.isUserId(from)) {
                Packet result = packet.copyElementOnly();
                results.offer(result);
                return true;
            }
        }
        catch (NotAuthorizedException e) {
            try {
                results.offer(Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You must authorize session first.", true));
                log.info("NotAuthorizedException for packet: " + packet.toString());
            }
            catch (PacketErrorTypeException e2) {
                log.info("Packet processing exception: " + e2);
            }
        }
        return false;
    }
}

