/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.xmppclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.net.SocketReadThread;
import tigase.server.Command;
import tigase.server.ConnectionManager;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.server.xmppclient.IPMonitor;
import tigase.util.DNSResolver;
import tigase.util.RoutingsContainer;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPIOService;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;

public class ClientConnectionManager
extends ConnectionManager<XMPPIOService<Object>> {
    private static final Logger log = Logger.getLogger(ClientConnectionManager.class.getName());
    private static final String XMLNS = "jabber:client";
    private static final String ROUTINGS_PROP_KEY = "routings";
    private static final String ROUTING_MODE_PROP_KEY = "multi-mode";
    private static final boolean ROUTING_MODE_PROP_VAL = true;
    private static final String ROUTING_ENTRY_PROP_KEY = ".+";
    protected RoutingsContainer routings = null;
    private Map<String, XMPPProcessorIfc> processors = new ConcurrentHashMap<String, XMPPProcessorIfc>();
    private ReceiverTimeoutHandler stoppedHandler = this.newStoppedHandler();
    private ReceiverTimeoutHandler startedHandler = this.newStartedHandler();
    private IPMonitor ipMonitor = new IPMonitor();

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        Boolean r_mode = (Boolean)params.get(this.getName() + "/" + ROUTINGS_PROP_KEY + "/" + ROUTING_MODE_PROP_KEY);
        if (r_mode == null) {
            props.put("routings/multi-mode", true);
            if (params.get("config-type").equals("--gen-config-cs") && params.get("--ext-comp") != null) {
                String[] comp_params = ((String)params.get("--ext-comp")).split(",");
                props.put("routings/.+", "sess-man@" + comp_params[1]);
            } else {
                props.put("routings/.+", "sess-man@" + DNSResolver.getDefaultHostname());
            }
        }
        return props;
    }

    @Override
    public String getDiscoCategoryType() {
        return "c2s";
    }

    @Override
    public String getDiscoDescription() {
        return "Client connection manager";
    }

    @Override
    public int hashCodeForPacket(Packet packet) {
        return packet.getTo().hashCode();
    }

    @Override
    public void processPacket(Packet packet) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Processing packet: " + packet.getElemName() + ", type: " + (Object)((Object)packet.getType()));
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toStringSecure());
        }
        if (packet.isCommand() && packet.getCommand() != Command.OTHER) {
            this.processCommand(packet);
        } else if (!this.writePacketToSocket(packet)) {
            block9: {
                if (packet.getType() != StanzaType.result && packet.getType() != StanzaType.available && packet.getType() != StanzaType.unavailable && packet.getType() != StanzaType.error && (packet.getElemName() != "presence" || packet.getType() != null)) {
                    try {
                        Packet error = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, "The user connection is no longer active.", true);
                        this.addOutPacket(error);
                    }
                    catch (PacketErrorTypeException e) {
                        if (!log.isLoggable(Level.FINEST)) break block9;
                        log.finest("Ups, already error packet. Dropping it to prevent infinite loop.");
                    }
                }
            }
            if (packet.getType() != StanzaType.unavailable) {
                Packet command2 = Command.STREAM_CLOSED_UPDATE.getPacket(null, null, StanzaType.set, UUID.randomUUID().toString());
                command2.setPacketFrom(packet.getTo());
                command2.setPacketTo(packet.getFrom());
                this.addOutPacket(command2);
                log.fine("Sending a command to close the remote session for non-existen Bosh connection: " + command2.toStringSecure());
            }
        }
    }

    @Override
    public Queue<Packet> processSocketData(XMPPIOService<Object> serv) {
        String id = this.getUniqueId(serv);
        Packet p = null;
        while ((p = serv.getReceivedPackets().poll()) != null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Processing packet: " + p.getElemName() + ", type: " + (Object)((Object)p.getType()));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing socket data: " + p.toStringSecure());
            }
            p.setPacketFrom(this.getFromAddress(id));
            JID receiver = serv.getDataReceiver();
            if (receiver == null) continue;
            p.setPacketTo(serv.getDataReceiver());
            this.addOutPacket(p);
        }
        return null;
    }

    @Override
    public int processingThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public boolean serviceStopped(XMPPIOService<Object> service) {
        boolean result = super.serviceStopped(service);
        if (service.getXMLNS() == XMLNS && result) {
            this.ipMonitor.addDisconnect(service.getRemoteAddress());
            if (service.getDataReceiver() != null) {
                Packet command2 = Command.STREAM_CLOSED.getPacket(this.getFromAddress(this.getUniqueId(service)), service.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString());
                this.addOutPacketWithTimeout(command2, this.stoppedHandler, 120L, TimeUnit.SECONDS);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Service stopped, sending packet: " + command2);
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("Service stopped, before stream:stream received");
            }
        }
        return result;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        boolean routing_mode = (Boolean)props.get("routings/multi-mode");
        this.routings = new RoutingsContainer(routing_mode);
        int idx = "routings/".length();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            if (!entry.getKey().startsWith("routings/") || entry.getKey().equals("routings/multi-mode")) continue;
            this.routings.addRouting(entry.getKey().substring(idx), (String)entry.getValue());
        }
    }

    @Override
    public void start() {
        super.start();
        this.ipMonitor = new IPMonitor();
        this.ipMonitor.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.ipMonitor.stopThread();
    }

    @Override
    public void xmppStreamClosed(XMPPIOService<Object> serv) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream closed: " + serv.getUniqueId());
        }
    }

    @Override
    public String xmppStreamOpened(XMPPIOService<Object> serv, Map<String, String> attribs) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Stream opened: " + attribs.toString());
        }
        String hostname = attribs.get("to");
        String lang = attribs.get("xml:lang");
        if (lang == null) {
            lang = "en";
        }
        if (hostname == null) {
            return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefHostName() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<improper-addressing xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        if (!this.isLocalDomain(hostname)) {
            return "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' id='tigase-error-tigase' from='" + this.getDefHostName() + "'" + " version='1.0' xml:lang='en'>" + "<stream:error>" + "<host-unknown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/>" + "</stream:error>" + "</stream:stream>";
        }
        String id = (String)serv.getSessionData().get("sessionID");
        if (id == null) {
            id = UUID.randomUUID().toString();
            serv.getSessionData().put("sessionID", id);
            serv.setXMLNS(XMLNS);
            serv.getSessionData().put("hostname-key", hostname);
            serv.setDataReceiver(JID.jidInstanceNS((String)this.routings.computeRouting(hostname)));
            this.writeRawData(serv, "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + " version='1.0' xml:lang='en'>");
            Packet streamOpen = Command.STREAM_OPENED.getPacket(this.getFromAddress(this.getUniqueId(serv)), serv.getDataReceiver(), StanzaType.set, UUID.randomUUID().toString(), Command.DataType.submit);
            Command.addFieldValue(streamOpen, "session-id", id);
            Command.addFieldValue(streamOpen, "hostname", hostname);
            Command.addFieldValue(streamOpen, "xml:lang", lang);
            this.addOutPacketWithTimeout(streamOpen, this.startedHandler, 45L, TimeUnit.SECONDS);
        } else {
            this.writeRawData(serv, "<?xml version='1.0'?><stream:stream xmlns='jabber:client' xmlns:stream='http://etherx.jabber.org/streams' from='" + hostname + "'" + " id='" + id + "'" + " version='1.0' xml:lang='en'>");
            this.addOutPacket(Command.GETFEATURES.getPacket(this.getFromAddress(this.getUniqueId(serv)), serv.getDataReceiver(), StanzaType.get, UUID.randomUUID().toString(), null));
        }
        return null;
    }

    protected JID changeDataReceiver(Packet packet, JID newAddress, String command_sessionId, XMPPIOService<Object> serv) {
        if (serv != null) {
            String serv_sessionId = (String)serv.getSessionData().get("sessionID");
            if (serv_sessionId.equals(command_sessionId)) {
                JID old_receiver = serv.getDataReceiver();
                serv.setDataReceiver(newAddress);
                return old_receiver;
            }
            log.warning("Incorrect session ID, ignoring data redirect for: " + newAddress + ", expected: " + serv_sessionId + ", received: " + command_sessionId);
        }
        return null;
    }

    @Override
    protected int[] getDefPlainPorts() {
        return new int[]{5222};
    }

    @Override
    protected int[] getDefSSLPorts() {
        return new int[]{5223};
    }

    @Override
    protected long getMaxInactiveTime() {
        return 86400000L;
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    @Override
    protected XMPPIOService<Object> getXMPPIOServiceInstance() {
        return new XMPPIOService<Object>();
    }

    protected ReceiverTimeoutHandler newStartedHandler() {
        return new StartedHandler();
    }

    protected ReceiverTimeoutHandler newStoppedHandler() {
        return new StoppedHandler();
    }

    protected void processCommand(Packet packet) {
        Object serv = this.getXMPPIOService(packet);
        Iq iqc = (Iq)packet;
        switch (iqc.getCommand()) {
            case GETFEATURES: {
                if (iqc.getType() != StanzaType.result) break;
                List<Element> features = this.getFeatures(this.getXMPPSession(iqc));
                Element elem_features = new Element("stream:features");
                elem_features.addChildren(features);
                elem_features.addChildren(Command.getData(iqc));
                Packet result = Packet.packetInstance(elem_features, null, null);
                result.setPacketTo(iqc.getTo());
                this.writePacketToSocket(result);
                break;
            }
            case STARTZLIB: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Starting zlib compression: " + ((IOService)serv).getUniqueId());
                    }
                    try {
                        Element compressed = Command.getData(iqc, "compressed", null);
                        Packet p_compressed = Packet.packetInstance(compressed, null, null);
                        SocketReadThread readThread = SocketReadThread.getInstance();
                        readThread.removeSocketService((IOService)serv);
                        ((XMPPIOService)serv).addPacketToSend(p_compressed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        ((IOService)serv).startZLib(9);
                        readThread.addSocketService((IOService)serv);
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Problem enabling zlib compression on the connection: ", ex);
                    }
                    break;
                }
                log.warning("Can't find sevice for STARTZLIB command: " + iqc);
                break;
            }
            case STARTTLS: {
                if (serv != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("Starting TLS for connection: " + ((IOService)serv).getUniqueId());
                    }
                    try {
                        Element proceed = Command.getData(iqc, "proceed", null);
                        Packet p_proceed = Packet.packetInstance(proceed, null, null);
                        SocketReadThread readThread = SocketReadThread.getInstance();
                        readThread.removeSocketService((IOService)serv);
                        ((XMPPIOService)serv).addPacketToSend(p_proceed);
                        ((XMPPIOService)serv).processWaitingPackets();
                        while (((IOService)serv).waitingToSend()) {
                            ((XMPPIOService)serv).writeRawData(null);
                            Thread.sleep(10L);
                        }
                        ((IOService)serv).startTLS(false);
                        readThread.addSocketService((IOService)serv);
                    }
                    catch (Exception e) {
                        log.warning("Error starting TLS: " + e);
                        ((IOService)serv).forceStop();
                    }
                    break;
                }
                log.warning("Can't find sevice for STARTTLS command: " + iqc);
                break;
            }
            case REDIRECT: {
                String command_sessionId = Command.getFieldValue(iqc, "session-id");
                JID newAddress = iqc.getFrom();
                JID old_receiver = this.changeDataReceiver(iqc, newAddress, command_sessionId, (XMPPIOService<Object>)serv);
                if (old_receiver != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Redirecting data for sessionId: " + command_sessionId + ", to: " + newAddress);
                    }
                    Packet response = null;
                    response = iqc.commandResult(null);
                    Command.addFieldValue(response, "session-id", command_sessionId);
                    Command.addFieldValue(response, "action", "activate");
                    response.getElement().setAttribute("to", newAddress.toString());
                    this.addOutPacket(response);
                    break;
                }
                if (!log.isLoggable(Level.FINEST)) break;
                log.finest("Connection for REDIRECT command does not exist, ignoring packet: " + iqc.toStringSecure());
                break;
            }
            case STREAM_CLOSED: {
                break;
            }
            case GETDISCO: {
                break;
            }
            case CLOSE: {
                if (serv != null) {
                    try {
                        ((XMPPIOService)serv).writeRawData("</stream:stream>");
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ((XMPPIOService)serv).stop();
                    break;
                }
                if (!log.isLoggable(Level.FINE)) break;
                log.fine("Attempt to stop non-existen service for packet: " + iqc + ", Service already stopped?");
                break;
            }
            case CHECK_USER_CONNECTION: {
                if (serv != null) {
                    this.addOutPacket(iqc.okResult((String)null, 0));
                    break;
                }
                try {
                    this.addOutPacket(Authorization.ITEM_NOT_FOUND.getResponseMessage(iqc, "Connection gone.", false));
                }
                catch (PacketErrorTypeException e) {
                    log.info("Error packet is not really expected here: " + iqc.toStringSecure());
                }
                break;
            }
            default: {
                this.writePacketToSocket(iqc);
            }
        }
    }

    private List<Element> getFeatures(XMPPResourceConnection session) {
        LinkedList<Element> results = new LinkedList<Element>();
        for (XMPPProcessorIfc proc : this.processors.values()) {
            Element[] features = proc.supStreamFeatures(session);
            if (features == null) continue;
            results.addAll(Arrays.asList(features));
        }
        return results;
    }

    private JID getFromAddress(String id) {
        return JID.jidInstanceNS((String)this.getName(), (String)this.getDefHostName(), (String)id);
    }

    private XMPPResourceConnection getXMPPSession(Packet p) {
        Object serv = this.getXMPPIOService(p);
        return serv == null ? null : (XMPPResourceConnection)((IOService)serv).getSessionData().get("xmpp-session");
    }

    private class StoppedHandler
    implements ReceiverTimeoutHandler {
        private StoppedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Response for stop received...");
            }
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.info("No response within time limit received for a packet: " + packet.toStringSecure());
            ClientConnectionManager.this.addOutPacketWithTimeout(packet, ClientConnectionManager.this.stoppedHandler, 60L, TimeUnit.SECONDS);
        }
    }

    private class StartedHandler
    implements ReceiverTimeoutHandler {
        private StartedHandler() {
        }

        @Override
        public void responseReceived(Packet packet, Packet response) {
            ClientConnectionManager.this.addOutPacket(Command.GETFEATURES.getPacket(packet.getFrom(), packet.getTo(), StanzaType.get, UUID.randomUUID().toString(), null));
        }

        @Override
        public void timeOutExpired(Packet packet) {
            log.info("No response within time limit received for a packet: " + packet.toStringSecure());
            XMPPIOService serv = ClientConnectionManager.this.getXMPPIOService(packet.getFrom().toString());
            if (serv != null) {
                serv.stop();
            } else {
                log.fine("Attempt to stop non-existen service for packet: " + packet + ", Service already stopped?");
            }
        }
    }
}

