/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.filters;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.QueueType;
import tigase.stats.StatisticsList;

public class PacketCounter
implements PacketFilterIfc {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private QueueType qType = null;
    private String name = null;
    private long msgCounter = 0L;
    private long presCounter = 0L;
    private ConcurrentHashMap<String, Integer> iqCounterIdx = new ConcurrentHashMap();
    private long[] iqCounters = new long[1];
    private int lastNodeNo = -1;

    @Override
    public Packet filter(Packet packet) {
        if (packet.getElemName() == "message") {
            ++this.msgCounter;
        }
        if (packet.getElemName() == "presence") {
            ++this.presCounter;
        }
        if (packet.getElemName() == "iq") {
            String xmlns = ((Iq)packet).getIQXMLNS();
            this.incIQCounter(xmlns != null ? xmlns : ((Iq)packet).getIQChildName());
        }
        return packet;
    }

    private synchronized void incIQCounter(String xmlns) {
        if (xmlns == null) {
            this.iqCounters[0] = this.iqCounters[0] + 1L;
        } else {
            Integer idx = this.iqCounterIdx.get(xmlns);
            if (idx == null) {
                this.iqCounters = Arrays.copyOf(this.iqCounters, this.iqCounters.length + 1);
                idx = this.iqCounters.length - 1;
                this.iqCounterIdx.put(xmlns, idx);
            }
            int n = idx;
            this.iqCounters[n] = this.iqCounters[n] + 1L;
        }
    }

    @Override
    public void init(String name, QueueType qType) {
        this.name = name;
        this.qType = qType;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.name, this.qType.name() + " messages", this.msgCounter, Level.FINER);
        list.add(this.name, this.qType.name() + " presences", this.presCounter, Level.FINER);
        list.add(this.name, this.qType.name() + " IQ no XMLNS", this.iqCounters[0], Level.FINEST);
        for (Map.Entry<String, Integer> iqCounter : this.iqCounterIdx.entrySet()) {
            list.add(this.name, this.qType.name() + " IQ " + iqCounter.getKey(), this.iqCounters[iqCounter.getValue()], Level.FINEST);
        }
    }
}

