/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.ext;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.ComponentRepository;
import tigase.server.ext.CompConfigRepository;
import tigase.server.ext.CompRepoItem;
import tigase.util.JDBCAbstract;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class CompSQLRepository
extends JDBCAbstract
implements ComponentRepository<CompRepoItem> {
    private static final Logger log = Logger.getLogger(CompSQLRepository.class.getName());
    public static final String REPO_URI_PROP_KEY = "repo-uri";
    public static final String TABLE_NAME = "external_component";
    private static final String DOMAIN_COLUMN = "domain";
    private static final String PASSWORD_COLUMN = "password";
    private static final String CONNECTION_TYPE_COLUMN = "connection_type";
    private static final String PORT_COLUMN = "port";
    private static final String REMOTE_DOMAIN_COLUMN = "remote_domain";
    private static final String PROTOCOL_COLUMN = "protocol";
    private static final String OTHER_DATA_COLUMN = "other_data";
    private static final String CREATE_TABLE_QUERY = "create table external_component (  domain varchar(512) NOT NULL,  password varchar(255) NOT NULL,  connection_type varchar(127),  port int,  remote_domain varchar(1023),  protocol varchar(127),  other_data varchar(32672),  primary key(domain))";
    private static final String CHECK_TABLE_QUERY = "select count(*) from external_component";
    private static final String GET_ITEM_QUERY = "select * from external_component where domain = ?";
    private static final String ADD_ITEM_QUERY = "insert into external_component (domain, password, connection_type, port, remote_domain, protocol, other_data)  values (?, ?, ?, ?, ?, ?, ?)";
    private static final String DELETE_ITEM_QUERY = "delete from external_component where (domain = ?)";
    private static final String GET_ALL_ITEMS_QUERY = "select * from external_component";
    private String tableName = "external_component";
    private PreparedStatement createTableSt = null;
    private PreparedStatement checkTableSt = null;
    private PreparedStatement getItemSt = null;
    private PreparedStatement getAllItemsSt = null;
    private PreparedStatement addItemSt = null;
    private PreparedStatement deleteItemSt = null;
    private CompConfigRepository configRepo = new CompConfigRepository();

    public void initRepository(String conn_str, Map<String, String> params) throws SQLException {
        this.setResourceUri(conn_str);
        this.checkConnection();
        this.checkDB();
    }

    @Override
    public void getDefaults(Map<String, Object> defs, Map<String, Object> params) {
        this.configRepo.getDefaults(defs, params);
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        defs.put(REPO_URI_PROP_KEY, repo_uri);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.configRepo.setProperties(properties);
        String repo_uri = (String)properties.get(REPO_URI_PROP_KEY);
        try {
            this.initRepository(repo_uri, null);
        }
        catch (SQLException ex) {
            try {
                this.initializeDB();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Propblem creating database.", e);
            }
            log.log(Level.WARNING, "Problem initializing database.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(String key) {
        this.configRepo.removeItem(key);
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.deleteItemSt;
            synchronized (preparedStatement) {
                this.deleteItemSt.setString(1, key);
                this.deleteItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Can't remove item: " + key, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItem(CompRepoItem item) {
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.addItemSt;
            synchronized (preparedStatement) {
                if (item.getDomain() == null || item.getDomain().isEmpty()) {
                    throw new NullPointerException("Null or empty domain name is not allowed");
                }
                this.addItemSt.setString(1, item.getDomain());
                if (item.getAuthPasswd() == null) {
                    throw new NullPointerException("Null password is not allowed");
                }
                this.addItemSt.setString(2, item.getAuthPasswd());
                if (item.getConnectionType() != null) {
                    this.addItemSt.setString(3, item.getConnectionType().name());
                } else {
                    this.addItemSt.setNull(3, 12);
                }
                if (item.getPort() > 0) {
                    this.addItemSt.setInt(4, item.getPort());
                } else {
                    this.addItemSt.setNull(4, 4);
                }
                if (item.getRemoteHost() != null && !item.getRemoteHost().isEmpty()) {
                    this.addItemSt.setString(5, item.getRemoteHost());
                } else {
                    this.addItemSt.setNull(5, 12);
                }
                if (item.getXMLNS() != null) {
                    this.addItemSt.setString(6, item.getXMLNS());
                } else {
                    this.addItemSt.setNull(6, 12);
                }
                String other_data = item.toElement().toString();
                if (other_data != null) {
                    this.addItemSt.setString(7, other_data);
                } else {
                    this.addItemSt.setNull(7, 12);
                }
                this.addItemSt.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem adding a new item to DB: " + item.toElement(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompRepoItem getItem(String key) {
        CompRepoItem result = (CompRepoItem)this.configRepo.getItem(key);
        if (result == null) {
            ResultSet rs = null;
            try {
                this.checkConnection();
                PreparedStatement preparedStatement = this.getItemSt;
                synchronized (preparedStatement) {
                    this.getItemSt.setString(1, key);
                    rs = this.getItemSt.executeQuery();
                    if (rs.next()) {
                        result = this.createItemFromRS(rs);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    log.log(Level.WARNING, "Problem getting element from DB for domain: " + key, e);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
                this.release(null, rs);
            }
            this.release(null, rs);
        }
        return result;
    }

    private CompRepoItem createItemFromRS(ResultSet rs) throws SQLException {
        String connection_type;
        String protocol;
        String remote_domain;
        int port;
        String password;
        String domain;
        Element elem_item;
        CompRepoItem result = this.getItemInstance();
        String other = rs.getString(OTHER_DATA_COLUMN);
        if (other != null && !other.isEmpty() && (elem_item = this.parseElement(other)) != null) {
            result.initFromElement(elem_item);
        }
        if ((domain = rs.getString(DOMAIN_COLUMN)) != null && !domain.isEmpty()) {
            result.setDomain(domain);
        }
        if ((password = rs.getString(PASSWORD_COLUMN)) != null && !password.isEmpty()) {
            result.setPassword(password);
        }
        if ((port = rs.getInt(PORT_COLUMN)) > 0) {
            result.setPort(port);
        }
        if ((remote_domain = rs.getString(REMOTE_DOMAIN_COLUMN)) != null && !remote_domain.isEmpty()) {
            result.setRemoteDomain(remote_domain);
        }
        if ((protocol = rs.getString(PROTOCOL_COLUMN)) != null && !protocol.isEmpty()) {
            result.setProtocol(protocol);
        }
        if ((connection_type = rs.getString(CONNECTION_TYPE_COLUMN)) != null && !connection_type.isEmpty()) {
            result.setConnectionType(connection_type);
        }
        return result;
    }

    private Element parseElement(String data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        SimpleParser parser = SingletonFactory.getParserInstance();
        parser.parse((SimpleHandler)domHandler, data.toCharArray(), 0, data.length());
        Queue elems = domHandler.getParsedElements();
        if (elems != null && elems.size() > 0) {
            return (Element)elems.poll();
        }
        return null;
    }

    @Override
    public boolean contains(String key) {
        boolean result = this.configRepo.contains(key);
        return result;
    }

    @Override
    public void reload() {
    }

    @Override
    public void store() {
    }

    @Override
    public int size() {
        int result = this.configRepo.size();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CompRepoItem> allItems() {
        ArrayList<CompRepoItem> result = new ArrayList<CompRepoItem>();
        result.addAll(this.configRepo.allItems());
        ResultSet rs = null;
        try {
            this.checkConnection();
            PreparedStatement preparedStatement = this.getAllItemsSt;
            synchronized (preparedStatement) {
                rs = this.getAllItemsSt.executeQuery();
                while (rs.next()) {
                    result.add(this.createItemFromRS(rs));
                }
            }
            this.release(null, rs);
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem getting elements from DB: ", e);
        }
        finally {
            this.release(null, rs);
        }
        return result;
    }

    @Override
    public CompRepoItem getItemInstance() {
        return this.configRepo.getItemInstance();
    }

    @Override
    public Iterator<CompRepoItem> iterator() {
        return this.allItems().iterator();
    }

    protected void initPreparedStatements() throws SQLException {
        super.initPreparedStatements();
        this.checkTableSt = this.prepareStatement(CHECK_TABLE_QUERY);
        this.getItemSt = this.prepareStatement(GET_ITEM_QUERY);
        this.getAllItemsSt = this.prepareStatement(GET_ALL_ITEMS_QUERY);
        this.addItemSt = this.prepareStatement(ADD_ITEM_QUERY);
        this.deleteItemSt = this.prepareStatement(DELETE_ITEM_QUERY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDB() throws SQLException {
        ResultSet rs = null;
        try {
            rs = this.checkTableSt.executeQuery();
            if (rs.next()) {
                long count = rs.getLong(1);
                log.info("DB for external component OK, items: " + count);
            }
        }
        catch (Exception e) {
            this.initializeDB();
        }
        finally {
            this.release(null, rs);
            rs = null;
        }
    }

    private void initializeDB() throws SQLException {
        this.createTableSt = this.prepareStatement(CREATE_TABLE_QUERY);
        log.info("DB for external component is not OK, creating missing tables...");
        this.createTableSt.executeUpdate();
        log.info("DB for external component created OK");
    }
}

