/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import tigase.server.ComponentRegistrator;
import tigase.server.ServerComponent;
import tigase.util.DNSResolver;

public class MessageRouterConfig {
    private static final Logger log = Logger.getLogger("tigase.server.MessageRouterConfig");
    public static final String LOCAL_ADDRESSES_PROP_KEY = "hostnames";
    private static String[] LOCAL_ADDRESSES_PROP_VALUE = new String[]{"localhost", "hostname"};
    public static final String MSG_RECEIVERS_PROP_KEY = "components/msg-receivers/";
    public static final String MSG_RECEIVERS_NAMES_PROP_KEY = "components/msg-receivers/id-names";
    private static final String[] ALL_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "ssend", "srecv", "bosh"};
    private static final String[] DEF_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "sess-man", "bosh"};
    private static final String[] SM_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"ext-comp", "sess-man"};
    private static final String[] CS_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"c2s", "s2s", "ext-comp", "bosh"};
    private static final String[] COMP_MSG_RECEIVERS_NAMES_PROP_VAL = new String[]{"ext"};
    private static final Map<String, String> COMPONENT_CLASSES = new LinkedHashMap<String, String>();
    private static final Map<String, String> COMP_CLUS_MAP = new LinkedHashMap<String, String>();
    public static final String REGISTRATOR_PROP_KEY = "components/registrators/";
    public static final String REGISTRATOR_NAMES_PROP_KEY = "components/registrators/id-names";
    private static final String[] DEF_REGISTRATOR_NAMES_PROP_VAL;
    private static final String[] CLUSTER_REGISTRATOR_NAMES_PROP_VAL;
    public static final String DISCO_NAME_PROP_KEY = "disco-name";
    public static final String DISCO_NAME_PROP_VAL = "Tigase";
    public static final String DISCO_SHOW_VERSION_PROP_KEY = "disco-show-version";
    public static final boolean DISCO_SHOW_VERSION_PROP_VAL = true;
    public static final String UPDATES_CHECKING_PROP_KEY = "updates-checking";
    public static final Boolean UPDATES_CHECKING_PROP_VAL;
    public static final String UPDATES_CHECKING_INTERVAL_PROP_KEY = "updates-checking-interval";
    public static final long UPDATES_CHECKING_INTERVAL_PROP_VAL = 7L;
    private Map<String, Object> props = null;

    public static void getDefaults(Map<String, Object> defs, Map<String, Object> params, String comp_name) {
        boolean cluster_mode = MessageRouterConfig.isTrue((String)params.get("--cluster-mode"));
        log.config("Cluster mode: " + params.get("--cluster-mode"));
        if (cluster_mode) {
            log.config("Cluster mode is on, replacing known components with cluster versions:");
            for (Map.Entry<String, String> entry : COMPONENT_CLASSES.entrySet()) {
                String cls = COMP_CLUS_MAP.get(entry.getValue());
                if (cls == null) continue;
                log.config("Replacing " + entry.getValue() + " with " + cls);
                entry.setValue(cls);
            }
        } else {
            log.config("Cluster mode is off.");
        }
        String config_type = (String)params.get("config-type");
        Object[] rcv_names = DEF_MSG_RECEIVERS_NAMES_PROP_VAL;
        Object par_names = params.get(comp_name + "/" + MSG_RECEIVERS_NAMES_PROP_KEY);
        if (par_names != null) {
            rcv_names = (String[])par_names;
        } else {
            if (config_type.equals("--gen-config-all")) {
                rcv_names = ALL_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-sm")) {
                rcv_names = SM_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-cs")) {
                rcv_names = CS_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
            if (config_type.equals("--gen-config-comp")) {
                rcv_names = COMP_MSG_RECEIVERS_NAMES_PROP_VAL;
            }
        }
        Arrays.sort(rcv_names);
        for (String key : params.keySet()) {
            String new_comp_name;
            if (key.startsWith("--ext-comp") && Arrays.binarySearch(rcv_names, new_comp_name = "ext-comp" + key.substring("--ext-comp".length())) < 0) {
                rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
                rcv_names[rcv_names.length - 1] = new_comp_name;
                Arrays.sort(rcv_names);
            }
            if (!key.startsWith("--comp-name")) continue;
            String comp_name_suffix = key.substring("--comp-name".length());
            String c_name = (String)params.get("--comp-name" + comp_name_suffix);
            String c_class = (String)params.get("--comp-class" + comp_name_suffix);
            if (Arrays.binarySearch(rcv_names, c_name) >= 0) continue;
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".class", c_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + c_name + ".active", true);
            rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
            rcv_names[rcv_names.length - 1] = c_name;
            Arrays.sort(rcv_names);
        }
        if (cluster_mode) {
            log.config("In cluster mode I am setting up 1 listening xep-0114 component:");
            if (Arrays.binarySearch(rcv_names, "cl-comp") < 0) {
                defs.put("components/msg-receivers/cl-comp.class", "tigase.cluster.ClusterConnectionManager");
                defs.put("components/msg-receivers/cl-comp.active", true);
                rcv_names = (String[])Arrays.copyOf(rcv_names, rcv_names.length + 1);
                rcv_names[rcv_names.length - 1] = "cl-comp";
                Arrays.sort(rcv_names);
            }
        }
        defs.put(MSG_RECEIVERS_NAMES_PROP_KEY, rcv_names);
        for (Object name : rcv_names) {
            if (defs.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".class") != null) continue;
            String def_class = COMPONENT_CLASSES.get(name);
            if (def_class == null) {
                def_class = "tigase.server.xmppcomponent.ComponentConnectionManager";
            }
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".class", def_class);
            defs.put(MSG_RECEIVERS_PROP_KEY + (String)name + ".active", true);
        }
        String[] registr = DEF_REGISTRATOR_NAMES_PROP_VAL;
        if (cluster_mode) {
            registr = CLUSTER_REGISTRATOR_NAMES_PROP_VAL;
        }
        defs.put(REGISTRATOR_NAMES_PROP_KEY, registr);
        for (String reg : registr) {
            defs.put(REGISTRATOR_PROP_KEY + reg + ".class", COMPONENT_CLASSES.get(reg));
            defs.put(REGISTRATOR_PROP_KEY + reg + ".active", true);
        }
        LOCAL_ADDRESSES_PROP_VALUE = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        defs.put(LOCAL_ADDRESSES_PROP_KEY, LOCAL_ADDRESSES_PROP_VALUE);
        defs.put(DISCO_NAME_PROP_KEY, DISCO_NAME_PROP_VAL);
        defs.put(DISCO_SHOW_VERSION_PROP_KEY, true);
        defs.put(UPDATES_CHECKING_PROP_KEY, UPDATES_CHECKING_PROP_VAL);
        defs.put(UPDATES_CHECKING_INTERVAL_PROP_KEY, 7L);
    }

    public MessageRouterConfig(Map<String, Object> props) {
        this.props = props;
    }

    public String[] getRegistrNames() {
        Object[] names = (String[])this.props.get(REGISTRATOR_NAMES_PROP_KEY);
        log.config(Arrays.toString(names));
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object name : names) {
            if (!((Boolean)this.props.get(REGISTRATOR_PROP_KEY + (String)name + ".active")).booleanValue()) continue;
            al.add(name);
        }
        return al.toArray(new String[al.size()]);
    }

    public String[] getMsgRcvNames() {
        Object[] names = (String[])this.props.get(MSG_RECEIVERS_NAMES_PROP_KEY);
        log.config(Arrays.toString(names));
        ArrayList<Object> al = new ArrayList<Object>();
        for (Object name : names) {
            if (this.props.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".active") == null || !((Boolean)this.props.get(MSG_RECEIVERS_PROP_KEY + (String)name + ".active")).booleanValue()) continue;
            al.add(name);
        }
        return al.toArray(new String[al.size()]);
    }

    public ComponentRegistrator getRegistrInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(REGISTRATOR_PROP_KEY + name + ".class");
        if (cls_name.equals("tigase.server.XMPPServiceCollector") || cls_name.equals("tigase.disco.XMPPServiceCollector")) {
            log.warning("This class is not used anymore. Correct your configuration please. Remove all references to class: XMPPServiceCollector.");
            return null;
        }
        return (ComponentRegistrator)Class.forName(cls_name).newInstance();
    }

    public ServerComponent getMsgRcvInstance(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String cls_name = (String)this.props.get(MSG_RECEIVERS_PROP_KEY + name + ".class");
        return (ServerComponent)Class.forName(cls_name).newInstance();
    }

    private static boolean isTrue(String val) {
        if (val == null) {
            return false;
        }
        String value = val.toLowerCase();
        return value.equals("true") || value.equals("yes") || value.equals("on") || value.equals("1");
    }

    static {
        COMPONENT_CLASSES.put("c2s", "tigase.server.xmppclient.ClientConnectionManager");
        COMPONENT_CLASSES.put("s2s", "tigase.server.xmppserver.ServerConnectionManager");
        COMPONENT_CLASSES.put("ext-comp", "tigase.server.xmppcomponent.ComponentConnectionManager");
        COMPONENT_CLASSES.put("ext", "tigase.server.ext.ComponentProtocol");
        COMPONENT_CLASSES.put("cl-comp", "tigase.cluster.ClusterConnectionManager");
        COMPONENT_CLASSES.put("sess-man", "tigase.server.xmppsession.SessionManager");
        COMPONENT_CLASSES.put("ssend", "tigase.server.ssender.StanzaSender");
        COMPONENT_CLASSES.put("srecv", "tigase.server.sreceiver.StanzaReceiver");
        COMPONENT_CLASSES.put("bosh", "tigase.server.bosh.BoshConnectionManager");
        COMPONENT_CLASSES.put("stats", "tigase.stats.StatisticsCollector");
        COMPONENT_CLASSES.put("cluster-contr", "tigase.cluster.ClusterController");
        COMPONENT_CLASSES.put("vhost-man", "tigase.vhosts.VHostManager");
        COMP_CLUS_MAP.put("tigase.server.xmppsession.SessionManager", "tigase.cluster.SessionManagerClustered");
        COMP_CLUS_MAP.put("tigase.server.xmppserver.ServerConnectionManager", "tigase.cluster.ServerConnectionClustered");
        COMP_CLUS_MAP.put("tigase.server.xmppclient.ClientConnectionManager", "tigase.cluster.ClientConnectionClustered");
        DEF_REGISTRATOR_NAMES_PROP_VAL = new String[]{"vhost-man", "stats"};
        CLUSTER_REGISTRATOR_NAMES_PROP_VAL = new String[]{"vhost-man", "stats", "cluster-contr"};
        UPDATES_CHECKING_PROP_VAL = true;
    }
}

