/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.conf.ConfiguratorAbstract;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Command;
import tigase.server.ComponentRegistrator;
import tigase.server.DisableDisco;
import tigase.server.Iq;
import tigase.server.MessageReceiver;
import tigase.server.MessageRouterConfig;
import tigase.server.MessageRouterIfc;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.ServerComponent;
import tigase.server.XMPPServer;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.UpdatesChecker;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;

public class MessageRouter
extends AbstractMessageReceiver
implements MessageRouterIfc {
    private static final Logger log = Logger.getLogger(MessageRouter.class.getName());
    private ConfiguratorAbstract config = null;
    private String disco_name = "Tigase";
    private boolean disco_show_version = true;
    private ServiceEntity serviceEntity = null;
    private UpdatesChecker updates_checker = null;
    private Map<String, XMPPService> xmppServices = new ConcurrentHashMap<String, XMPPService>();
    private Map<String, ComponentRegistrator> registrators = new ConcurrentHashMap<String, ComponentRegistrator>();
    private Map<String, MessageReceiver> receivers = new ConcurrentHashMap<String, MessageReceiver>();
    private boolean inProperties = false;
    private Map<JID, ServerComponent> components_byId = new ConcurrentHashMap<JID, ServerComponent>();
    private Map<String, ServerComponent> components = new ConcurrentHashMap<String, ServerComponent>();

    public void addComponent(ServerComponent component) {
        log.info("Adding component: " + component.getClass().getSimpleName());
        for (ComponentRegistrator registr : this.registrators.values()) {
            if (registr == component) continue;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Adding: " + component.getName() + " component to " + registr.getName() + " registrator.");
            }
            registr.addComponent(component);
        }
        this.components.put(component.getName(), component);
        this.components_byId.put(component.getComponentId(), component);
        if (component instanceof XMPPService) {
            this.xmppServices.put(component.getName(), (XMPPService)component);
        }
    }

    public void addRegistrator(ComponentRegistrator registr) {
        log.info("Adding registrator: " + registr.getClass().getSimpleName());
        this.registrators.put(registr.getName(), registr);
        this.addComponent(registr);
        for (ServerComponent comp : this.components.values()) {
            registr.addComponent(comp);
        }
    }

    public void addRouter(MessageReceiver receiver) {
        log.info("Adding receiver: " + receiver.getClass().getSimpleName());
        this.addComponent(receiver);
        this.receivers.put(receiver.getName(), receiver);
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        MessageRouterConfig.getDefaults(defs, params, this.getName());
        return defs;
    }

    @Override
    public Element getDiscoInfo(String node, JID jid, JID from) {
        Element query = this.serviceEntity.getDiscoInfo(null);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Returing disco-info: " + query.toString());
        }
        return query;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Local hostname", this.getDefHostName(), Level.INFO);
        TigaseRuntime runtime = TigaseRuntime.getTigaseRuntime();
        list.add(this.getName(), "Uptime", runtime.getUptimeString(), Level.INFO);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        list.add(this.getName(), "Load average", format.format(runtime.getLoadAverage()), Level.FINE);
        list.add(this.getName(), "CPUs no", runtime.getCPUsNumber(), Level.FINEST);
        list.add(this.getName(), "Threads count", runtime.getThreadsNumber(), Level.FINEST);
        float cpuUsage = runtime.getCPUUsage();
        format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        list.add(this.getName(), "CPU usage", format.format(cpuUsage) + "%", Level.INFO);
        MemoryUsage heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        format = NumberFormat.getIntegerInstance();
        if (format instanceof DecimalFormat) {
            DecimalFormat decf = (DecimalFormat)format;
            decf.applyPattern(decf.toPattern() + " KB");
        }
        list.add(this.getName(), "Max Heap mem", format.format(heap.getMax() / 1024L), Level.INFO);
        list.add(this.getName(), "Used Heap", format.format(heap.getUsed() / 1024L), Level.INFO);
        list.add(this.getName(), "Free Heap", format.format((heap.getMax() - heap.getUsed()) / 1024L), Level.FINE);
        list.add(this.getName(), "Max NonHeap mem", format.format(nonHeap.getMax() / 1024L), Level.FINE);
        list.add(this.getName(), "Used NonHeap", format.format(nonHeap.getUsed() / 1024L), Level.FINE);
        list.add(this.getName(), "Free NonHeap", format.format((nonHeap.getMax() - nonHeap.getUsed()) / 1024L), Level.FINE);
    }

    @Override
    public void processPacket(Packet packet) {
        ServerComponent comp;
        if (packet.getTo() == null) {
            log.warning("Packet with TO attribute set to NULL: " + packet.toString());
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing packet: " + packet.toStringSecure());
        }
        if (packet.getType() == StanzaType.error && packet.getFrom() != null && packet.getFrom().equals((Object)packet.getTo())) {
            log.warning("Possible infinite loop, dropping packet: " + packet.toStringSecure());
            return;
        }
        ServerComponent serverComponent = comp = packet.getStanzaTo() == null ? null : this.getLocalComponent(packet.getStanzaTo());
        if (packet.isServiceDisco() && packet.getType() == StanzaType.get && packet.getStanzaFrom() != null && (comp != null && !(comp instanceof DisableDisco) || this.isLocalDomain(packet.getStanzaTo().toString()))) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            this.processDiscoQuery(packet, results);
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        comp = this.getLocalComponent(packet.getTo());
        if (comp != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Packet will be processed by: " + comp.getComponentId());
            }
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            if (comp == this) {
                this.processPacketMR(packet, results);
            } else {
                comp.processPacket(packet, results);
            }
            if (results.size() > 0) {
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
            return;
        }
        String host = packet.getTo().getDomain();
        ServerComponent[] comps = this.getComponentsForLocalDomain(host);
        if (comps == null) {
            comps = this.getServerComponentsForRegex(packet.getTo().getBareJID().toString());
        }
        if (comps == null && !this.isLocalDomain(host)) {
            comps = this.getComponentsForNonLocalDomain(host);
        }
        if (comps != null) {
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            for (ServerComponent serverComponent2 : comps) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Packet will be processed by: " + serverComponent2.getComponentId());
                }
                serverComponent2.processPacket(packet, results);
                if (results.size() <= 0) continue;
                for (Packet res : results) {
                    this.addOutPacketNB(res);
                }
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("There is no component for the packet, sending it back");
            }
            try {
                this.addOutPacketNB(Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "There is no service found to process your request.", true));
            }
            catch (PacketErrorTypeException e) {
                log.warning("Can't process packet to local domain, dropping..." + packet.toStringSecure());
            }
        }
    }

    public void processPacketMR(Packet packet, Queue<Packet> results) {
        Iq iq = null;
        if (!(packet instanceof Iq)) {
            log.warning("I expect command (Iq) packet here, instead I got: " + packet.toString());
            return;
        }
        iq = (Iq)packet;
        if (packet.getPermissions() != Permissions.ADMIN) {
            try {
                Packet res = Authorization.NOT_AUTHORIZED.getResponseMessage(packet, "You are not authorized for this action.", true);
                results.offer(res);
            }
            catch (PacketErrorTypeException e) {
                log.warning("Packet processing exception: " + e);
            }
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Command received: " + iq.toString());
        }
        switch (iq.getCommand()) {
            case OTHER: {
                String[] spl;
                String cmd;
                if (iq.getStrCommand() == null || !iq.getStrCommand().startsWith("controll/") || !(cmd = (spl = iq.getStrCommand().split("/"))[1]).equals("stop")) break;
                Packet result = iq.commandResult(Command.DataType.result);
                results.offer(result);
                new Timer("Stopping...", true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        System.exit(0);
                    }
                }, 2000L);
                break;
            }
        }
    }

    @Override
    public int processingThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setConfig(ConfiguratorAbstract config) {
        this.components.put(this.getName(), this);
        this.config = config;
        this.addRegistrator(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Map<String, Object> props) {
        if (this.inProperties) {
            return;
        }
        this.inProperties = true;
        this.disco_name = (String)props.get("disco-name");
        this.disco_show_version = (Boolean)props.get("disco-show-version");
        this.serviceEntity = new ServiceEntity("Tigase", "server", "Session manager");
        this.serviceEntity.addIdentities(new ServiceIdentity("server", "im", this.disco_name + (this.disco_show_version ? " ver. " + XMPPServer.getImplementationVersion() : "")));
        this.serviceEntity.addFeatures(XMPPService.DEF_FEATURES);
        try {
            String[] msgrcv_names;
            String[] reg_names;
            super.setProperties(props);
            Map<String, ComponentRegistrator> tmp_reg = this.registrators;
            Map<String, MessageReceiver> tmp_rec = this.receivers;
            this.components = new TreeMap<String, ServerComponent>();
            this.registrators = new TreeMap<String, ComponentRegistrator>();
            this.receivers = new TreeMap<String, MessageReceiver>();
            this.setConfig(this.config);
            MessageRouterConfig conf = new MessageRouterConfig(props);
            for (String name : reg_names = conf.getRegistrNames()) {
                ComponentRegistrator cr = tmp_reg.remove(name);
                String cls_name = (String)props.get("components/registrators/" + name + ".class");
                try {
                    if (cr == null || !cr.getClass().getName().equals(cls_name)) {
                        if (cr != null) {
                            cr.release();
                        }
                        cr = conf.getRegistrInstance(name);
                        cr.setName(name);
                    }
                    this.addRegistrator(cr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (ComponentRegistrator cr : tmp_reg.values()) {
                cr.release();
            }
            tmp_reg.clear();
            for (String name : msgrcv_names = conf.getMsgRcvNames()) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Loading and registering message receiver: " + name);
                }
                ServerComponent mr = tmp_rec.remove(name);
                String cls_name = (String)props.get("components/msg-receivers/" + name + ".class");
                try {
                    if (mr == null || !mr.getClass().getName().equals(cls_name)) {
                        if (mr != null) {
                            mr.release();
                        }
                        mr = conf.getMsgRcvInstance(name);
                        mr.setName(name);
                        if (mr instanceof MessageReceiver) {
                            ((MessageReceiver)mr).setParent(this);
                            ((MessageReceiver)mr).start();
                        }
                    }
                    if (mr instanceof MessageReceiver) {
                        this.addRouter((MessageReceiver)mr);
                        continue;
                    }
                    this.addComponent(mr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (MessageReceiver mr : tmp_rec.values()) {
                mr.release();
            }
            tmp_rec.clear();
            if (((Boolean)props.get("updates-checking")).booleanValue()) {
                this.installUpdatesChecker((Long)props.get("updates-checking-interval"));
            } else {
                this.stopUpdatesChecker();
            }
        }
        finally {
            this.inProperties = false;
        }
        for (ServerComponent comp : this.components.values()) {
            log.info("Initialization completed notification to: " + comp.getName());
            comp.initializationCompleted();
        }
    }

    @Override
    protected Integer getMaxQueueSize(int def) {
        return def * 10;
    }

    private ServerComponent[] getComponentsForLocalDomain(String domain) {
        return this.vHostManager.getComponentsForLocalDomain(domain);
    }

    private ServerComponent[] getComponentsForNonLocalDomain(String domain) {
        return this.vHostManager.getComponentsForNonLocalDomain(domain);
    }

    private ServerComponent getLocalComponent(JID jid) {
        ServerComponent comp = this.components_byId.get(jid);
        if (comp != null) {
            return comp;
        }
        if (jid.getLocalpart() != null && (comp = this.components.get(jid.getLocalpart())) != null && (this.isLocalDomain(jid.getDomain()) || jid.getDomain().equals(this.getDefHostName()))) {
            return comp;
        }
        int idx = jid.getDomain().indexOf(46);
        if (idx > 0) {
            String cmpName = jid.getDomain().substring(0, idx);
            String basename = jid.getDomain().substring(idx + 1);
            comp = this.components.get(cmpName);
            if (comp != null && (this.isLocalDomain(basename) || basename.equals(this.getDefHostName()))) {
                return comp;
            }
        }
        return null;
    }

    private ServerComponent[] getServerComponentsForRegex(String id) {
        LinkedHashSet<MessageReceiver> comps = new LinkedHashSet<MessageReceiver>();
        for (MessageReceiver mr : this.receivers.values()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Checking routings for: " + mr.getName());
            }
            if (!mr.isInRegexRoutings(id)) continue;
            comps.add(mr);
        }
        if (comps.size() > 0) {
            return comps.toArray(new ServerComponent[comps.size()]);
        }
        return null;
    }

    private void installUpdatesChecker(long interval) {
        this.stopUpdatesChecker();
        this.updates_checker = new UpdatesChecker(interval, this, "This is automated message generated by updates checking module.\n You can disable this function changing configuration option: '/" + this.getName() + "/" + "updates-checking" + "' or adjust" + " updates checking interval time changing option: " + "'/" + this.getName() + "/" + "updates-checking-interval" + "' which" + " now set to " + interval + " days.");
        this.updates_checker.start();
    }

    private void processDiscoQuery(Packet packet, Queue<Packet> results) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing disco query by: " + packet.toStringSecure());
        }
        JID jid = packet.getStanzaTo();
        JID from = packet.getStanzaFrom();
        String node = packet.getAttribute("/iq/query", "node");
        Element query = packet.getElement().getChild("query").clone();
        if (packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#info")) {
            if (this.isLocalDomain(jid.toString()) && node == null) {
                query = this.getDiscoInfo(node, jid, from);
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    List<Element> features = xMPPService.getDiscoFeatures(from);
                    if (features == null) continue;
                    query.addChildren(features);
                }
            } else {
                for (XMPPService xMPPService : this.xmppServices.values()) {
                    Element resp = xMPPService.getDiscoInfo(node, jid, from);
                    if (resp == null) continue;
                    query = resp;
                    break;
                }
            }
        }
        if (packet.isXMLNS("/iq/query", "http://jabber.org/protocol/disco#items")) {
            boolean localDomain = this.isLocalDomain(jid.toString());
            if (localDomain) {
                for (XMPPService comp : this.xmppServices.values()) {
                    List<Element> items = comp.getDiscoItems(node, jid, from);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("DiscoItems processed by: " + comp.getComponentId() + ", items: " + (items == null ? null : items.toString()));
                    }
                    if (items == null || items.size() <= 0) continue;
                    query.addChildren(items);
                }
            } else {
                ServerComponent serverComponent = this.getLocalComponent(jid);
                if (serverComponent != null && serverComponent instanceof XMPPService) {
                    List<Element> items = ((XMPPService)serverComponent).getDiscoItems(node, jid, from);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("DiscoItems processed by: " + serverComponent.getComponentId() + ", items: " + (items == null ? null : items.toString()));
                    }
                    if (items != null && items.size() > 0) {
                        query.addChildren(items);
                    }
                }
            }
        }
        results.offer(packet.okResult(query, 0));
    }

    private void stopUpdatesChecker() {
        if (this.updates_checker != null) {
            this.updates_checker.interrupt();
            this.updates_checker = null;
        }
    }
}

