/*
 * Decompiled with CFR 0.152.
 */
package tigase.server;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tigase.server.BasicComponent;
import tigase.server.MessageReceiver;
import tigase.server.Packet;
import tigase.server.PacketFilterIfc;
import tigase.server.Priority;
import tigase.server.QueueType;
import tigase.server.ReceiverTimeoutHandler;
import tigase.stats.StatisticType;
import tigase.stats.StatisticsContainer;
import tigase.stats.StatisticsList;
import tigase.util.PatternComparator;
import tigase.util.PriorityQueueAbstract;

public abstract class AbstractMessageReceiver
extends BasicComponent
implements StatisticsContainer,
MessageReceiver {
    public static final String INCOMING_FILTERS_PROP_KEY = "incoming-filters";
    public static final String INCOMING_FILTERS_PROP_VAL = "tigase.server.filters.PacketCounter";
    public static final String MAX_QUEUE_SIZE_PROP_KEY = "max-queue-size";
    public static final Integer MAX_QUEUE_SIZE_PROP_VAL = new Long(Runtime.getRuntime().maxMemory() / 400000L).intValue();
    public static final String OUTGOING_FILTERS_PROP_KEY = "outgoing-filters";
    public static final String OUTGOING_FILTERS_PROP_VAL = "tigase.server.filters.PacketCounter";
    protected static final long SECOND = 1000L;
    protected static final long MINUTE = 60000L;
    protected static final long HOUR = 3600000L;
    private static final Logger log = Logger.getLogger("tigase.abstract.AbstractMessageReceiver");
    private int in_queues_size = 1;
    private long last_hour_packets = 0L;
    private long last_minute_packets = 0L;
    private long last_second_packets = 0L;
    protected int maxQueueSize = MAX_QUEUE_SIZE_PROP_VAL;
    private QueueListener out_thread = null;
    private long packetId = 0L;
    private long packets_per_hour = 0L;
    private long packets_per_minute = 0L;
    private long packets_per_second = 0L;
    private MessageReceiver parent = null;
    private int pptIdx = 0;
    private final Priority[] pr_cache = Priority.values();
    private final CopyOnWriteArrayList<PacketFilterIfc> outgoing_filters = new CopyOnWriteArrayList();
    private final PriorityQueueAbstract<Packet> out_queue = PriorityQueueAbstract.getPriorityQueue(this.pr_cache.length, this.maxQueueSize);
    private final CopyOnWriteArrayList<PacketFilterIfc> incoming_filters = new CopyOnWriteArrayList();
    private final List<PriorityQueueAbstract<Packet>> in_queues = new ArrayList<PriorityQueueAbstract<Packet>>();
    private final long[] processPacketTimings = new long[100];
    private Timer receiverTasks = null;
    private long statReceivedPacketsEr = 0L;
    private long statReceivedPacketsOk = 0L;
    private long statSentPacketsEr = 0L;
    private long statSentPacketsOk = 0L;
    private ArrayDeque<QueueListener> threadsQueue = null;
    private final ConcurrentHashMap<String, PacketReceiverTask> waitingTasks = new ConcurrentHashMap(16, 0.75f, 4);
    private final Set<Pattern> regexRoutings = new ConcurrentSkipListSet<Pattern>(new PatternComparator());

    public abstract void processPacket(Packet var1);

    @Override
    public boolean addPacket(Packet packet) {
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toStringSecure());
        }
        try {
            this.in_queues.get(queueIdx).put(packet, packet.getPriority().ordinal());
            ++this.statReceivedPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statReceivedPacketsEr;
            return false;
        }
        return true;
    }

    @Override
    public boolean addPacketNB(Packet packet) {
        boolean result;
        int queueIdx = Math.abs(this.hashCodeForPacket(packet) % this.in_queues_size);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "] queueIdx=" + queueIdx + ", " + packet.toStringSecure());
        }
        if (result = this.in_queues.get(queueIdx).offer(packet, packet.getPriority().ordinal())) {
            ++this.statReceivedPacketsOk;
        } else {
            ++this.statReceivedPacketsEr;
        }
        return result;
    }

    @Override
    public boolean addPackets(Queue<Packet> packets) {
        boolean result = true;
        Packet p = packets.peek();
        while (p != null && (result = this.addPacket(p))) {
            packets.poll();
            p = packets.peek();
        }
        return result;
    }

    public void addRegexRouting(String address) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - attempt to add regex routing: " + address);
        }
        this.regexRoutings.add(Pattern.compile(address, 2));
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.getName() + " - success adding regex routing: " + address);
        }
    }

    public void clearRegexRoutings() {
        this.regexRoutings.clear();
    }

    public synchronized void everyHour() {
        this.packets_per_hour = this.statReceivedPacketsOk - this.last_hour_packets;
        this.last_hour_packets = this.statReceivedPacketsOk;
    }

    public synchronized void everyMinute() {
        this.packets_per_minute = this.statReceivedPacketsOk - this.last_minute_packets;
        this.last_minute_packets = this.statReceivedPacketsOk;
        this.receiverTasks.purge();
    }

    public synchronized void everySecond() {
        this.packets_per_second = this.statReceivedPacketsOk - this.last_second_packets;
        this.last_second_packets = this.statReceivedPacketsOk;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> defs = super.getDefaults(params);
        String queueSize = (String)params.get("--max-queue-size");
        int queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
        if (queueSize != null) {
            try {
                queueSizeInt = Integer.parseInt(queueSize);
            }
            catch (NumberFormatException e) {
                queueSizeInt = MAX_QUEUE_SIZE_PROP_VAL;
            }
        }
        defs.put(MAX_QUEUE_SIZE_PROP_KEY, this.getMaxQueueSize(queueSizeInt));
        defs.put(INCOMING_FILTERS_PROP_KEY, "tigase.server.filters.PacketCounter");
        defs.put(OUTGOING_FILTERS_PROP_KEY, "tigase.server.filters.PacketCounter");
        return defs;
    }

    public Set<Pattern> getRegexRoutings() {
        return this.regexRoutings;
    }

    @Override
    public void getStatistics(StatisticsList list) {
        list.add(this.getName(), "Last second packets", this.packets_per_second, Level.FINE);
        list.add(this.getName(), "Last minute packets", this.packets_per_minute, Level.FINE);
        list.add(this.getName(), "Last hour packets", this.packets_per_hour, Level.FINE);
        list.add(this.getName(), StatisticType.MSG_RECEIVED_OK.getDescription(), this.statReceivedPacketsOk, Level.FINE);
        list.add(this.getName(), StatisticType.MSG_SENT_OK.getDescription(), this.statSentPacketsOk, Level.FINE);
        if (list.checkLevel(Level.FINEST)) {
            int[] in_priority_sizes = this.in_queues.get(0).size();
            for (int i = 1; i < this.in_queues.size(); ++i) {
                int[] tmp_pr_sizes = this.in_queues.get(i).size();
                for (int j = 0; j < tmp_pr_sizes.length; ++j) {
                    int n = j;
                    in_priority_sizes[n] = in_priority_sizes[n] + tmp_pr_sizes[j];
                }
            }
            int[] out_priority_sizes = this.out_queue.size();
            for (int i = 0; i < in_priority_sizes.length; ++i) {
                Priority queue = Priority.values()[i];
                list.add(this.getName(), "In queue: " + queue.name(), in_priority_sizes[queue.ordinal()], Level.FINEST);
                list.add(this.getName(), "Out queue: " + queue.name(), out_priority_sizes[queue.ordinal()], Level.FINEST);
            }
        }
        int in_queue_size = 0;
        for (PriorityQueueAbstract<Packet> total_size : this.in_queues) {
            in_queue_size += total_size.totalSize();
        }
        int out_queue_size = this.out_queue.totalSize();
        list.add(this.getName(), "Total In queues wait", in_queue_size, Level.INFO);
        list.add(this.getName(), "Total Out queues wait", out_queue_size, Level.INFO);
        list.add(this.getName(), StatisticType.MAX_QUEUE_SIZE.getDescription(), this.maxQueueSize, Level.FINEST);
        list.add(this.getName(), StatisticType.IN_QUEUE_OVERFLOW.getDescription(), this.statReceivedPacketsEr, Level.INFO);
        list.add(this.getName(), StatisticType.OUT_QUEUE_OVERFLOW.getDescription(), this.statSentPacketsEr, Level.INFO);
        long res = 0L;
        for (long ppt : this.processPacketTimings) {
            res += ppt;
        }
        long prcessingTime = res / (long)this.processPacketTimings.length;
        list.add(this.getName(), "Average processing time on last " + this.processPacketTimings.length + " runs [ms]", prcessingTime, Level.FINE);
        for (PacketFilterIfc packetFilter : this.incoming_filters) {
            packetFilter.getStatistics(list);
        }
        for (PacketFilterIfc packetFilter : this.outgoing_filters) {
            packetFilter.getStatistics(list);
        }
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getFrom() != null && packet.getFrom() != packet.getStanzaFrom()) {
            return packet.getFrom().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        if (packet.getTo() != null) {
            return packet.getTo().hashCode();
        }
        return 1;
    }

    @Override
    public boolean isInRegexRoutings(String address) {
        for (Pattern pat : this.regexRoutings) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " matching: " + address + " against " + pat.toString());
            }
            if (!pat.matcher(address).matches()) continue;
            return true;
        }
        return false;
    }

    public String newPacketId(String prefix) {
        StringBuilder sb = new StringBuilder(32);
        if (prefix != null) {
            sb.append(prefix).append("-");
        }
        sb.append(this.getName()).append(++this.packetId);
        return sb.toString();
    }

    @Override
    public final void processPacket(Packet packet, Queue<Packet> results) {
        this.addPacketNB(packet);
    }

    public int processingThreads() {
        return 1;
    }

    @Override
    public void release() {
        this.stop();
    }

    public boolean removeRegexRouting(String address) {
        return this.regexRoutings.remove(Pattern.compile(address, 2));
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (this.maxQueueSize != maxQueueSize || this.in_queues.size() == 0) {
            this.maxQueueSize = maxQueueSize / this.processingThreads();
            if (this.in_queues.size() == 0) {
                for (int i = 0; i < this.in_queues_size; ++i) {
                    PriorityQueueAbstract queue = PriorityQueueAbstract.getPriorityQueue(this.pr_cache.length, maxQueueSize);
                    this.in_queues.add(queue);
                }
            } else {
                for (int i = 0; i < this.in_queues.size(); ++i) {
                    this.in_queues.get(i).setMaxSize(maxQueueSize);
                }
            }
            this.out_queue.setMaxSize(maxQueueSize);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.in_queues_size = this.processingThreads();
        this.setMaxQueueSize(this.maxQueueSize);
    }

    @Override
    public void setParent(MessageReceiver parent) {
        this.parent = parent;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        PacketFilterIfc filter;
        super.setProperties(props);
        int queueSize = (Integer)props.get(MAX_QUEUE_SIZE_PROP_KEY);
        this.setMaxQueueSize(queueSize);
        this.incoming_filters.clear();
        this.outgoing_filters.clear();
        String filters = (String)props.get(INCOMING_FILTERS_PROP_KEY);
        if (filters != null && !filters.trim().isEmpty()) {
            String[] incoming;
            for (String inc : incoming = filters.trim().split(",")) {
                try {
                    filter = (PacketFilterIfc)Class.forName(inc).newInstance();
                    filter.init(this.getName(), QueueType.IN_QUEUE);
                    this.incoming_filters.add(filter);
                    log.config(this.getName() + " loaded incoming filter: " + inc);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Problem loading filter: " + inc + " in component: " + this.getName(), e);
                }
            }
        }
        if ((filters = (String)props.get(OUTGOING_FILTERS_PROP_KEY)) != null && !filters.trim().isEmpty()) {
            String[] outgoing;
            for (String out : outgoing = filters.trim().split(",")) {
                try {
                    filter = (PacketFilterIfc)Class.forName(out).newInstance();
                    filter.init(this.getName(), QueueType.OUT_QUEUE);
                    this.outgoing_filters.add(filter);
                    log.config(this.getName() + " loaded outgoing filter: " + out);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Problem loading filter: " + out + " in component: " + this.getName(), e);
                }
            }
        }
    }

    @Override
    public void start() {
        if (log.isLoggable(Level.FINER)) {
            log.info(this.getName() + ": starting queue management threads ...");
        }
        this.startThreads();
    }

    public void stop() {
        if (log.isLoggable(Level.FINER)) {
            log.info(this.getName() + ": stopping queue management threads ...");
        }
        this.stopThreads();
    }

    protected boolean addOutPacket(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toStringSecure());
        }
        try {
            this.out_queue.put(packet, packet.getPriority().ordinal());
            ++this.statSentPacketsOk;
        }
        catch (InterruptedException e) {
            ++this.statSentPacketsEr;
            return false;
        }
        return true;
    }

    protected boolean addOutPacketNB(Packet packet) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("[" + this.getName() + "]  " + packet.toStringSecure());
        }
        boolean result = false;
        result = this.out_queue.offer(packet, packet.getPriority().ordinal());
        if (result) {
            ++this.statSentPacketsOk;
        } else {
            ++this.statSentPacketsEr;
        }
        return result;
    }

    protected boolean addOutPacketWithTimeout(Packet packet, ReceiverTimeoutHandler handler, long delay, TimeUnit unit) {
        new PacketReceiverTask(handler, delay, unit, packet);
        return this.addOutPacket(packet);
    }

    protected boolean addOutPackets(Queue<Packet> packets) {
        Packet p = null;
        boolean result = true;
        while ((p = packets.peek()) != null) {
            result = this.addOutPacket(p);
            if (result) {
                packets.poll();
                continue;
            }
            return false;
        }
        return true;
    }

    protected void addTimerTask(TimerTask task, long delay, TimeUnit unit) {
        this.receiverTasks.schedule(task, unit.toMillis(delay));
    }

    protected void addTimerTask(TimerTask task, long delay) {
        this.receiverTasks.schedule(task, delay);
    }

    protected Integer getMaxQueueSize(int def) {
        return def;
    }

    private Packet filterPacket(Packet packet, CopyOnWriteArrayList<PacketFilterIfc> filters) {
        PacketFilterIfc packetFilterIfc;
        Packet result = packet;
        Iterator<PacketFilterIfc> i$ = filters.iterator();
        while (i$.hasNext() && (result = (packetFilterIfc = i$.next()).filter(result)) != null) {
        }
        return result;
    }

    private void startThreads() {
        if (this.threadsQueue == null) {
            this.threadsQueue = new ArrayDeque();
            for (int i = 0; i < this.in_queues_size; ++i) {
                QueueListener in_thread = new QueueListener(this.in_queues.get(i), QueueType.IN_QUEUE);
                in_thread.setName("in_" + i + "-" + this.getName());
                in_thread.start();
                this.threadsQueue.add(in_thread);
            }
        }
        if (this.out_thread == null || !this.out_thread.isAlive()) {
            this.out_thread = new QueueListener(this.out_queue, QueueType.OUT_QUEUE);
            this.out_thread.setName("out_" + this.getName());
            this.out_thread.start();
        }
        this.receiverTasks = new Timer(this.getName() + " tasks", true);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everySecond();
            }
        }, 1000L, 1000L);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyMinute();
            }
        }, 60000L, 60000L);
        this.receiverTasks.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                AbstractMessageReceiver.this.everyHour();
            }
        }, 3600000L, 3600000L);
    }

    private void stopThreads() {
        try {
            if (this.threadsQueue != null) {
                for (QueueListener in_thread : this.threadsQueue) {
                    in_thread.threadStopped = true;
                    in_thread.interrupt();
                    while (in_thread.isAlive()) {
                        Thread.sleep(100L);
                    }
                }
            }
            if (this.out_thread != null) {
                this.out_thread.threadStopped = true;
                this.out_thread.interrupt();
                while (this.out_thread.isAlive()) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.threadsQueue = null;
        this.out_thread = null;
        if (this.receiverTasks != null) {
            this.receiverTasks.cancel();
            this.receiverTasks = null;
        }
    }

    private class QueueListener
    extends Thread {
        private QueueType type = null;
        private boolean threadStopped = false;
        private PriorityQueueAbstract<Packet> queue;

        private QueueListener(PriorityQueueAbstract<Packet> q, QueueType type) {
            this.queue = q;
            this.type = type;
        }

        @Override
        public void run() {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.getName() + " starting queue processing.");
            }
            Packet packet = null;
            ArrayDeque<Packet> results = new ArrayDeque<Packet>();
            block7: while (!this.threadStopped) {
                try {
                    packet = this.queue.take();
                    switch (this.type) {
                        case IN_QUEUE: {
                            long startPPT = System.currentTimeMillis();
                            PacketReceiverTask task = null;
                            if (packet.getTo() != null) {
                                String id = packet.getTo().toString() + packet.getStanzaId();
                                task = (PacketReceiverTask)AbstractMessageReceiver.this.waitingTasks.remove(id);
                            }
                            if (task != null) {
                                task.handleResponse(packet);
                                continue block7;
                            }
                            boolean processed = false;
                            if (packet.isCommand() && AbstractMessageReceiver.this.getComponentId().equals((Object)packet.getStanzaTo()) && (processed = AbstractMessageReceiver.this.processScriptCommand(packet, results))) {
                                Packet result = null;
                                while ((result = (Packet)results.poll()) != null) {
                                    AbstractMessageReceiver.this.addOutPacket(result);
                                }
                            }
                            if (!processed && (packet = AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.incoming_filters)) != null) {
                                AbstractMessageReceiver.this.processPacket(packet);
                            }
                            ((AbstractMessageReceiver)AbstractMessageReceiver.this).processPacketTimings[((AbstractMessageReceiver)AbstractMessageReceiver.this).pptIdx] = System.currentTimeMillis() - startPPT;
                            AbstractMessageReceiver.this.pptIdx = (AbstractMessageReceiver.this.pptIdx + 1) % AbstractMessageReceiver.this.processPacketTimings.length;
                            continue block7;
                        }
                        case OUT_QUEUE: {
                            if ((packet = AbstractMessageReceiver.this.filterPacket(packet, AbstractMessageReceiver.this.outgoing_filters)) == null) continue block7;
                            if (AbstractMessageReceiver.this.parent != null) {
                                AbstractMessageReceiver.this.parent.addPacket(packet);
                                continue block7;
                            }
                            AbstractMessageReceiver.this.addPacketNB(packet);
                            continue block7;
                        }
                    }
                    log.severe("Unknown queue element type: " + (Object)((Object)this.type));
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "[" + this.getName() + "] Exception during packet processing: " + packet.toStringSecure(), e);
                }
            }
        }
    }

    private class PacketReceiverTask
    extends TimerTask {
        private ReceiverTimeoutHandler handler = null;
        private String id = null;
        private Packet packet = null;

        private PacketReceiverTask(ReceiverTimeoutHandler handler, long delay, TimeUnit unit, Packet packet) {
            this.handler = handler;
            this.packet = packet;
            this.id = packet.getFrom().toString() + packet.getStanzaId();
            AbstractMessageReceiver.this.waitingTasks.put(this.id, this);
            AbstractMessageReceiver.this.receiverTasks.schedule((TimerTask)this, unit.toMillis(delay));
        }

        public void handleResponse(Packet response) {
            this.cancel();
            this.handler.responseReceived(this.packet, response);
        }

        public void handleTimeout() {
            AbstractMessageReceiver.this.waitingTasks.remove(this.id);
            this.handler.timeOutExpired(this.packet);
        }

        @Override
        public void run() {
            this.handleTimeout();
        }
    }
}

